/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.core.utils.BlobsExtractor;
import org.nuxeo.ecm.quota.AbstractQuotaStatsUpdater;
import org.nuxeo.ecm.quota.QuotaStatsInitialWork;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaAwareDocumentFactory;
import org.nuxeo.ecm.quota.size.QuotaExceededException;
import org.nuxeo.ecm.quota.size.QuotaSizeService;
import org.nuxeo.runtime.api.Framework;

public class DocumentsSizeUpdater
extends AbstractQuotaStatsUpdater {
    private static Log log = LogFactory.getLog(DocumentsSizeUpdater.class);
    public static final String DISABLE_QUOTA_CHECK_LISTENER = "disableQuotaListener";
    public static final String USER_WORKSPACES_ROOT = "UserWorkspacesRoot";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeInitialStatistics(CoreSession session, QuotaStatsInitialWork currentWorker, String path) {
        DocumentModel root;
        log.debug((Object)("Starting initial Quota computation for path: " + path));
        String query = "SELECT ecm:uuid FROM Document WHERE ecm:isVersion = 0 AND ecm:isProxy = 0";
        if (path == null) {
            root = session.getRootDocument();
        } else {
            root = session.getDocument((DocumentRef)new PathRef(path));
            query = query + " AND ecm:path STARTSWITH " + NXQL.escapeString((String)path);
        }
        long count = 0L;
        try (IterableQueryResult res = session.queryAndFetch(query, "NXQL", new Object[0]);){
            count = res.size();
            log.debug((Object)("Start iteration on " + count + " items"));
            for (Map r : res) {
                String uuid = (String)r.get("ecm:uuid");
                this.clearQuotas(session, uuid);
            }
        }
        this.clearQuotas(session, root.getId());
        session.save();
        res = session.queryAndFetch(query, "NXQL", new Object[0]);
        try {
            long idx = 0L;
            for (Map r : res) {
                String uuid = (String)r.get("ecm:uuid");
                DocumentModel doc = session.getDocument((DocumentRef)new IdRef(uuid));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("process Quota initial computation on uuid " + doc.getId()));
                    log.trace((Object)("doc with uuid " + doc.getId() + " started update"));
                }
                this.initDocument(session, doc);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("doc with uuid " + doc.getId() + " update completed"));
                }
                currentWorker.notifyProgress(++idx, count);
            }
        }
        finally {
            res.close();
        }
        if (path != null) {
            DocumentModel doc = root;
            do {
                doc = session.getDocument(doc.getParentRef());
                this.initDocumentFromChildren(doc);
            } while (!doc.getPathAsString().equals("/"));
        }
    }

    protected void clearQuotas(CoreSession session, String docID) {
        DocumentModel doc = session.getDocument((DocumentRef)new IdRef(docID));
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (quotaDoc != null) {
            quotaDoc.clearInfos();
            quotaDoc.save();
        }
    }

    protected void initDocument(CoreSession session, DocumentModel doc) {
        boolean isDeleted = doc.isTrashed();
        long size = this.getBlobsSize(doc);
        long versionsSize = this.getVersionsSize(session, doc);
        this.updateDocumentAndAncestors(session, doc, size, size + versionsSize, isDeleted ? size : 0L, versionsSize);
    }

    protected void initDocumentFromChildren(DocumentModel doc) {
        CoreSession session = doc.getCoreSession();
        boolean isDeleted = doc.isTrashed();
        long innerSize = this.getBlobsSize(doc);
        long versionsSize = this.getVersionsSize(session, doc);
        long totalSize = innerSize + versionsSize;
        long trashSize = isDeleted ? innerSize : 0L;
        for (DocumentModel child : session.getChildren(doc.getRef())) {
            QuotaAware quotaDoc = (QuotaAware)child.getAdapter(QuotaAware.class);
            if (quotaDoc == null) continue;
            totalSize += quotaDoc.getTotalSize();
            trashSize += quotaDoc.getTrashSize();
            versionsSize += quotaDoc.getVersionsSize();
        }
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (quotaDoc == null) {
            quotaDoc = QuotaAwareDocumentFactory.make(doc);
        }
        quotaDoc.setAll(innerSize, totalSize, trashSize, versionsSize);
        quotaDoc.save();
    }

    @Override
    protected void handleQuotaExceeded(QuotaExceededException e, Event event) {
        String msg = "Current event " + event.getName() + " would break Quota restriction, rolling back";
        log.info((Object)msg);
        e.addInfo(msg);
        event.markRollBack("Quota Exceeded", (Exception)((Object)e));
    }

    @Override
    protected void processDocumentCreated(CoreSession session, DocumentModel doc) {
        if (doc.isVersion()) {
            return;
        }
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (quotaDoc == null) {
            quotaDoc = QuotaAwareDocumentFactory.make(doc);
            quotaDoc.save();
        }
        long size = this.getBlobsSize(doc);
        this.checkQuota(session, doc, size);
        this.updateDocumentAndAncestors(session, doc, size, size, 0L, 0L);
    }

    @Override
    protected void processDocumentCheckedIn(CoreSession session, DocumentModel doc) {
        long size = this.getBlobsSize(doc);
        this.updateDocumentAndAncestors(session, doc, 0L, size, 0L, size);
    }

    @Override
    protected void processDocumentCheckedOut(CoreSession session, DocumentModel doc) {
        long size = this.getBlobsSize(doc);
        this.checkQuota(session, doc, size);
    }

    @Override
    protected void processDocumentUpdated(CoreSession session, DocumentModel doc) {
    }

    @Override
    protected void processDocumentBeforeUpdate(CoreSession session, DocumentModel doc) {
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        long oldSize = quotaDoc == null ? 0L : quotaDoc.getInnerSize();
        long delta = this.getBlobsSize(doc) - oldSize;
        this.checkQuota(session, doc, delta);
        this.updateDocument(doc, delta, delta, 0L, 0L, false);
        this.updateAncestors(session, doc, delta, 0L, 0L);
    }

    @Override
    protected void processDocumentCopied(CoreSession session, DocumentModel doc) {
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (quotaDoc == null) {
            return;
        }
        long size = quotaDoc.getTotalSize() - quotaDoc.getVersionsSize() - quotaDoc.getTrashSize();
        this.checkQuota(session, doc, size);
        if (!doc.isFolder() && size > 0L) {
            quotaDoc.resetInfos();
            quotaDoc.save();
            this.updateDocument(doc, size, size, 0L, 0L);
        }
        this.updateAncestors(session, doc, size, 0L, 0L);
    }

    @Override
    protected void processDocumentMoved(CoreSession session, DocumentModel doc, DocumentModel sourceParent) {
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        long size = quotaDoc == null ? 0L : quotaDoc.getTotalSize();
        this.checkQuota(session, doc, size);
        long versionsSize = quotaDoc == null ? 0L : quotaDoc.getVersionsSize();
        this.updateAncestors(session, doc, size, 0L, versionsSize);
        if (sourceParent != null) {
            this.updateDocumentAndAncestors(session, sourceParent, 0L, -size, 0L, -versionsSize);
        }
    }

    @Override
    protected void processDocumentAboutToBeRemoved(CoreSession session, DocumentModel doc) {
        long versionsSize;
        long size;
        if (doc.isVersion()) {
            long size2 = this.getBlobsSize(doc);
            String sourceId = doc.getSourceId();
            if (size2 > 0L && sourceId != null) {
                DocumentModel liveDoc = session.getDocument((DocumentRef)new IdRef(sourceId));
                this.updateDocumentAndAncestors(session, liveDoc, 0L, -size2, 0L, -size2);
            }
            return;
        }
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (quotaDoc == null) {
            size = this.getBlobsSize(doc);
            versionsSize = 0L;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Document " + doc.getId() + " doesn't have the facet quotaDoc. Compute impacted size:" + size));
            }
        } else {
            size = quotaDoc.getTotalSize();
            versionsSize = quotaDoc.getVersionsSize();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Found facet quotaDoc on document  " + doc.getId() + ". Total size: " + size + " and versions size: " + versionsSize));
            }
        }
        boolean isDeleted = doc.isTrashed();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Processing document about to be removed on parents. Total: " + size + " , trash size: " + (isDeleted ? size : 0L) + " , versions size: " + versionsSize));
        }
        long deltaTrash = isDeleted ? versionsSize - size : 0L;
        this.updateAncestors(session, doc, -size, deltaTrash, -versionsSize);
    }

    @Override
    protected void processDocumentTrashOp(CoreSession session, DocumentModel doc, String transition) {
        boolean isDelete;
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (quotaDoc == null) {
            return;
        }
        long size = quotaDoc.getInnerSize();
        if (log.isTraceEnabled() && quotaDoc.getDoc().isFolder()) {
            log.trace((Object)(quotaDoc.getDoc().getPathAsString() + " is a folder, just inner size (" + size + ") taken into account for trash size"));
        }
        long delta = (isDelete = "delete".equals(transition)) ? size : -size;
        this.updateDocumentAndAncestors(session, doc, 0L, 0L, delta, 0L);
    }

    @Override
    protected void processDocumentBeforeRestore(CoreSession session, DocumentModel doc) {
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (quotaDoc == null) {
            return;
        }
        long size = quotaDoc.getTotalSize();
        long versionsSize = quotaDoc.getVersionsSize();
        this.updateAncestors(session, doc, -size, 0L, -versionsSize);
    }

    @Override
    protected void processDocumentRestored(CoreSession session, DocumentModel doc) {
        QuotaAware quotaDoc = QuotaAwareDocumentFactory.make(doc);
        quotaDoc.resetInfos();
        quotaDoc.save();
        long size = this.getBlobsSize(doc);
        long versionsSize = this.getVersionsSize(session, doc);
        this.updateDocumentAndAncestors(session, doc, size, size + versionsSize, 0L, versionsSize);
    }

    @Override
    protected boolean needToProcessEventOnDocument(Event event, DocumentModel doc) {
        if (doc == null) {
            return false;
        }
        if (doc.isProxy()) {
            return false;
        }
        return !Boolean.TRUE.equals(doc.getContextData(DISABLE_QUOTA_CHECK_LISTENER));
    }

    protected void checkQuota(CoreSession session, DocumentModel doc, long delta) {
        if (delta <= 0L) {
            return;
        }
        for (DocumentModel parent : this.getAncestors(session, doc)) {
            QuotaAware quotaDoc;
            if (log.isTraceEnabled()) {
                log.trace((Object)("processing " + parent.getId() + " " + parent.getPathAsString()));
            }
            if ((quotaDoc = (QuotaAware)parent.getAdapter(QuotaAware.class)) == null || quotaDoc.getMaxQuota() <= 0L || USER_WORKSPACES_ROOT.equals(parent.getType()) || quotaDoc.getTotalSize() + delta <= quotaDoc.getMaxQuota()) continue;
            log.info((Object)("Raising Quota Exception on " + doc.getId() + " (" + doc.getPathAsString() + ")"));
            throw new QuotaExceededException(parent, doc, quotaDoc.getMaxQuota());
        }
    }

    protected long getVersionsSize(CoreSession session, DocumentModel doc) {
        long versionsSize = 0L;
        for (DocumentModel version : session.getVersions(doc.getRef())) {
            versionsSize += this.getBlobsSize(version);
        }
        return versionsSize;
    }

    protected long getBlobsSize(DocumentModel doc) {
        long size = 0L;
        for (Blob blob : this.getAllBlobs(doc)) {
            size += blob.getLength();
        }
        return size;
    }

    protected List<Blob> getAllBlobs(DocumentModel doc) {
        QuotaSizeService sizeService = (QuotaSizeService)Framework.getService(QuotaSizeService.class);
        Collection<String> excludedPaths = sizeService.getExcludedPathList();
        BlobsExtractor extractor = new BlobsExtractor();
        extractor.setExtractorProperties(null, new HashSet<String>(excludedPaths), true);
        return extractor.getBlobs(doc);
    }

    protected void updateDocument(DocumentModel doc, long deltaInner, long deltaTotal, long deltaTrash, long deltaVersions) {
        this.updateDocument(doc, deltaInner, deltaTotal, deltaTrash, deltaVersions, true);
    }

    protected void updateDocument(DocumentModel doc, long deltaInner, long deltaTotal, long deltaTrash, long deltaVersions, boolean allowSave) {
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        boolean save = false;
        if (quotaDoc == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("   add quota on: " + doc.getId() + " (" + doc.getPathAsString() + ")"));
            }
            quotaDoc = QuotaAwareDocumentFactory.make(doc);
            save = true;
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("   update quota on: " + doc.getId() + " (" + doc.getPathAsString() + ") (" + quotaDoc.getQuotaInfo() + ")"));
        }
        if (deltaInner != 0L) {
            quotaDoc.addInnerSize(deltaInner);
            save = true;
        }
        if (deltaTotal != 0L) {
            quotaDoc.addTotalSize(deltaTotal);
            save = true;
        }
        if (deltaTrash != 0L) {
            quotaDoc.addTrashSize(deltaTrash);
            save = true;
        }
        if (deltaVersions != 0L) {
            quotaDoc.addVersionsSize(deltaVersions);
            save = true;
        }
        if (save && allowSave) {
            quotaDoc.save();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("     ==> " + doc.getId() + " (" + doc.getPathAsString() + ") (" + quotaDoc.getQuotaInfo() + ")"));
        }
    }

    protected void updateAncestors(CoreSession session, DocumentModel doc, long deltaTotal, long deltaTrash, long deltaVersions) {
        if (deltaTotal == 0L && deltaTrash == 0L && deltaVersions == 0L) {
            return;
        }
        List<DocumentModel> ancestors = this.getAncestors(session, doc);
        for (DocumentModel ancestor : ancestors) {
            this.updateDocument(ancestor, 0L, deltaTotal, deltaTrash, deltaVersions);
        }
    }

    protected void updateDocumentAndAncestors(CoreSession session, DocumentModel doc, long deltaInner, long deltaTotal, long deltaTrash, long deltaVersions) {
        this.updateDocument(doc, deltaInner, deltaTotal, deltaTrash, deltaVersions);
        this.updateAncestors(session, doc, deltaTotal, deltaTrash, deltaVersions);
    }
}

