/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterFactory;
import org.nuxeo.ecm.quota.QuotaUtils;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaAwareDocument;

public class QuotaAwareDocumentFactory
implements DocumentAdapterFactory {
    public static QuotaAware make(DocumentModel doc) {
        if (!doc.hasFacet("DocumentsSizeStatistics")) {
            doc.addFacet("DocumentsSizeStatistics");
        }
        return new QuotaAwareDocument(doc);
    }

    public static void unmake(DocumentModel doc) {
        if (doc.hasFacet("DocumentsSizeStatistics")) {
            new QuotaAwareDocument(doc).resetInfos();
            QuotaAwareDocumentFactory.saveDocument(doc);
            doc.removeFacet("DocumentsSizeStatistics");
            QuotaAwareDocumentFactory.saveDocument(doc);
        }
    }

    protected static DocumentModel saveDocument(DocumentModel doc) {
        doc.putContextData("disableQuotaListener", (Serializable)Boolean.TRUE);
        QuotaUtils.disableListeners(doc);
        DocumentModel origDoc = doc;
        doc = doc.getCoreSession().saveDocument(doc);
        QuotaUtils.clearContextData(doc);
        QuotaUtils.clearContextData(origDoc);
        return doc;
    }

    public Object getAdapter(DocumentModel doc, Class<?> adapter) {
        if (doc.hasFacet("DocumentsSizeStatistics")) {
            return adapter.cast(new QuotaAwareDocument(doc));
        }
        return null;
    }
}

