/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.count;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.quota.QuotaStatsService;
import org.nuxeo.ecm.quota.QuotaStatsUpdater;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaDisplayValue;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.runtime.api.Framework;

@Name(value="quotaStatsActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class QuotaStatsActions
implements Serializable {
    protected Log log = LogFactory.getLog(QuotaStatsActions.class);
    private static final long serialVersionUID = -1L;
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected Map<String, String> messages;
    private transient ConfigurationGenerator setupConfigGenerator;
    protected QuotaStatsService quotaStatsService;
    protected boolean activateQuotaOnUsersWorkspaces;
    protected long maxQuotaOnUsersWorkspaces = -1L;
    protected WorkManager workManager;

    @Create
    public void initialize() {
        this.initQuotaActivatedOnUserWorkspaces();
    }

    public List<QuotaStatsUpdater> getQuotaStatsUpdaters() {
        QuotaStatsService quotaStatsService = (QuotaStatsService)Framework.getLocalService(QuotaStatsService.class);
        return quotaStatsService.getQuotaStatsUpdaters();
    }

    public void launchInitialComputation(String updaterName) {
        this.launchInitialComputation(updaterName, this.documentManager.getRepositoryName());
    }

    public void launchInitialComputation(String updaterName, String repositoryName) {
        QuotaStatsService quotaStatsService = (QuotaStatsService)Framework.getLocalService(QuotaStatsService.class);
        quotaStatsService.launchInitialStatisticsComputation(updaterName, repositoryName);
    }

    public String getStatus(String updaterName) {
        QuotaStatsService quotaStatsService = (QuotaStatsService)Framework.getLocalService(QuotaStatsService.class);
        return quotaStatsService.getProgressStatus(updaterName, this.documentManager.getRepositoryName());
    }

    @Factory(value="currentQuotaDoc", scope=ScopeType.EVENT)
    public QuotaAware getQuotaDoc() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        return (QuotaAware)doc.getAdapter(QuotaAware.class);
    }

    public void validateQuotaSize(FacesContext context, UIComponent component, Object value) {
        String strValue = value.toString();
        Long quotaValue = -1L;
        boolean quotaAllowed = true;
        try {
            quotaValue = Long.parseLong(strValue);
        }
        catch (NumberFormatException e) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, this.messages.get("wrong format"), null);
            context.addMessage(null, message);
            throw new ValidatorException(message);
        }
        quotaAllowed = this.getQuotaStatsService().canSetMaxQuota(quotaValue.longValue(), this.navigationContext.getCurrentDocument(), this.documentManager);
        if (quotaAllowed) {
            return;
        }
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, this.messages.get("label.quotaException.QuotaCanNotBeSet"), null);
        context.addMessage(null, message);
        throw new ValidatorException(message);
    }

    public QuotaDisplayValue formatQuota(long value, long max) {
        QuotaDisplayValue qdv = new QuotaDisplayValue(value, max);
        return qdv;
    }

    public double getMinQuotaSliderValue(long totalSize) {
        long minSize = 102400L;
        if (totalSize > minSize) {
            return Math.log(totalSize + minSize);
        }
        return Math.log(minSize);
    }

    public long getMinQuotaSliderValue() {
        return 102400L;
    }

    public long getMaxQuotaSliderValue() {
        long maxQuotaSize = -1L;
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if (doc != null) {
            maxQuotaSize = this.getQuotaStatsService().getQuotaFromParent(doc, this.documentManager);
        }
        return maxQuotaSize > 0L ? maxQuotaSize : 1072668082176L;
    }

    public void saveQuotaActivatedOnUsersWorkspaces() {
        long maxSize = -1L;
        if (this.isActivateQuotaOnUsersWorkspaces()) {
            maxSize = this.getMaxQuotaOnUsersWorkspaces();
        }
        this.getQuotaStatsService().activateQuotaOnUserWorkspaces(maxSize, this.documentManager);
        this.getQuotaStatsService().launchSetMaxQuotaOnUserWorkspaces(maxSize, this.documentManager.getRootDocument(), this.documentManager);
    }

    public void initQuotaActivatedOnUserWorkspaces() {
        long quota = this.getQuotaStatsService().getQuotaSetOnUserWorkspaces(this.documentManager);
        this.setActivateQuotaOnUsersWorkspaces(quota != -1L);
        this.setMaxQuotaOnUsersWorkspaces(quota);
    }

    public boolean workQueuesInProgess() {
        int scheduled;
        WorkManager workManager = this.getWorkManager();
        int running = workManager.getQueueSize("quota", Work.State.RUNNING);
        return running + (scheduled = workManager.getQueueSize("quota", Work.State.SCHEDULED)) > 0;
    }

    public boolean isQuotaSetOnCurrentDocument() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if ("UserWorkspacesRoot".equals(doc.getType())) {
            return true;
        }
        QuotaAware qa = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (qa == null) {
            return false;
        }
        long maxSize = qa.getMaxQuota();
        return maxSize > 0L;
    }

    public boolean isActivateQuotaOnUsersWorkspaces() {
        return this.activateQuotaOnUsersWorkspaces;
    }

    public void setActivateQuotaOnUsersWorkspaces(boolean activateQuotaOnUsersWorkspaces) {
        this.activateQuotaOnUsersWorkspaces = activateQuotaOnUsersWorkspaces;
    }

    public long getMaxQuotaOnUsersWorkspaces() {
        return this.maxQuotaOnUsersWorkspaces;
    }

    public void setMaxQuotaOnUsersWorkspaces(long maxQuotaOnUsersWorkspaces) {
        this.maxQuotaOnUsersWorkspaces = maxQuotaOnUsersWorkspaces;
    }

    QuotaStatsService getQuotaStatsService() {
        if (this.quotaStatsService == null) {
            this.quotaStatsService = (QuotaStatsService)Framework.getLocalService(QuotaStatsService.class);
        }
        return this.quotaStatsService;
    }

    protected WorkManager getWorkManager() {
        if (this.workManager == null) {
            this.workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        }
        return this.workManager;
    }
}

