/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.utils.BlobsExtractor;
import org.nuxeo.ecm.quota.AbstractQuotaStatsUpdater;
import org.nuxeo.ecm.quota.QuotaStatsInitialWork;
import org.nuxeo.ecm.quota.QuotaUtils;
import org.nuxeo.ecm.quota.size.BlobSizeInfo;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaAwareDocumentFactory;
import org.nuxeo.ecm.quota.size.QuotaComputerProcessor;
import org.nuxeo.ecm.quota.size.QuotaExceededException;
import org.nuxeo.ecm.quota.size.QuotaSizeService;
import org.nuxeo.ecm.quota.size.SizeUpdateEventContext;
import org.nuxeo.runtime.api.Framework;

public class QuotaSyncListenerChecker
extends AbstractQuotaStatsUpdater {
    public static final String DISABLE_QUOTA_CHECK_LISTENER = "disableQuotaListener";
    private static Log log = LogFactory.getLog(QuotaSyncListenerChecker.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeInitialStatistics(CoreSession unrestrictedSession, QuotaStatsInitialWork currentWorker) {
        QuotaComputerProcessor processor = new QuotaComputerProcessor();
        String query = "SELECT ecm:uuid FROM Document where ecm:isCheckedInVersion=0 and ecm:isProxy=0 order by dc:created desc";
        IterableQueryResult res = unrestrictedSession.queryAndFetch(query, "NXQL", new Object[0]);
        log.debug((Object)"Starting initial Quota computation");
        long total = res.size();
        log.debug((Object)("Start iteration on " + total + " items"));
        try {
            for (Map r : res) {
                String uuid = (String)r.get("ecm:uuid");
                this.removeFacet(unrestrictedSession, uuid);
            }
        }
        finally {
            res.close();
        }
        this.removeFacet(unrestrictedSession, unrestrictedSession.getRootDocument().getId());
        unrestrictedSession.save();
        try {
            long idx = 0L;
            res = unrestrictedSession.queryAndFetch(query, "NXQL", new Object[0]);
            for (Map r : res) {
                String uuid = (String)r.get("ecm:uuid");
                this.computeSizeOnDocument(unrestrictedSession, uuid, processor);
                currentWorker.notifyProgress(++idx, total);
            }
        }
        finally {
            res.close();
        }
    }

    private void removeFacet(CoreSession unrestrictedSession, String uuid) {
        DocumentModel target = unrestrictedSession.getDocument((DocumentRef)new IdRef(uuid));
        if (target.hasFacet("DocumentsSizeStatistics")) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("doc with uuid " + uuid + " already up to date"));
            }
            QuotaAware quotaDoc = (QuotaAware)target.getAdapter(QuotaAware.class);
            quotaDoc.resetInfos(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)(target.getPathAsString() + " reset to " + quotaDoc.getQuotaInfo()));
            }
            target.removeFacet("DocumentsSizeStatistics");
            DocumentModel origTarget = target;
            QuotaUtils.disableListeners(target);
            target = unrestrictedSession.saveDocument(target);
            QuotaUtils.clearContextData(target);
            QuotaUtils.clearContextData(origTarget);
        }
    }

    protected void computeSizeOnDocument(CoreSession unrestrictedSession, String uuid, QuotaComputerProcessor processor) {
        IdRef ref = new IdRef(uuid);
        DocumentModel target = unrestrictedSession.getDocument((DocumentRef)ref);
        if (log.isTraceEnabled()) {
            log.trace((Object)("process Quota initial computation on uuid " + uuid));
        }
        if (unrestrictedSession.exists((DocumentRef)ref)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("doc with uuid " + uuid + " started update"));
            }
            SizeUpdateEventContext quotaCtx = this.updateEventToProcessNewDocument(unrestrictedSession, target);
            quotaCtx.setProperty("sourceEvent", (Serializable)((Object)"documentUpdateInitialStats"));
            quotaCtx.getProperties().put("_UPDATE_TRASH", "deleted".equals(target.getCurrentLifeCycleState()));
            processor.processQuotaComputation(quotaCtx);
            if (log.isTraceEnabled()) {
                log.trace((Object)("doc with uuid " + uuid + " update completed"));
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("doc with uuid " + uuid + " does not exist"));
        }
    }

    @Override
    protected void handleQuotaExceeded(QuotaExceededException e, Event event) {
        String msg = "Current event " + event.getName() + " would break Quota restriction, rolling back";
        log.info((Object)msg);
        e.addInfo(msg);
        event.markRollBack("Quota Exceeded", (Exception)((Object)e));
    }

    @Override
    protected void processDocumentCreated(CoreSession session, DocumentModel targetDoc, DocumentEventContext docCtx) {
        if (targetDoc.isVersion()) {
            return;
        }
        BlobSizeInfo bsi = this.computeSizeImpact(targetDoc, false);
        QuotaAware quotaDoc = (QuotaAware)targetDoc.getAdapter(QuotaAware.class);
        if (quotaDoc == null) {
            log.trace((Object)("  add Quota Facet on " + targetDoc.getPathAsString()));
            QuotaAwareDocumentFactory.make(targetDoc, true);
        }
        if (bsi.getBlobSizeDelta() != 0L) {
            this.checkConstraints(session, targetDoc, targetDoc.getParentRef(), bsi);
            SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, bsi, "documentCreated");
            this.sendUpdateEvents(asyncEventCtx);
        }
    }

    @Override
    protected void processDocumentCheckedIn(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) {
        BlobSizeInfo bsi = this.computeSizeImpact(doc, false);
        if (bsi.getBlobSize() != 0L) {
            SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, bsi, "documentCheckedIn");
            this.sendUpdateEvents(asyncEventCtx);
        }
    }

    @Override
    protected void processDocumentCheckedOut(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) {
        BlobSizeInfo bsi = this.computeSizeImpact(doc, false);
        if (bsi.getBlobSize() != 0L) {
            this.checkConstraints(session, doc, doc.getParentRef(), bsi, true);
            SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, bsi, "documentCheckedOut");
            this.sendUpdateEvents(asyncEventCtx);
        }
    }

    @Override
    protected void processDocumentUpdated(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) {
    }

    @Override
    protected void processDocumentBeforeUpdate(CoreSession session, DocumentModel targetDoc, DocumentEventContext docCtx) {
        BlobSizeInfo bsi = this.computeSizeImpact(targetDoc, true);
        log.debug((Object)("calling processDocumentBeforeUpdate, bsi=" + bsi.toString()));
        if (bsi.getBlobSizeDelta() != 0L) {
            this.checkConstraints(session, targetDoc, targetDoc.getParentRef(), bsi);
            SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, bsi, "beforeDocumentModification");
            this.sendUpdateEvents(asyncEventCtx);
        }
    }

    @Override
    protected void processDocumentCopied(CoreSession session, DocumentModel targetDoc, DocumentEventContext docCtx) {
        QuotaAware quotaDoc = (QuotaAware)targetDoc.getAdapter(QuotaAware.class);
        if (quotaDoc != null) {
            long total = quotaDoc.getTotalSize() - quotaDoc.getVersionsSize() - quotaDoc.getTrashSize();
            BlobSizeInfo bsi = new BlobSizeInfo();
            bsi.blobSize = total;
            bsi.blobSizeDelta = total;
            if (total > 0L) {
                this.checkConstraints(session, targetDoc, targetDoc.getParentRef(), bsi);
                SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, bsi, "documentCreatedByCopy");
                this.sendUpdateEvents(asyncEventCtx);
            }
        }
    }

    @Override
    protected void processDocumentMoved(CoreSession session, DocumentModel targetDoc, DocumentModel sourceParent, DocumentEventContext docCtx) {
        if (((Serializable)docCtx.getProperties().get("destinationRef")).equals(sourceParent.getRef())) {
            log.debug((Object)(targetDoc.getPathAsString() + "(" + targetDoc.getId() + ") - document is just being renamed, skipping"));
            return;
        }
        QuotaAware quotaDoc = (QuotaAware)targetDoc.getAdapter(QuotaAware.class);
        long total = 0L;
        if (quotaDoc != null) {
            total = quotaDoc.getTotalSize();
        }
        BlobSizeInfo bsi = new BlobSizeInfo();
        bsi.blobSize = total;
        bsi.blobSizeDelta = total;
        if (total > 0L) {
            this.checkConstraints(session, targetDoc, targetDoc.getParentRef(), bsi);
            SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, bsi, "documentMoved");
            long versSize = quotaDoc.getVersionsSize();
            asyncEventCtx.setVersionsSize(versSize);
            this.sendUpdateEvents(asyncEventCtx);
            BlobSizeInfo bsiRemove = new BlobSizeInfo();
            bsiRemove.blobSize = total;
            bsiRemove.blobSizeDelta = -total;
            asyncEventCtx = new SizeUpdateEventContext(session, docCtx, sourceParent, bsiRemove, "documentMoved");
            versSize = -quotaDoc.getVersionsSize();
            asyncEventCtx.setVersionsSize(versSize);
            List<String> sourceParentUUIDs = this.getParentUUIDS(session, sourceParent);
            sourceParentUUIDs.add(0, sourceParent.getId());
            asyncEventCtx.setParentUUIds(sourceParentUUIDs);
            this.sendUpdateEvents(asyncEventCtx);
        }
    }

    @Override
    protected void processDocumentAboutToBeRemoved(CoreSession session, DocumentModel targetDoc, DocumentEventContext docCtx) {
        if (targetDoc.isVersion()) {
            ArrayList<String> parentUUIDs = new ArrayList<String>();
            parentUUIDs.add(targetDoc.getSourceId());
            parentUUIDs.addAll(this.getParentUUIDS(session, (DocumentRef)new IdRef(targetDoc.getSourceId())));
            QuotaAware quotaDoc = (QuotaAware)targetDoc.getAdapter(QuotaAware.class);
            BlobSizeInfo bsi = this.computeSizeImpact(targetDoc, false);
            SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, bsi.getBlobSize(), "aboutToRemoveVersion");
            asyncEventCtx.setParentUUIds(parentUUIDs);
            this.sendUpdateEvents(asyncEventCtx);
            return;
        }
        QuotaAware quotaDoc = (QuotaAware)targetDoc.getAdapter(QuotaAware.class);
        long total = 0L;
        long versSize = 0L;
        if (quotaDoc == null) {
            BlobSizeInfo bsi = this.computeSizeImpact(targetDoc, false);
            total = bsi.getBlobSize();
            log.debug((Object)("Document " + targetDoc.getId() + " doesn't have the facet quotaDoc. Compute impacted size:" + total));
        }
        if (quotaDoc != null) {
            total = quotaDoc.getTotalSize();
            versSize = -quotaDoc.getVersionsSize();
            log.debug((Object)("Found facet quotaDoc on document  " + targetDoc.getId() + ".Notifying QuotaComputerProcessor with total size: " + total + " and versions size: " + versSize));
        }
        if (total > 0L) {
            List<String> parentUUIDs = this.getParentUUIDS(session, targetDoc);
            SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, total, "aboutToRemove");
            if (versSize != 0L) {
                asyncEventCtx.setVersionsSize(versSize);
            }
            asyncEventCtx.setParentUUIds(parentUUIDs);
            asyncEventCtx.getProperties().put("_UPDATE_TRASH", "deleted".equals(targetDoc.getCurrentLifeCycleState()));
            this.sendUpdateEvents(asyncEventCtx);
        }
    }

    @Override
    protected boolean needToProcessEventOnDocument(Event event, DocumentModel targetDoc) {
        if (targetDoc == null) {
            return false;
        }
        if (targetDoc.isProxy()) {
            log.debug((Object)"Escape from listener: not precessing proxies");
            return false;
        }
        Boolean block = (Boolean)targetDoc.getContextData(DISABLE_QUOTA_CHECK_LISTENER);
        if (Boolean.TRUE.equals(block)) {
            log.debug((Object)"Escape from listener to avoid reentrancy");
            return false;
        }
        return true;
    }

    protected void sendUpdateEvents(SizeUpdateEventContext eventCtx) {
        Event quotaUpdateEvent = eventCtx.newQuotaUpdateEvent();
        log.debug((Object)("prepared event on target tree with context " + eventCtx.toString()));
        EventService es = (EventService)Framework.getLocalService(EventService.class);
        es.fireEvent(quotaUpdateEvent);
    }

    protected List<String> getParentUUIDS(CoreSession unrestrictedSession, DocumentRef docRef) {
        DocumentRef[] parentRefs;
        ArrayList<String> result = new ArrayList<String>();
        if (docRef == null || docRef.toString() == null) {
            return result;
        }
        for (DocumentRef parentRef : parentRefs = unrestrictedSession.getParentDocumentRefs(docRef)) {
            result.add(parentRef.toString());
        }
        return result;
    }

    protected List<String> getParentUUIDS(CoreSession unrestrictedSession, DocumentModel doc) {
        return this.getParentUUIDS(unrestrictedSession, doc.getRef());
    }

    protected void checkConstraints(CoreSession unrestrictedSession, DocumentModel doc, DocumentRef parentRef, BlobSizeInfo bsi) {
        this.checkConstraints(unrestrictedSession, doc, parentRef, bsi, false);
    }

    protected void checkConstraints(CoreSession unrestrictedSession, DocumentModel doc, DocumentRef parentRef, BlobSizeInfo bsi, boolean checkWithTotalSize) {
        DocumentModel parentDoc;
        if (parentRef == null) {
            return;
        }
        long addition = bsi.blobSizeDelta;
        if (checkWithTotalSize) {
            addition = bsi.getBlobSize();
        }
        if (addition <= 0L) {
            return;
        }
        List parents = unrestrictedSession.getParentDocuments(parentRef);
        if (!parents.contains(parentDoc = unrestrictedSession.getDocument(parentRef))) {
            parents.add(parentDoc);
        }
        for (DocumentModel parent : parents) {
            log.debug((Object)("processing " + parent.getId() + " " + parent.getPathAsString()));
            QuotaAware qap = (QuotaAware)parent.getAdapter(QuotaAware.class);
            if (qap == null || "UserWorkspacesRoot".equals(parent.getType()) || qap.getMaxQuota() <= 0L) continue;
            Long newTotalSize = new Long(qap.getTotalSize() + addition);
            try {
                if (qap.totalSizeCacheExists()) {
                    Long oldTotalSize = qap.getTotalSizeCache();
                    if (oldTotalSize == null) {
                        newTotalSize = new Long(qap.getTotalSize() + addition);
                        log.debug((Object)("to create cache entry to create: " + qap.getDoc().getId() + " total: " + newTotalSize));
                    } else {
                        newTotalSize = new Long(oldTotalSize + addition);
                        log.debug((Object)("cache entry to update: " + qap.getDoc().getId() + " total: " + newTotalSize));
                    }
                    qap.putTotalSizeCache(newTotalSize);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("cache vs. DB: " + newTotalSize + " # " + (qap.getTotalSize() + addition)));
                    }
                }
            }
            catch (IOException e) {
                log.error((Object)(e.getMessage() + ": unable to use cache " + "quota-totalsize-cache" + ", fallback to basic mechanism"));
                newTotalSize = new Long(qap.getTotalSize() + addition);
            }
            if (newTotalSize <= qap.getMaxQuota()) continue;
            log.info((Object)("Raising Quota Exception on " + doc.getPathAsString()));
            try {
                qap.invalidateTotalSizeCache();
            }
            catch (IOException e) {
                log.error((Object)(e.getMessage() + ": unable to invalidate cache " + "quota-totalsize-cache" + " for " + qap.getDoc().getId()));
            }
            throw new QuotaExceededException(parent, doc, qap.getMaxQuota());
        }
    }

    protected BlobSizeInfo computeSizeImpact(DocumentModel doc, boolean onlyIfBlobHasChanged) {
        BlobSizeInfo result = new BlobSizeInfo();
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        result.blobSize = quotaDoc != null ? quotaDoc.getInnerSize() : 0L;
        List<Blob> blobs = this.getBlobs(doc, onlyIfBlobHasChanged);
        if (blobs.size() == 0) {
            if (onlyIfBlobHasChanged) {
                result.blobSizeDelta = 0L;
            } else {
                result.blobSizeDelta = -result.blobSize;
                result.blobSize = 0L;
            }
        } else {
            long size = 0L;
            for (Blob blob : blobs) {
                if (blob == null) continue;
                size += blob.getLength();
            }
            result.blobSizeDelta = size - result.blobSize;
            result.blobSize = size;
        }
        return result;
    }

    protected List<Blob> getBlobs(DocumentModel doc, boolean onlyIfBlobHasChanged) {
        boolean needRecompute;
        QuotaSizeService sizeService = (QuotaSizeService)Framework.getService(QuotaSizeService.class);
        HashSet<String> excludedPathSet = new HashSet<String>(sizeService.getExcludedPathList());
        BlobsExtractor extractor = new BlobsExtractor();
        extractor.setExtractorProperties(null, new HashSet<String>(excludedPathSet), true);
        List blobProperties = extractor.getBlobsProperties(doc);
        boolean bl = needRecompute = !onlyIfBlobHasChanged;
        if (onlyIfBlobHasChanged) {
            for (Property blobProperty : blobProperties) {
                if (!blobProperty.isDirty()) continue;
                needRecompute = true;
                break;
            }
        }
        ArrayList<Blob> result = new ArrayList<Blob>();
        if (needRecompute) {
            for (Property blobProperty : blobProperties) {
                Blob blob = (Blob)blobProperty.getValue();
                String schema = blobProperty.getParent().getSchema().getName();
                String propName = blobProperty.getName();
                log.debug((Object)String.format("Using [%s:%s] for quota blob computation (size : %d)", schema, propName, blob.getLength()));
                result.add(blob);
            }
        }
        return result;
    }

    @Override
    protected void processDocumentTrashOp(CoreSession session, DocumentModel doc, DocumentEventContext docCtx) {
        String transition = (String)docCtx.getProperties().get("transition");
        if (transition != null && !"delete".equals(transition) && !"undelete".equals(transition)) {
            return;
        }
        QuotaAware quotaDoc = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (quotaDoc != null) {
            long absSize = quotaDoc.getInnerSize();
            if (log.isDebugEnabled() && quotaDoc.getDoc().isFolder()) {
                log.debug((Object)(quotaDoc.getDoc().getPathAsString() + " is a folder, just inner size (" + absSize + ") taken into account for trash size"));
            }
            long total = "delete".equals(transition) ? absSize : -absSize;
            BlobSizeInfo bsi = new BlobSizeInfo();
            bsi.blobSize = total;
            bsi.blobSizeDelta = total;
            if (absSize > 0L) {
                SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, bsi, transition);
                this.sendUpdateEvents(asyncEventCtx);
            }
        }
    }

    @Override
    protected void processDocumentBeforeRestore(CoreSession session, DocumentModel targetDoc, DocumentEventContext docCtx) {
        long total;
        QuotaAware quotaDoc = (QuotaAware)targetDoc.getAdapter(QuotaAware.class);
        if (quotaDoc != null && (total = quotaDoc.getTotalSize()) > 0L) {
            List<String> parentUUIDs = this.getParentUUIDS(session, targetDoc);
            SizeUpdateEventContext asyncEventCtx = new SizeUpdateEventContext(session, docCtx, total, "aboutToRemove");
            long versSize = -quotaDoc.getVersionsSize();
            asyncEventCtx.setVersionsSize(versSize);
            asyncEventCtx.setParentUUIds(parentUUIDs);
            this.sendUpdateEvents(asyncEventCtx);
        }
    }

    @Override
    protected void processDocumentRestored(CoreSession session, DocumentModel targetDoc, DocumentEventContext docCtx) {
        QuotaAware quotaDoc = (QuotaAware)targetDoc.getAdapter(QuotaAware.class);
        if (quotaDoc == null) {
            log.debug((Object)("  add Quota Facet on " + targetDoc.getPathAsString()));
            quotaDoc = QuotaAwareDocumentFactory.make(targetDoc, true);
        }
        quotaDoc.resetInfos(true);
        this.sendUpdateEvents(this.updateEventToProcessNewDocument(session, targetDoc));
    }

    private SizeUpdateEventContext updateEventToProcessNewDocument(CoreSession unrestrictedSession, DocumentModel target) {
        BlobSizeInfo bsi = this.computeSizeImpact(target, false);
        SizeUpdateEventContext quotaCtx = null;
        List versions = unrestrictedSession.getVersions(target.getRef());
        if (versions.isEmpty() && !"deleted".equals(target.getCurrentLifeCycleState())) {
            quotaCtx = new SizeUpdateEventContext(unrestrictedSession, bsi, "documentCreated", target);
        } else {
            long versionsSize = 0L;
            for (DocumentModel documentModel : versions) {
                versionsSize += this.computeSizeImpact((DocumentModel)documentModel, (boolean)false).blobSize;
            }
            quotaCtx = new SizeUpdateEventContext(unrestrictedSession, bsi, "documentUpdateInitialStats", target);
            quotaCtx.setVersionsSize(versionsSize);
        }
        return quotaCtx;
    }
}

