/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.quota.QuotaMaxSizeSetterWork;
import org.nuxeo.ecm.quota.QuotaStatsInitialWork;
import org.nuxeo.ecm.quota.QuotaStatsService;
import org.nuxeo.ecm.quota.QuotaStatsUpdater;
import org.nuxeo.ecm.quota.QuotaStatsUpdaterDescriptor;
import org.nuxeo.ecm.quota.QuotaStatsUpdaterRegistry;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaAwareDocumentFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class QuotaStatsServiceImpl
extends DefaultComponent
implements QuotaStatsService {
    private static final Log log = LogFactory.getLog(QuotaStatsServiceImpl.class);
    public static final String STATUS_INITIAL_COMPUTATION_QUEUED = "status.quota.initialComputationQueued";
    public static final String STATUS_INITIAL_COMPUTATION_PENDING = "status.quota.initialComputationInProgress";
    public static final String STATUS_INITIAL_COMPUTATION_COMPLETED = "status.quota.initialComputationCompleted";
    public static final int DEFAULT_BATCH_SIZE = 1000;
    public static final String QUOTA_STATS_UPDATERS_EP = "quotaStatsUpdaters";
    protected QuotaStatsUpdaterRegistry quotaStatsUpdaterRegistry;

    public void activate(ComponentContext context) {
        this.quotaStatsUpdaterRegistry = new QuotaStatsUpdaterRegistry();
    }

    @Override
    public List<QuotaStatsUpdater> getQuotaStatsUpdaters() {
        return this.quotaStatsUpdaterRegistry.getQuotaStatsUpdaters();
    }

    public QuotaStatsUpdater getQuotaStatsUpdaters(String updaterName) {
        return this.quotaStatsUpdaterRegistry.getQuotaStatsUpdater(updaterName);
    }

    @Override
    public void updateStatistics(final DocumentEventContext docCtx, final Event event) throws ClientException {
        new UnrestrictedSessionRunner(docCtx.getCoreSession()){

            public void run() throws ClientException {
                List<QuotaStatsUpdater> quotaStatsUpdaters = QuotaStatsServiceImpl.this.quotaStatsUpdaterRegistry.getQuotaStatsUpdaters();
                for (QuotaStatsUpdater updater : quotaStatsUpdaters) {
                    log.debug((Object)("Calling updateStatistics on " + updater.getName()));
                    updater.updateStatistics(this.session, docCtx, event);
                }
            }
        }.runUnrestricted();
    }

    @Override
    public void computeInitialStatistics(String updaterName, CoreSession session, QuotaStatsInitialWork currentWorker) {
        QuotaStatsUpdater updater = this.quotaStatsUpdaterRegistry.getQuotaStatsUpdater(updaterName);
        if (updater != null) {
            updater.computeInitialStatistics(session, currentWorker);
        }
    }

    @Override
    public void launchInitialStatisticsComputation(String updaterName, String repositoryName) {
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        if (workManager == null) {
            throw new RuntimeException("No WorkManager available");
        }
        QuotaStatsInitialWork work = new QuotaStatsInitialWork(updaterName, repositoryName);
        workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_RUNNING_OR_SCHEDULED);
    }

    @Override
    public String getProgressStatus(String updaterName, String repositoryName) {
        QuotaStatsInitialWork work;
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        Work.State state = workManager.getWorkState((work = new QuotaStatsInitialWork(updaterName, repositoryName)).getId());
        if (state == null) {
            return null;
        }
        if (state == Work.State.SCHEDULED) {
            return STATUS_INITIAL_COMPUTATION_QUEUED;
        }
        if (state == Work.State.COMPLETED) {
            return STATUS_INITIAL_COMPUTATION_COMPLETED;
        }
        return STATUS_INITIAL_COMPUTATION_PENDING;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (QUOTA_STATS_UPDATERS_EP.equals(extensionPoint)) {
            this.quotaStatsUpdaterRegistry.addContribution((QuotaStatsUpdaterDescriptor)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (QUOTA_STATS_UPDATERS_EP.equals(extensionPoint)) {
            this.quotaStatsUpdaterRegistry.removeContribution((QuotaStatsUpdaterDescriptor)contribution);
        }
    }

    @Override
    public long getQuotaFromParent(DocumentModel doc, CoreSession session) throws ClientException {
        List<DocumentModel> parents = this.getParentsInReverseOrder(doc, session);
        if (parents.size() > 0 && "UserWorkspacesRoot".equals(parents.get(0).getType())) {
            QuotaAware qa = (QuotaAware)parents.get(0).getAdapter(QuotaAware.class);
            return qa != null ? qa.getMaxQuota() : -1L;
        }
        for (DocumentModel documentModel : parents) {
            QuotaAware qa = (QuotaAware)documentModel.getAdapter(QuotaAware.class);
            if (qa == null || qa.getMaxQuota() <= 0L) continue;
            return qa.getMaxQuota();
        }
        return -1L;
    }

    @Override
    public void activateQuotaOnUserWorkspaces(final long maxQuota, CoreSession session) throws ClientException {
        final String userWorkspacesRootId = this.getUserWorkspaceRootId(session.getRootDocument(), session);
        new UnrestrictedSessionRunner(session){

            public void run() throws ClientException {
                DocumentModel uwRoot = this.session.getDocument((DocumentRef)new IdRef(userWorkspacesRootId));
                QuotaAware qa = (QuotaAware)uwRoot.getAdapter(QuotaAware.class);
                if (qa == null) {
                    qa = QuotaAwareDocumentFactory.make(uwRoot, false);
                }
                qa.setMaxQuota(maxQuota, true, false);
            }
        }.runUnrestricted();
    }

    @Override
    public long getQuotaSetOnUserWorkspaces(CoreSession session) throws ClientException {
        final String userWorkspacesRootId = this.getUserWorkspaceRootId(session.getRootDocument(), session);
        return new UnrestrictedSessionRunner(session){
            long quota;
            {
                super(x0);
                this.quota = -1L;
            }

            public long getsQuotaSetOnUserWorkspaces() throws ClientException {
                this.runUnrestricted();
                return this.quota;
            }

            public void run() throws ClientException {
                DocumentModel uwRoot = this.session.getDocument((DocumentRef)new IdRef(userWorkspacesRootId));
                QuotaAware qa = (QuotaAware)uwRoot.getAdapter(QuotaAware.class);
                this.quota = qa == null ? -1L : qa.getMaxQuota();
            }
        }.getsQuotaSetOnUserWorkspaces();
    }

    protected List<DocumentModel> getParentsInReverseOrder(DocumentModel doc, CoreSession session) throws ClientException {
        UnrestrictedParentsFetcher parentsFetcher = new UnrestrictedParentsFetcher(doc, session);
        return parentsFetcher.getParents();
    }

    @Override
    public void launchSetMaxQuotaOnUserWorkspaces(final long maxSize, DocumentModel context, CoreSession session) throws ClientException {
        final String userWorkspacesId = this.getUserWorkspaceRootId(context, session);
        new UnrestrictedSessionRunner(session){

            public void run() throws ClientException {
                IterableQueryResult results = this.session.queryAndFetch(String.format("Select ecm:uuid from Workspace where ecm:parentId = '%s'  AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted' ", userWorkspacesId), "NXQL", new Object[0]);
                int size = 0;
                ArrayList<String> allIds = new ArrayList<String>();
                for (Map map : results) {
                    allIds.add((String)map.get("ecm:uuid"));
                }
                results.close();
                ArrayList<String> ids = new ArrayList<String>();
                WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
                for (String id : allIds) {
                    ids.add(id);
                    if (++size % 1000 != 0) continue;
                    QuotaMaxSizeSetterWork work = new QuotaMaxSizeSetterWork(maxSize, ids, this.session.getRepositoryName());
                    workManager.schedule((Work)work);
                    ids.clear();
                }
                if (ids.size() > 0) {
                    QuotaMaxSizeSetterWork work = new QuotaMaxSizeSetterWork(maxSize, ids, this.session.getRepositoryName());
                    workManager.schedule((Work)work);
                }
            }
        }.runUnrestricted();
    }

    public String getUserWorkspaceRootId(DocumentModel context, CoreSession session) throws ClientException {
        DocumentModel currentUserWorkspace = ((UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class)).getUserPersonalWorkspace(session.getPrincipal().getName(), context);
        return ((IdRef)currentUserWorkspace.getParentRef()).value;
    }

    @Override
    public boolean canSetMaxQuota(long maxQuota, DocumentModel doc, CoreSession session) throws ClientException {
        QuotaAware qa = null;
        DocumentModel parent = null;
        if ("UserWorkspacesRoot".equals(doc.getType())) {
            return true;
        }
        List<DocumentModel> parents = this.getParentsInReverseOrder(doc, session);
        if (parents != null && parents.size() > 0 && "UserWorkspacesRoot".equals(parents.get(0).getType())) {
            return true;
        }
        for (DocumentModel p : parents) {
            qa = (QuotaAware)p.getAdapter(QuotaAware.class);
            if (qa == null || qa.getMaxQuota() <= 0L) continue;
            parent = p;
            break;
        }
        if (qa == null || qa.getMaxQuota() < 0L) {
            return true;
        }
        long maxAllowedOnChildrenToSetQuota = qa.getMaxQuota() - maxQuota;
        if (maxAllowedOnChildrenToSetQuota < 0L) {
            return false;
        }
        Long quotaOnChildren = new UnrestrictedQuotaOnChildrenCalculator(parent, maxAllowedOnChildrenToSetQuota, doc.getId(), session).quotaOnChildren();
        return quotaOnChildren <= 0L || quotaOnChildren <= maxAllowedOnChildrenToSetQuota;
    }

    class QuotaFilter
    implements Filter {
        private static final long serialVersionUID = 1L;

        QuotaFilter() {
        }

        public boolean accept(DocumentModel doc) {
            return !"UserWorkspacesRoot".equals(doc.getType());
        }
    }

    class UnrestrictedParentsFetcher
    extends UnrestrictedSessionRunner {
        DocumentModel doc;
        List<DocumentModel> parents;

        protected UnrestrictedParentsFetcher(DocumentModel doc, CoreSession session) {
            super(session);
            this.doc = doc;
        }

        public void run() throws ClientException {
            DocumentRef[] parentRefs;
            this.parents = new ArrayList<DocumentModel>();
            for (DocumentRef documentRef : parentRefs = this.session.getParentDocumentRefs(this.doc.getRef())) {
                this.parents.add(this.session.getDocument(documentRef));
            }
            for (DocumentModel parent : this.parents) {
                parent.detach(true);
            }
        }

        public List<DocumentModel> getParents() throws ClientException {
            this.runUnrestricted();
            return this.parents;
        }
    }

    class UnrestrictedQuotaOnChildrenCalculator
    extends UnrestrictedSessionRunner {
        DocumentModel parent;
        Long maxAllowedOnChildrenToSetQuota;
        long quotaOnChildren;
        String currentDocIdToIgnore;

        protected UnrestrictedQuotaOnChildrenCalculator(DocumentModel parent, Long maxAllowedOnChildrenToSetQuota, String currentDocIdToIgnore, CoreSession session) {
            super(session);
            this.quotaOnChildren = -1L;
            this.parent = parent;
            this.maxAllowedOnChildrenToSetQuota = maxAllowedOnChildrenToSetQuota;
            this.currentDocIdToIgnore = currentDocIdToIgnore;
        }

        public void run() throws ClientException {
            this.quotaOnChildren = this.canSetMaxQuotaOnChildrenTree(this.maxAllowedOnChildrenToSetQuota, this.quotaOnChildren, this.parent, this.currentDocIdToIgnore, this.session);
        }

        public long quotaOnChildren() throws ClientException {
            this.runUnrestricted();
            return this.quotaOnChildren;
        }

        protected Long canSetMaxQuotaOnChildrenTree(Long maxAllowedOnChildrenToSetQuota, Long quotaOnChildren, DocumentModel doc, String currentDocIdToIgnore, CoreSession session) throws ClientException {
            if (quotaOnChildren > 0L && quotaOnChildren > maxAllowedOnChildrenToSetQuota) {
                return quotaOnChildren;
            }
            DocumentModelIterator childrenIterator = null;
            childrenIterator = session.getChildrenIterator(doc.getRef(), null, null, (Filter)new QuotaFilter());
            while (childrenIterator.hasNext()) {
                DocumentModel child = (DocumentModel)childrenIterator.next();
                QuotaAware qac = (QuotaAware)child.getAdapter(QuotaAware.class);
                if (qac == null) continue;
                if (qac.getMaxQuota() > 0L && !currentDocIdToIgnore.equals(child.getId())) {
                    quotaOnChildren = (quotaOnChildren == -1L ? 0L : quotaOnChildren) + qac.getMaxQuota();
                }
                if (quotaOnChildren > 0L && quotaOnChildren > maxAllowedOnChildrenToSetQuota) {
                    return quotaOnChildren;
                }
                if (qac.getMaxQuota() == -1L) {
                    quotaOnChildren = this.canSetMaxQuotaOnChildrenTree(maxAllowedOnChildrenToSetQuota, quotaOnChildren, child, currentDocIdToIgnore, session);
                }
                if (quotaOnChildren <= 0L || quotaOnChildren <= maxAllowedOnChildrenToSetQuota) continue;
                return quotaOnChildren;
            }
            return quotaOnChildren;
        }
    }
}

