/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageListCache;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.connect.update.PackageType;

public class RemotePackageSource
implements PackageSource {
    protected static final Log log = LogFactory.getLog(RemotePackageSource.class);
    protected PackageListCache cache = new PackageListCache();

    @Override
    public String getName() {
        return "Connect Server";
    }

    @Override
    public String getId() {
        return "remote";
    }

    @Override
    public List<DownloadablePackage> listPackages() {
        ArrayList<DownloadablePackage> all = new ArrayList<DownloadablePackage>();
        for (PackageType type : PackageType.values()) {
            all.addAll(this.listPackages(type));
        }
        return all;
    }

    @Override
    public List<DownloadablePackage> listPackages(PackageType type) {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
        try {
            List<DownloadablePackage> pkgs = this.cache.getFromCache(type.toString());
            if (pkgs == null) {
                pkgs = crs.getConnector().getDownloads(type);
                this.cache.add(pkgs, type.toString());
            }
            for (DownloadablePackage pkg : pkgs) {
                result.add(pkg);
            }
        }
        catch (ConnectServerError e) {
            log.debug((Object)e, (Throwable)e);
            log.warn((Object)"Unable to fetch remote packages list");
            this.cache.add(new ArrayList<DownloadablePackage>(), type.toString());
        }
        return result;
    }

    @Override
    public void flushCache() {
        this.cache = new PackageListCache();
        ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
        crs.getConnector().flushCache();
    }
}

