/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.size;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.nuxeo.ecm.quota.size.BlobExcludeDescriptor;
import org.nuxeo.ecm.quota.size.QuotaSizeService;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaSizeServiceImpl
extends DefaultComponent
implements QuotaSizeService {
    private Set<String> excludedPathList = new HashSet<String>();
    private static Logger LOG = LoggerFactory.getLogger(QuotaSizeServiceImpl.class);

    @Override
    public Collection<String> getExcludedPathList() {
        return this.excludedPathList;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("exclusions".equals(extensionPoint)) {
            BlobExcludeDescriptor descriptor = (BlobExcludeDescriptor)contribution;
            LOG.info(String.format("Adding %s to size quota computation's blacklist", descriptor.getPathRegexp()));
            this.excludedPathList.add(descriptor.getPathRegexp());
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        BlobExcludeDescriptor descriptor;
        String pathRegexp;
        if ("exclusions".equals(extensionPoint) && this.excludedPathList.contains(pathRegexp = (descriptor = (BlobExcludeDescriptor)contribution).getPathRegexp())) {
            LOG.info(String.format("Removing %s from size quota computation's blacklist", pathRegexp));
            this.excludedPathList.remove(pathRegexp);
        }
    }
}

