/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.quota.QuotaStatsService;
import org.nuxeo.runtime.api.Framework;

public class QuotaStatsInitialWork
extends AbstractWork {
    public static final String CATEGORY_QUOTA_INITIAL = "quotaInitialStatistics";
    private final String updaterName;
    private final String repositoryName;

    public QuotaStatsInitialWork(String updaterName, String repositoryName) {
        this.updaterName = updaterName;
        this.repositoryName = repositoryName;
    }

    public String getCategory() {
        return CATEGORY_QUOTA_INITIAL;
    }

    public String getTitle() {
        return "Quota Statistics " + this.updaterName;
    }

    public void notifyProgress(float percent) {
        this.setProgress(new Work.Progress(percent));
    }

    public void notifyProgress(long current, long total) {
        this.setProgress(new Work.Progress(current, total));
    }

    public void work() throws ClientException {
        final QuotaStatsInitialWork currentWorker = this;
        new UnrestrictedSessionRunner(this.repositoryName){

            public void run() throws ClientException {
                QuotaStatsService service = (QuotaStatsService)Framework.getLocalService(QuotaStatsService.class);
                service.computeInitialStatistics(QuotaStatsInitialWork.this.updaterName, this.session, currentWorker);
            }
        }.runUnrestricted();
    }

    public boolean equals(Object object) {
        if (!(object instanceof QuotaStatsInitialWork)) {
            return false;
        }
        QuotaStatsInitialWork other = (QuotaStatsInitialWork)((Object)object);
        return new EqualsBuilder().append((Object)this.updaterName, (Object)other.updaterName).append((Object)this.repositoryName, (Object)other.repositoryName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.updaterName).append((Object)this.repositoryName).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("updaterName", (Object)this.updaterName).append("repositoryName", (Object)this.repositoryName).toString();
    }
}

