/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.download.link.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.labs.download.link.service.PublicDownloadLinkBuilder;
import org.nuxeo.labs.download.link.service.PublicDownloadLinkBuilderDescriptor;
import org.nuxeo.labs.download.link.service.PublicDownloadLinkService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class PublicDownloadLinkServiceImpl
extends DefaultComponent
implements PublicDownloadLinkService {
    public static final String LINK_BUILDER_EP = "builder";
    public static final String PUBLIC_DOWNLOAD_PATH = "nxpublicfile";
    public static final String PUBLIC_DOWNLOAD_TOKEN_PARAM = "download_token";
    public static final String NUXEO_URL_KEY = "nuxeo.url";
    public static final String PUBLIC_DOWNLOAD_ACL_PREFIX = "public_download/";
    public PublicDownloadLinkBuilder linkBuilder = null;

    public void registerContribution(Object contribution, String xp, ComponentInstance component) {
        if (LINK_BUILDER_EP.equals(xp)) {
            this.linkBuilder = ((PublicDownloadLinkBuilderDescriptor)contribution).newInstance();
        }
        super.registerContribution(contribution, xp, component);
    }

    @Override
    public boolean hasPublicDownloadPermission(DocumentModel doc, String xpath) {
        return this.getExistingDownloadPermission(doc, xpath).length > 0;
    }

    @Override
    public boolean hasEffectivePublicDownloadPermission(DocumentModel doc, String xpath) {
        ACL[] acls = this.getExistingDownloadPermission(doc, xpath);
        return this.filterACLsForBeginEnd(acls).length > 0;
    }

    @Override
    public String setPublicDownloadPermission(DocumentModel doc, String xpath) {
        return this.setPublicDownloadPermission(doc, xpath, null, null);
    }

    @Override
    public String setPublicDownloadPermission(DocumentModel doc, String xpath, Calendar begin, Calendar end) {
        ACL[] acls = this.getExistingDownloadPermission(doc, xpath);
        if (acls.length <= 0) {
            CoreSession session = doc.getCoreSession();
            ACP acp = doc.getACP() != null ? doc.getACP() : new ACPImpl();
            String token = UUID.randomUUID().toString();
            ACE ace = ACE.builder((String)("transient/" + token), (String)"Read").creator(session.getPrincipal().getName()).begin(begin).end(end).build();
            acp.addACE(this.getACLPrefix(xpath) + token, ace);
            doc.setACP(acp, true);
            return token;
        }
        return acls[0].getName().substring(this.getACLPrefix(xpath).length());
    }

    @Override
    public void removePublicDownloadPermission(DocumentModel doc, String xpath) {
        String link = this.getPublicDownloadLink(doc, xpath);
        ACL[] acls = this.getExistingDownloadPermission(doc, xpath);
        ACP acp = doc.getACP();
        for (ACL acl : acls) {
            acp.removeACL(acl.getName());
        }
        doc.setACP(acp, true);
        if (this.linkBuilder != null) {
            this.linkBuilder.publicDownloadPermissionRevoked(doc, xpath, link);
        }
    }

    @Override
    public void removePublicDownloadPermissions(DocumentModel doc) {
        ACL[] acls = this.getExistingDownloadPermissions(doc);
        ACP acp = doc.getACP();
        for (ACL acl : acls) {
            acp.removeACL(acl.getName());
        }
        doc.setACP(acp, true);
    }

    @Override
    public String getPublicDownloadLink(DocumentModel doc, String xpath) {
        ACL[] acls = this.getExistingDownloadPermission(doc, xpath);
        if (acls.length == 0) {
            return null;
        }
        String token = acls[0].getName().substring(this.getACLPrefix(xpath).length());
        if (this.linkBuilder != null) {
            return this.linkBuilder.getPublicDownloadLink(doc, xpath, token);
        }
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        Blob blob = downloadService.resolveBlob(doc, xpath);
        String downloadPath = downloadService.getDownloadUrl(doc, xpath, blob.getFilename()).replace("nxfile", PUBLIC_DOWNLOAD_PATH);
        String baseUrl = Framework.getProperty((String)NUXEO_URL_KEY);
        return String.format("%s/%s&%s=%s", baseUrl, downloadPath, PUBLIC_DOWNLOAD_TOKEN_PARAM, token);
    }

    @Override
    public Map<String, String> getAllPublicDownloadLink(DocumentModel doc) {
        ACL[] acls = this.getExistingDownloadPermissions(doc);
        HashMap<String, String> links = new HashMap<String, String>();
        for (ACL acl : acls) {
            String name = acl.getName();
            String xpath = name.substring(PUBLIC_DOWNLOAD_ACL_PREFIX.length(), name.lastIndexOf(47));
            links.put(xpath, this.getPublicDownloadLink(doc, xpath));
        }
        return links;
    }

    @Override
    public boolean isValidToken(DocumentModel doc, String xpath, String token) {
        Optional<ACL> optional = Arrays.stream(this.getExistingDownloadPermission(doc, xpath)).filter(acl -> acl.getName().equals(this.getACLPrefix(xpath) + token)).findFirst();
        return optional.isPresent();
    }

    protected ACL[] filterACLsForBeginEnd(ACL[] acls) {
        ArrayList<ACL> finalACLs = new ArrayList<ACL>();
        if (acls != null) {
            for (ACL acl : acls) {
                for (ACE ace : acl.getACEs()) {
                    if (!ace.isEffective()) continue;
                    finalACLs.add(acl);
                }
            }
        }
        return (ACL[])finalACLs.stream().toArray(ACL[]::new);
    }

    public ACL[] getExistingDownloadPermissions(DocumentModel doc) {
        ACP acp = doc.getACP() != null ? doc.getACP() : new ACPImpl();
        ACL[] acls = (ACL[])Arrays.stream(acp.getACLs()).filter(acl -> acl.getName().startsWith(PUBLIC_DOWNLOAD_ACL_PREFIX)).toArray(ACL[]::new);
        return acls;
    }

    public ACL[] getExistingDownloadPermission(DocumentModel doc, String xpath) {
        ACP acp = doc.getACP() != null ? doc.getACP() : new ACPImpl();
        ACL[] acls = (ACL[])Arrays.stream(acp.getACLs()).filter(acl -> acl.getName().startsWith(this.getACLPrefix(xpath))).toArray(ACL[]::new);
        return acls;
    }

    public String getACLPrefix(String xpath) {
        return PUBLIC_DOWNLOAD_ACL_PREFIX + xpath + "/";
    }
}

