/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.download.link.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.cloudfront.AmazonCloudFrontClientBuilder;
import com.amazonaws.services.cloudfront.model.CreateInvalidationRequest;
import com.amazonaws.services.cloudfront.model.InvalidationBatch;
import com.amazonaws.services.cloudfront.model.Paths;
import java.net.URI;
import java.util.UUID;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.labs.download.link.service.PublicDownloadLinkBuilder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.aws.NuxeoAWSCredentialsProvider;

public class CloudfrontPublicDownloadLinkBuilder
implements PublicDownloadLinkBuilder {
    public static final String CLOUDFRONT_DISTRIB_NAME_PROPERTY = "nuxeo.s3storage.cloudfront.distribDomain";
    public static final String CLOUDFRONT_DISTRIB_ID_PROPERTY = "nuxeo.s3storage.cloudfront.distribId";
    public static final String CLOUDFRONT_PREFIX = "public";

    public String getPublicDownloadLink(DocumentModel doc, String xpath, String token) {
        String distributionName = Framework.getProperty((String)CLOUDFRONT_DISTRIB_NAME_PROPERTY);
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        Blob blob = downloadService.resolveBlob(doc, xpath);
        String downloadPath = downloadService.getDownloadUrl(doc, xpath, blob.getFilename()).replace("nxfile", "nxpublicfile");
        return String.format("https://%s/%s/%s/%s", distributionName, CLOUDFRONT_PREFIX, token, downloadPath);
    }

    public void publicDownloadPermissionRevoked(DocumentModel doc, String xpath, String link) {
        String distributionId = Framework.getProperty((String)CLOUDFRONT_DISTRIB_ID_PROPERTY);
        AWSCredentialsProvider awsCredentialsProvider = NuxeoAWSCredentialsProvider.getInstance();
        AmazonCloudFrontClient client = (AmazonCloudFrontClient)((AmazonCloudFrontClientBuilder)AmazonCloudFrontClientBuilder.standard().withCredentials(awsCredentialsProvider)).build();
        URI uri = URI.create(link);
        Paths invalidation_paths = new Paths().withItems(new String[]{uri.getPath()}).withQuantity(Integer.valueOf(1));
        InvalidationBatch invalidation_batch = new InvalidationBatch(invalidation_paths, UUID.randomUUID().toString());
        CreateInvalidationRequest invalidation = new CreateInvalidationRequest(distributionId, invalidation_batch);
        client.createInvalidation(invalidation);
    }
}

