/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.download.link.enricher;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.labs.download.link.service.PublicDownloadLinkService;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class PublicDownloadLinkEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "publicDownload";

    public PublicDownloadLinkEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel enriched) throws IOException {
        PublicDownloadLinkService publicDownloadLinkService = (PublicDownloadLinkService)Framework.getService(PublicDownloadLinkService.class);
        Map<String, String> links = publicDownloadLinkService.getAllPublicDownloadLink(enriched);
        jg.writeFieldName(NAME);
        jg.writeStartObject();
        for (Map.Entry<String, String> entry : links.entrySet()) {
            jg.writeStringField(entry.getKey(), entry.getValue());
        }
        jg.writeEndObject();
    }
}

