/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.download.link.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.labs.download.link.service.PublicDownloadLinkService;
import org.nuxeo.runtime.api.Framework;

public class PublicDownloadLinkServiceImpl
implements PublicDownloadLinkService {
    public static final String PUBLIC_DOWNLOAD_PATH = "nxpublicfile";
    public static final String PUBLIC_DOWNLOAD_TOKEN_PARAM = "download_token";
    public static final String NUXEO_URL_KEY = "nuxeo.url";
    public static final String PUBLIC_DOWNLOAD_ACL_PREFIX = "public_download/";

    @Override
    public boolean hasPublicDownloadPermission(DocumentModel doc, String xpath) {
        return this.getExistingDownloadPermission(doc, xpath).length > 0;
    }

    @Override
    public String setPublicDownloadPermission(DocumentModel doc, String xpath) {
        ACL[] acls = this.getExistingDownloadPermission(doc, xpath);
        if (acls.length <= 0) {
            CoreSession session = doc.getCoreSession();
            ACP acp = doc.getACP() != null ? doc.getACP() : new ACPImpl();
            String token = UUID.randomUUID().toString();
            ACE ace = ACE.builder((String)("transient/" + token), (String)"Read").creator(session.getPrincipal().getName()).build();
            acp.addACE(this.getACLPrefix(xpath) + token, ace);
            doc.setACP(acp, true);
            return token;
        }
        return acls[0].getName().substring(this.getACLPrefix(xpath).length());
    }

    @Override
    public void removePublicDownloadPermission(DocumentModel doc, String xpath) {
        ACL[] acls = this.getExistingDownloadPermission(doc, xpath);
        ACP acp = doc.getACP();
        for (ACL acl : acls) {
            acp.removeACL(acl.getName());
        }
        doc.setACP(acp, true);
    }

    @Override
    public void removePublicDownloadPermissions(DocumentModel doc) {
        ACL[] acls = this.getExistingDownloadPermissions(doc);
        ACP acp = doc.getACP();
        for (ACL acl : acls) {
            acp.removeACL(acl.getName());
        }
        doc.setACP(acp, true);
    }

    @Override
    public String getPublicDownloadLink(DocumentModel doc, String xpath) {
        ACL[] acls = this.getExistingDownloadPermission(doc, xpath);
        if (acls.length == 0) {
            return null;
        }
        String token = acls[0].getName().substring(this.getACLPrefix(xpath).length());
        String baseUrl = Framework.getProperty((String)NUXEO_URL_KEY);
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        Blob blob = downloadService.resolveBlob(doc, xpath);
        return baseUrl + "/" + downloadService.getDownloadUrl(doc, xpath, blob.getFilename()).replace("nxfile", PUBLIC_DOWNLOAD_PATH) + "&download_token=" + token;
    }

    @Override
    public Map<String, String> getAllPublicDownloadLink(DocumentModel doc) {
        ACL[] acls = this.getExistingDownloadPermissions(doc);
        HashMap<String, String> links = new HashMap<String, String>();
        for (ACL acl : acls) {
            String name = acl.getName();
            String xpath = name.substring(PUBLIC_DOWNLOAD_ACL_PREFIX.length(), name.lastIndexOf(47));
            links.put(xpath, this.getPublicDownloadLink(doc, xpath));
        }
        return links;
    }

    @Override
    public boolean isValidToken(DocumentModel doc, String xpath, String token) {
        Optional<ACL> optional = Arrays.stream(this.getExistingDownloadPermission(doc, xpath)).filter(acl -> acl.getName().equals(this.getACLPrefix(xpath) + token)).findFirst();
        return optional.isPresent();
    }

    public ACL[] getExistingDownloadPermissions(DocumentModel doc) {
        ACP acp = doc.getACP() != null ? doc.getACP() : new ACPImpl();
        return (ACL[])Arrays.stream(acp.getACLs()).filter(acl -> acl.getName().startsWith(PUBLIC_DOWNLOAD_ACL_PREFIX)).toArray(ACL[]::new);
    }

    public ACL[] getExistingDownloadPermission(DocumentModel doc, String xpath) {
        ACP acp = doc.getACP() != null ? doc.getACP() : new ACPImpl();
        return (ACL[])Arrays.stream(acp.getACLs()).filter(acl -> acl.getName().startsWith(this.getACLPrefix(xpath))).toArray(ACL[]::new);
    }

    public String getACLPrefix(String xpath) {
        return PUBLIC_DOWNLOAD_ACL_PREFIX + xpath + "/";
    }
}

