/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.registration;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class RegistrationCleanerListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        if (!event.getName().equals("documentRemoved") || !(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext context = (DocumentEventContext)event.getContext();
        final DocumentModel sourceDocument = context.getSourceDocument();
        if (sourceDocument.getType().equals("UserRegistration") || sourceDocument.isVersion()) {
            return;
        }
        new UnrestrictedSessionRunner(context.getCoreSession()){

            public void run() throws ClientException {
                DocumentModelList docs = this.session.query(String.format("Select * from Document where ecm:mixinType = 'UserRegistration' and %s = '%s'", "docinfo:documentId", sourceDocument.getId()));
                for (DocumentModel doc : docs) {
                    this.session.removeDocument(doc.getRef());
                }
            }
        }.runUnrestricted();
    }
}

