/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.Serializable;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseStatelessNuxeoRestlet;
import org.nuxeo.runtime.api.Framework;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class BrowseRestlet
extends BaseStatelessNuxeoRestlet
implements Serializable {
    private static final long serialVersionUID = -4518256101431979971L;

    @Override
    protected void doHandleStatelessRequest(Request req, Response res) {
        DocumentModel dm;
        boolean isRoot;
        DOMDocument result;
        String repo;
        block20: {
            this.logDeprecation();
            repo = (String)req.getAttributes().get("repo");
            String docid = (String)req.getAttributes().get("docid");
            DOMDocumentFactory domFactory = new DOMDocumentFactory();
            result = (DOMDocument)domFactory.createDocument();
            if (repo == null || repo.equals("*")) {
                try {
                    Element serversNode = result.createElement("avalaibleServers");
                    result.setRootElement((org.dom4j.Element)serversNode);
                    RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
                    for (String repositoryName : repositoryManager.getRepositoryNames()) {
                        Element server = result.createElement("server");
                        server.setAttribute("title", repositoryName);
                        server.setAttribute("url", BrowseRestlet.getRelURL(repositoryName, "*"));
                        serversNode.appendChild(server);
                    }
                    res.setEntity(result.asXML(), MediaType.APPLICATION_XML);
                    res.getEntity().setCharacterSet(CharacterSet.UTF_8);
                    return;
                }
                catch (DOMException e) {
                    BrowseRestlet.handleError(result, res, e);
                    return;
                }
            }
            boolean init = this.initRepository(res, repo);
            isRoot = false;
            try {
                if (init) {
                    if (docid == null || docid.equals("*")) {
                        dm = this.session.getRootDocument();
                        isRoot = true;
                    } else {
                        dm = this.session.getDocument((DocumentRef)new IdRef(docid));
                    }
                    break block20;
                }
                BrowseRestlet.handleError(res, "Unable to init repository");
                return;
            }
            catch (NuxeoException e) {
                BrowseRestlet.handleError(res, (Exception)((Object)e));
                return;
            }
        }
        Element current = result.createElement("document");
        try {
            current.setAttribute("title", dm.getTitle());
        }
        catch (NuxeoException | DOMException e) {
            BrowseRestlet.handleError(res, (Exception)e);
        }
        current.setAttribute("type", dm.getType());
        current.setAttribute("id", dm.getId());
        current.setAttribute("name", dm.getName());
        if (isRoot) {
            current.setAttribute("url", BrowseRestlet.getRelURL(repo, ""));
        } else {
            current.setAttribute("url", BrowseRestlet.getRelURL(repo, dm.getRef().toString()));
        }
        result.setRootElement((org.dom4j.Element)current);
        if (dm.isFolder()) {
            DocumentModelList children;
            try {
                children = this.session.getChildren(dm.getRef());
            }
            catch (NuxeoException e) {
                BrowseRestlet.handleError(result, res, (Exception)((Object)e));
                return;
            }
            for (DocumentModel child : children) {
                Element el = result.createElement("document");
                try {
                    el.setAttribute("title", child.getTitle());
                }
                catch (DOMException e) {
                    BrowseRestlet.handleError(res, e);
                }
                catch (NuxeoException e) {
                    BrowseRestlet.handleError(res, (Exception)((Object)e));
                }
                el.setAttribute("type", child.getType());
                el.setAttribute("id", child.getId());
                el.setAttribute("name", child.getName());
                el.setAttribute("url", BrowseRestlet.getRelURL(repo, child.getRef().toString()));
                current.appendChild(el);
            }
        }
        res.setEntity(result.asXML(), MediaType.APPLICATION_XML);
        res.getEntity().setCharacterSet(CharacterSet.UTF_8);
    }

    private static String getRelURL(String repo, String uuid) {
        return '/' + repo + '/' + uuid;
    }
}

