/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.util.FileUploadHelper;
import org.nuxeo.runtime.api.Framework;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;

public class UploadRestlet
extends BaseNuxeoRestlet
implements Serializable {
    private static final Log log = LogFactory.getLog(UploadRestlet.class);
    private static final long serialVersionUID = -7858792615823015193L;

    public void handle(Request req, Response res) {
        DOMDocument result;
        block34: {
            this.logDeprecation();
            String repo = (String)req.getAttributes().get("repo");
            String docid = (String)req.getAttributes().get("docid");
            String fileName = (String)req.getAttributes().get("filename");
            DOMDocumentFactory domFactory = new DOMDocumentFactory();
            result = (DOMDocument)domFactory.createDocument();
            try (CloseableCoreSession session = CoreInstance.openCoreSession((String)repo);){
                DocumentModel targetContainer;
                try {
                    targetContainer = session.getDocument((DocumentRef)new IdRef(docid));
                }
                catch (NuxeoException e) {
                    UploadRestlet.handleError(res, (Exception)((Object)e));
                    if (session != null) {
                        if (var10_9 != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable) {
                                var10_9.addSuppressed(throwable);
                            }
                        } else {
                            session.close();
                        }
                    }
                    return;
                }
                List<Blob> blobs = null;
                try {
                    blobs = FileUploadHelper.parseRequest(req);
                }
                catch (IOException | FileUploadException e) {
                    UploadRestlet.handleError(res, (Exception)e);
                    if (session != null) {
                        if (var10_9 != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable) {
                                var10_9.addSuppressed(throwable);
                            }
                        } else {
                            session.close();
                        }
                    }
                    return;
                }
                if (!FileUploadHelper.isMultipartRequest(req)) {
                    String outcome;
                    try {
                        Blob inputBlob = blobs.get(0);
                        inputBlob.setFilename(fileName);
                        outcome = this.addBinaryFileFromPlugin(inputBlob, targetContainer);
                    }
                    catch (IOException | NuxeoException e) {
                        outcome = "ERROR : " + e.getMessage();
                    }
                    result.addElement("upload").setText(outcome);
                    break block34;
                }
                Element uploads = result.addElement("uploads");
                for (Blob blob : blobs) {
                    String outcome;
                    try {
                        outcome = this.addBinaryFileFromPlugin(blob, targetContainer);
                    }
                    catch (IOException | NuxeoException e) {
                        log.error((Object)("error importing " + blob.getFilename() + ": " + e.getMessage()), e);
                        outcome = "ERROR : " + e.getMessage();
                    }
                    uploads.addElement("upload").setText(outcome);
                }
            }
        }
        StringRepresentation rep = new StringRepresentation((CharSequence)result.asXML(), MediaType.APPLICATION_XML);
        rep.setCharacterSet(CharacterSet.UTF_8);
        res.setEntity((Representation)rep);
    }

    protected String addBinaryFileFromPlugin(Blob blob, DocumentModel folder) throws IOException {
        FileManager fileManager = (FileManager)Framework.getService(FileManager.class);
        DocumentModel doc = fileManager.createDocumentFromBlob(folder.getCoreSession(), blob, folder.getPathAsString(), true, blob.getFilename());
        return doc.getName();
    }
}

