/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.routing.Filter;

public class ThreadSafeRestletFilter
extends Filter {
    private static final Log log = LogFactory.getLog(ThreadSafeRestletFilter.class);

    protected int doHandle(Request request, Response response) {
        if (this.getNext() != null) {
            try {
                Restlet next = (Restlet)this.getNext().getClass().newInstance();
                next.handle(request, response);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)"Restlet handling error", (Throwable)e);
                response.setEntity("Error while getting a new Restlet instance: " + e.getMessage(), MediaType.TEXT_PLAIN);
            }
        } else {
            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
        return 0;
    }
}

