/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.tag.fn.LiveEditConstants;
import org.nuxeo.runtime.api.Framework;
import org.restlet.Request;
import org.restlet.Response;

public class DownloadFileRestlet
extends BaseNuxeoRestlet
implements LiveEditConstants,
Serializable {
    private static final long serialVersionUID = -2163290273836947871L;

    public void handle(Request req, Response res) {
        this.logDeprecation();
        HttpServletRequest request = DownloadFileRestlet.getHttpRequest(req);
        HttpServletResponse response = DownloadFileRestlet.getHttpResponse(res);
        String repo = (String)req.getAttributes().get("repo");
        if (repo == null || repo.equals("*")) {
            DownloadFileRestlet.handleError(res, "you must specify a repository");
            return;
        }
        try (CloseableCoreSession documentManager = CoreInstance.openCoreSession((String)repo);){
            String xpath;
            Blob blob;
            String filename;
            String docid = (String)req.getAttributes().get("docid");
            if (docid == null) {
                DownloadFileRestlet.handleError(res, "you must specify a valid document IdRef");
                return;
            }
            DocumentModel dm = documentManager.getDocument((DocumentRef)new IdRef(docid));
            String blobPropertyName = DownloadFileRestlet.getQueryParamValue(req, "blobPropertyName", null);
            String filenamePropertyName = DownloadFileRestlet.getQueryParamValue(req, "filenamePropertyName", null);
            if (blobPropertyName != null && filenamePropertyName != null) {
                filename = (String)((Object)dm.getPropertyValue(filenamePropertyName));
                blob = (Blob)dm.getPropertyValue(blobPropertyName);
                xpath = blobPropertyName;
            } else {
                String schemaName = DownloadFileRestlet.getQueryParamValue(req, "schema", "file");
                String blobFieldName = DownloadFileRestlet.getQueryParamValue(req, "blobField", "content");
                blob = (Blob)dm.getProperty(schemaName, blobFieldName);
                filename = (String)StringUtils.defaultIfBlank((CharSequence)blob.getFilename(), (CharSequence)"file");
                xpath = schemaName + ':' + blobFieldName;
            }
            String reason = "download";
            Map extendedInfos = null;
            DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
            downloadService.downloadBlob(request, response, dm, xpath, blob, filename, reason, extendedInfos, null, byteRange -> this.setEntityToBlobOutput(blob, (DownloadService.ByteRange)byteRange, res));
        }
        catch (IOException | NuxeoException e) {
            DownloadFileRestlet.handleError(res, (Exception)e);
        }
    }
}

