/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.rest;

import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.ecm.platform.ui.web.rest.RestHelper;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.runtime.api.Framework;

public class FancyNavigationHandler
extends ConfigurableNavigationHandler {
    private static final Log log = LogFactory.getLog(FancyNavigationHandler.class);
    private final NavigationHandler parent;
    public static final String DISABLE_REDIRECT_FOR_URL_REWRITE = FancyNavigationHandler.class.getCanonicalName() + ".DISABLE_REDIRECT_FOR_URL_REWRITE";

    public FancyNavigationHandler(NavigationHandler navigationHandler) {
        this.parent = navigationHandler;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        Object disable;
        boolean rootChanged;
        ExternalContext eContext = context.getExternalContext();
        HttpServletRequest httpRequest = (HttpServletRequest)eContext.getRequest();
        httpRequest.setAttribute("PostOutcome", (Object)outcome);
        URLPolicyService pservice = (URLPolicyService)Framework.getService(URLPolicyService.class);
        pservice.appendParametersToRequest(context);
        UIViewRoot oldRoot = context.getViewRoot();
        this.parent.handleNavigation(context, fromAction, outcome);
        UIViewRoot newRoot = context.getViewRoot();
        boolean bl = rootChanged = !oldRoot.equals(newRoot);
        if (outcome != null && !context.getResponseComplete() && !rootChanged && Framework.isDevModeSet()) {
            this.handleHotReloadNavigation(pservice, context, fromAction, outcome);
        }
        if (Boolean.TRUE.equals(disable = httpRequest.getAttribute(DISABLE_REDIRECT_FOR_URL_REWRITE))) {
            return;
        }
        boolean ajaxRequest = context.getPartialViewContext().isAjaxRequest();
        if (outcome == null && !ajaxRequest && !context.getResponseComplete()) {
            String url = httpRequest.getRequestURL().toString();
            String localUrl = BaseURL.getServerURL((ServletRequest)httpRequest, true);
            String baseUrl = BaseURL.getServerURL((ServletRequest)httpRequest, false);
            if (localUrl != null && !localUrl.equals(baseUrl)) {
                url = StringUtils.replaceOnce((String)url, (String)localUrl, (String)baseUrl);
            }
            if (Contexts.isEventContextActive()) {
                int jsessionidIndex = url.indexOf(";jsessionid");
                if (jsessionidIndex != -1) {
                    url = url.substring(0, jsessionidIndex);
                }
                url = RestHelper.addMainConversationParameters(url);
            }
            try {
                eContext.redirect(url);
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected void handleHotReloadNavigation(URLPolicyService pservice, FacesContext context, String fromAction, String outcome) {
        String viewId = pservice.getViewIdFromOutcome(outcome, null);
        ExternalContext extContext = context.getExternalContext();
        if (viewId != null) {
            ViewHandler viewHandler = Util.getViewHandler((FacesContext)context);
            String newPath = viewHandler.getActionURL(context, viewId);
            try {
                extContext.redirect(extContext.encodeActionURL(newPath));
            }
            catch (IOException ioe) {
                throw new FacesException(ioe.getMessage(), (Throwable)ioe);
            }
            context.responseComplete();
        }
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        if (this.parent instanceof ConfigurableNavigationHandler) {
            return ((ConfigurableNavigationHandler)this.parent).getNavigationCase(context, fromAction, outcome);
        }
        return null;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        if (this.parent instanceof ConfigurableNavigationHandler) {
            return ((ConfigurableNavigationHandler)this.parent).getNavigationCases();
        }
        return null;
    }
}

