/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.documentsLists;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.util.DocumentsListsUtils;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListDescriptor;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsPersistenceManager;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsService;
import org.nuxeo.runtime.api.Framework;

public abstract class BaseDocumentsListsManager
implements Serializable {
    private static final long serialVersionUID = 98757690654316L;
    private static DocumentsListsService dlService;
    private transient DocumentsListsPersistenceManager persistenceManager;
    protected final Map<String, List<DocumentModel>> documentsLists = new HashMap<String, List<DocumentModel>>();
    protected final Map<String, List<DocumentModel>> documentsListsPerConversation = new HashMap<String, List<DocumentModel>>();
    protected final Map<String, List<String>> documentsLists_events = new HashMap<String, List<String>>();
    protected final Map<String, DocumentsListDescriptor> documentsLists_descriptors = new HashMap<String, DocumentsListDescriptor>();
    protected String userName;

    protected DocumentsListsService getService() {
        if (dlService == null) {
            dlService = (DocumentsListsService)((Object)Framework.getRuntime().getComponent("org.nuxeo.ecm.webapp.documentsLists.DocumentsListsService"));
        }
        return dlService;
    }

    protected String getUserName() {
        return this.userName;
    }

    protected void setUserName(String userName) {
        this.userName = userName;
    }

    protected abstract void notifyListUpdated(String var1);

    protected DocumentsListsPersistenceManager getPersistenceManager() {
        if (this.persistenceManager == null) {
            this.persistenceManager = new DocumentsListsPersistenceManager();
        }
        return this.persistenceManager;
    }

    public List<DocumentModel> resetWorkingList(String listName) {
        if (!this.documentsLists.containsKey(listName)) {
            return null;
        }
        List<DocumentModel> docList = this.getWorkingList(listName);
        DocumentsListDescriptor desc = this.getWorkingListDescriptor(listName);
        if (desc.getPersistent()) {
            if (this.getPersistenceManager().clearPersistentList(this.userName, listName)) {
                docList.clear();
            }
        } else {
            docList.clear();
        }
        this.notifyListUpdated(listName);
        return docList;
    }

    public boolean isWorkingListEmpty(String listName) {
        if (!this.documentsLists.containsKey(listName)) {
            return true;
        }
        List<DocumentModel> docList = this.getWorkingList(listName);
        return docList.isEmpty();
    }

    public void removeFromAllLists(List<DocumentModel> documentsToRemove) {
        for (String listName : this.documentsLists.keySet()) {
            this.removeFromWorkingList(listName, documentsToRemove);
            this.notifyListUpdated(listName);
        }
    }

    public void createWorkingList(String listName, DocumentsListDescriptor descriptor) {
        this.createWorkingList(listName, descriptor, null, null);
    }

    public void createWorkingList(String listName, DocumentsListDescriptor descriptor, CoreSession session, String userName) {
        if (this.documentsLists.containsKey(listName)) {
            return;
        }
        if (descriptor != null && descriptor.getPersistent() && session != null && userName != null) {
            this.documentsLists.put(listName, this.getPersistenceManager().loadPersistentDocumentsLists(session, userName, listName));
        } else {
            this.documentsLists.put(listName, new ArrayList());
        }
        if (descriptor == null) {
            descriptor = new DocumentsListDescriptor(listName);
        }
        this.documentsLists_descriptors.put(listName, descriptor);
        for (String eventName : descriptor.getEventsName()) {
            if (this.documentsLists_events.containsKey(eventName)) {
                this.documentsLists_events.get(eventName).add(listName);
                continue;
            }
            ArrayList<String> suscribersList = new ArrayList<String>();
            suscribersList.add(listName);
            this.documentsLists_events.put(eventName, suscribersList);
        }
    }

    public List<String> getWorkingListNamesForCategory(String categoryName) {
        ArrayList<String> res = new ArrayList<String>();
        for (String listName : this.documentsLists_descriptors.keySet()) {
            if (!this.documentsLists_descriptors.get(listName).getCategory().equals(categoryName)) continue;
            if (this.documentsLists_descriptors.get(listName).getDefaultInCategory()) {
                res.add(0, listName);
                continue;
            }
            res.add(listName);
        }
        return res;
    }

    public List<DocumentModel> resetWorkingList(String listName, List<DocumentModel> newDocList) {
        this.resetWorkingList(listName);
        return this.addToWorkingList(listName, newDocList);
    }

    public List<DocumentModel> removeFromWorkingList(String listName, List<DocumentModel> lst) {
        if (!this.documentsLists.containsKey(listName)) {
            return null;
        }
        List<DocumentModel> docList = this.getWorkingList(listName);
        DocumentsListDescriptor desc = this.getWorkingListDescriptor(listName);
        for (DocumentModel doc : lst) {
            if (desc.getPersistent()) {
                if (!this.getPersistenceManager().removeDocumentFromPersistentList(this.userName, listName, doc)) continue;
                docList.remove(doc);
                continue;
            }
            docList.remove(doc);
        }
        this.notifyListUpdated(listName);
        return docList;
    }

    public List<DocumentModel> removeFromWorkingList(String listName, DocumentModel doc) {
        if (!this.documentsLists.containsKey(listName)) {
            return null;
        }
        List<DocumentModel> docList = this.getWorkingList(listName);
        DocumentsListDescriptor desc = this.getWorkingListDescriptor(listName);
        if (desc.getPersistent()) {
            if (this.getPersistenceManager().removeDocumentFromPersistentList(this.userName, listName, doc)) {
                docList.remove(doc);
            }
        } else {
            docList.remove(doc);
        }
        this.notifyListUpdated(listName);
        return docList;
    }

    public List<DocumentModel> addToWorkingList(String listName, List<DocumentModel> docList) {
        return this.addToWorkingList(listName, docList, false);
    }

    public List<DocumentModel> addToWorkingList(String listName, List<DocumentModel> docList, Boolean forceAppend) {
        if (!this.documentsLists.containsKey(listName)) {
            return null;
        }
        List<DocumentModel> currentDocList = this.getWorkingList(listName);
        DocumentsListDescriptor currentDescriptor = this.getWorkingListDescriptor(listName);
        Boolean currentListIsPersistent = false;
        if (currentDescriptor != null) {
            if (!forceAppend.booleanValue() && !this.getWorkingListDescriptor(listName).getSupportAppends()) {
                currentDocList.clear();
            }
            currentListIsPersistent = currentDescriptor.getPersistent();
        }
        List docRefList = DocumentsListsUtils.getDocRefs(currentDocList);
        for (DocumentModel doc : docList) {
            if (docRefList.contains(doc.getRef())) continue;
            if (currentListIsPersistent.booleanValue()) {
                if (this.getPersistenceManager().addDocumentToPersistentList(this.userName, listName, doc).booleanValue()) {
                    // empty if block
                }
                currentDocList.add(doc);
                continue;
            }
            currentDocList.add(doc);
        }
        this.notifyListUpdated(listName);
        return currentDocList;
    }

    public List<DocumentModel> addToWorkingList(String listName, DocumentModel doc) {
        List docRefList;
        if (!this.documentsLists.containsKey(listName)) {
            return null;
        }
        List<DocumentModel> docList = this.getWorkingList(listName);
        DocumentsListDescriptor currentDescriptor = this.getWorkingListDescriptor(listName);
        boolean currentListIsPersistent = false;
        if (currentDescriptor != null) {
            currentListIsPersistent = currentDescriptor.getPersistent();
        }
        if (!(docRefList = DocumentsListsUtils.getDocRefs(docList)).contains(doc.getRef())) {
            if (currentListIsPersistent) {
                if (this.getPersistenceManager().addDocumentToPersistentList(this.userName, listName, doc).booleanValue()) {
                    // empty if block
                }
                docList.add(doc);
            } else {
                docList.add(doc);
            }
        }
        this.notifyListUpdated(listName);
        return docList;
    }

    public void setWorkingList(String listName, List<DocumentModel> docList) {
        if (this.documentsLists.containsKey(listName)) {
            this.documentsLists.put(listName, docList);
        }
    }

    public List<String> getWorkingListTypes(String listName) {
        if (!this.documentsLists.containsKey(listName)) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (DocumentModel doc : this.documentsLists.get(listName)) {
            String dt = doc.getType();
            if (res.contains(dt)) continue;
            res.add(dt);
        }
        return res;
    }

    public DocumentsListDescriptor getWorkingListDescriptor(String listName) {
        if (!this.documentsLists.containsKey(listName)) {
            return null;
        }
        return this.documentsLists_descriptors.get(listName);
    }

    public List<DocumentModel> getWorkingList(String listName) {
        if (this.documentsLists.containsKey(listName)) {
            return this.documentsLists.get(listName);
        }
        return null;
    }
}

