/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.renderView;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.platform.threed.renderView.RenderViewItem;
import org.nuxeo.ecm.platform.threed.service.ThreeDService;
import org.nuxeo.runtime.api.Framework;

@Name(value="renderViewActions")
@Scope(value=ScopeType.EVENT)
public class RenderViewActions {
    public List<RenderViewItem> getItems(DocumentModel doc) throws PropertyException {
        if (!doc.hasFacet("ThreeD")) {
            return Collections.emptyList();
        }
        int size = ((List)doc.getProperty("threed:renderViews").getValue(List.class)).size();
        ArrayList<RenderViewItem> items = new ArrayList<RenderViewItem>(size);
        for (int i = 0; i < size; ++i) {
            items.add(new RenderViewItem(doc, "threed:renderViews", i));
        }
        return items;
    }

    public boolean isConvertingRenders(DocumentModel doc) {
        ThreeDService service = (ThreeDService)Framework.getService(ThreeDService.class);
        return !service.getBatchProgress(doc.getRepositoryName(), doc.getId()).isUnknown();
    }
}

