/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.rendition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionProvider;
import org.nuxeo.ecm.platform.threed.ThreeDDocument;
import org.nuxeo.ecm.platform.threed.rendition.RenderViewRenditionProvider;
import org.nuxeo.ecm.platform.threed.rendition.TransmissionThreeDRenditionProvider;
import org.nuxeo.ecm.platform.threed.service.AutomaticLOD;
import org.nuxeo.ecm.platform.threed.service.RenderView;
import org.nuxeo.ecm.platform.threed.service.ThreeDService;
import org.nuxeo.runtime.api.Framework;

public class ThreeDRenditionDefinitionProvider
implements RenditionDefinitionProvider {
    public static final String THREED_RENDER_VIEW_RENDITION_KIND = "nuxeo:threedRenderView:conversion";
    public static final String THREED_TRANSMISSION_RENDITION_KIND = "nuxeo:threedTransmission:conversion";
    public static final String THREED_RENDER_VIEW_RENDITION_TYPE = "Render";
    public static final String THREED_TRANSMISSION_RENDITION_TYPE = "LoD";

    protected RenditionDefinition buildRenditionDefinition(String title, String name, Blob blob, String kind, RenditionProvider provider, boolean visible, String iconPath) {
        RenditionDefinition renditionDefinition = new RenditionDefinition();
        renditionDefinition.setEnabled(true);
        renditionDefinition.setName(name);
        renditionDefinition.setKind(kind);
        renditionDefinition.setProvider(provider);
        renditionDefinition.setVisible(visible);
        renditionDefinition.setLabel(title);
        renditionDefinition.setIcon("/icons/" + iconPath);
        return renditionDefinition;
    }

    public List<RenditionDefinition> getRenditionDefinitions(DocumentModel doc) {
        ThreeDDocument threeD = (ThreeDDocument)doc.getAdapter(ThreeDDocument.class);
        if (threeD == null) {
            return Collections.emptyList();
        }
        ThreeDService threeDService = (ThreeDService)Framework.getService(ThreeDService.class);
        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        ArrayList<RenditionDefinition> renditionDefinitions = new ArrayList<RenditionDefinition>();
        renditionDefinitions.addAll(threeD.getRenderViews().stream().filter(threeDRenderView -> {
            RenderView renderView = threeDService.getRenderView(Integer.valueOf(threeDRenderView.getAzimuth()), Integer.valueOf(threeDRenderView.getZenith()));
            return renderView != null && renderView.isEnabled() && renderView.isRendition() && threeDRenderView.getContent() != null;
        }).map(threeDRenderView -> {
            RenderView renderView = threeDService.getRenderView(Integer.valueOf(threeDRenderView.getAzimuth()), Integer.valueOf(threeDRenderView.getZenith()));
            MimetypeEntry mimeType = mimetypeRegistry.getMimetypeEntryByMimeType(threeDRenderView.getContent().getMimeType());
            return this.buildRenditionDefinition(THREED_RENDER_VIEW_RENDITION_TYPE + threeDRenderView.getTitle(), threeDRenderView.getTitle(), threeDRenderView.getContent(), THREED_RENDER_VIEW_RENDITION_KIND, new RenderViewRenditionProvider(), renderView.isRenditionVisible(), mimeType.getIconPath());
        }).collect(Collectors.toList()));
        renditionDefinitions.addAll(threeD.getTransmissionThreeDs().stream().filter(transmissionThreeD -> {
            AutomaticLOD automaticLOD = threeDService.getAutomaticLOD(transmissionThreeD.getId());
            return automaticLOD != null && automaticLOD.isEnabled() && automaticLOD.isRendition() && transmissionThreeD.getBlob() != null;
        }).map(transmissionThreeD -> {
            AutomaticLOD automaticLOD = threeDService.getAutomaticLOD(transmissionThreeD.getId());
            MimetypeEntry mimeType = mimetypeRegistry.getMimetypeEntryByMimeType(transmissionThreeD.getBlob().getMimeType());
            return this.buildRenditionDefinition(THREED_TRANSMISSION_RENDITION_TYPE + transmissionThreeD.getTitle(), transmissionThreeD.getTitle(), transmissionThreeD.getBlob(), THREED_TRANSMISSION_RENDITION_KIND, new TransmissionThreeDRenditionProvider(), automaticLOD.isRenditionVisible(), mimeType.getIconPath());
        }).collect(Collectors.toList()));
        return renditionDefinitions;
    }
}

