/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.core.datamodel;

import java.net.URI;
import java.net.URISyntaxException;
import yarfraw.core.datamodel.AbstractBaseObject;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.ValidationException;
import yarfraw.utils.ValidationUtils;

public class Enclosure
extends AbstractBaseObject {
    private static final long serialVersionUID = 20070927L;
    private String _url;
    private String _length;
    private String _mimeType;
    private String _value;

    public Enclosure() {
    }

    public Enclosure(String url, String length, String mimeType, String value) {
        this.setUrl(url);
        this.setLength(length);
        this.setMimeType(mimeType);
        this.setValue(value);
    }

    public URI getUrlAsUri() throws URISyntaxException {
        if (this._url != null) {
            return new URI(this._url.trim());
        }
        return null;
    }

    public Long getLengthAsLong() {
        if (this._length != null) {
            return Long.parseLong(this._length);
        }
        return null;
    }

    public String getUrl() {
        return this._url;
    }

    public Enclosure setUrl(String url) {
        this._url = url;
        return this;
    }

    public String getLength() {
        return this._length;
    }

    public Enclosure setLength(String length) {
        this._length = length;
        return this;
    }

    public String getMimeType() {
        return this._mimeType;
    }

    public Enclosure setMimeType(String mimeType) {
        this._mimeType = mimeType;
        return this;
    }

    public String getValue() {
        return this._value;
    }

    public Enclosure setValue(String value) {
        this._value = value;
        return this;
    }

    public void validate(FeedFormat format) throws ValidationException {
        if (format == FeedFormat.ATOM10) {
            return;
        }
        ValidationUtils.validateNotNull("Encloure: All fields in the enclosure object should be not null", this._length, this._mimeType, this._url, this._value);
    }
}

