/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.service;

import com.sun.faces.facelets.el.VariableMapperWrapper;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.BuiltinModes;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Layout;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRowDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutTypeConfiguration;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetReference;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetType;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeConfiguration;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.converters.LayoutConversionContext;
import org.nuxeo.ecm.platform.forms.layout.api.converters.LayoutDefinitionConverter;
import org.nuxeo.ecm.platform.forms.layout.api.converters.WidgetDefinitionConverter;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.LayoutException;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.WidgetException;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutRowComparator;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutRowImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetReferenceImpl;
import org.nuxeo.ecm.platform.forms.layout.core.service.AbstractLayoutManager;
import org.nuxeo.ecm.platform.forms.layout.descriptors.LayoutDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.LayoutTypeDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetTypeDescriptor;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.WidgetTypeHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.plugins.TemplateWidgetTypeHandler;
import org.nuxeo.ecm.platform.forms.layout.functions.LayoutFunctions;
import org.nuxeo.ecm.platform.forms.layout.service.DisabledPropertyRefDescriptor;
import org.nuxeo.ecm.platform.forms.layout.service.DisabledPropertyRefRegistry;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;

public class WebLayoutManagerImpl
extends AbstractLayoutManager
implements WebLayoutManager {
    public static final ComponentName NAME = new ComponentName(WebLayoutManagerImpl.class.getName());
    private static final Log log = LogFactory.getLog(WebLayoutManagerImpl.class);
    private static final long serialVersionUID = 1L;
    public static final String WIDGET_TYPES_EP_NAME = "widgettypes";
    public static final String LAYOUT_TYPES_EP_NAME = "layouttypes";
    public static final String WIDGETS_EP_NAME = "widgets";
    public static final String LAYOUTS_EP_NAME = "layouts";
    public static final String PROPS_REF_EP_NAME = "disabledPropertyRefs";
    protected DisabledPropertyRefRegistry disabledPropertyRefsReg = new DisabledPropertyRefRegistry();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(WIDGET_TYPES_EP_NAME)) {
            this.registerWidgetType(((WidgetTypeDescriptor)contribution).getWidgetTypeDefinition());
        } else if (extensionPoint.equals(LAYOUT_TYPES_EP_NAME)) {
            this.registerLayoutType(((LayoutTypeDescriptor)contribution).getLayoutTypeDefinition());
        } else if (extensionPoint.equals(LAYOUTS_EP_NAME)) {
            this.registerLayout(((LayoutDescriptor)contribution).getLayoutDefinition());
        } else if (extensionPoint.equals(WIDGETS_EP_NAME)) {
            this.registerWidget(((WidgetDescriptor)contribution).getWidgetDefinition());
        } else if (extensionPoint.equals(PROPS_REF_EP_NAME)) {
            this.registerDisabledPropertyRef((DisabledPropertyRefDescriptor)contribution);
        } else {
            log.error((Object)String.format("Unknown extension point '%s', can't register !", extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(WIDGET_TYPES_EP_NAME)) {
            this.unregisterWidgetType(((WidgetTypeDescriptor)contribution).getWidgetTypeDefinition());
        } else if (extensionPoint.equals(LAYOUT_TYPES_EP_NAME)) {
            this.unregisterLayoutType(((LayoutTypeDescriptor)contribution).getLayoutTypeDefinition());
        } else if (extensionPoint.equals(LAYOUTS_EP_NAME)) {
            this.unregisterLayout(((LayoutDescriptor)contribution).getLayoutDefinition());
        } else if (extensionPoint.equals(WIDGETS_EP_NAME)) {
            this.unregisterWidget(((WidgetDescriptor)contribution).getWidgetDefinition());
        } else if (extensionPoint.equals(PROPS_REF_EP_NAME)) {
            this.unregisterDisabledPropertyRef((DisabledPropertyRefDescriptor)contribution);
        } else {
            log.error((Object)String.format("Unknown extension point '%s', can't unregister !", extensionPoint));
        }
    }

    public String getDefaultStoreCategory() {
        return "jsf";
    }

    @Override
    public WidgetTypeHandler getWidgetTypeHandler(TagConfig config, String typeCategory, String typeName) throws WidgetException {
        WidgetTypeHandler handler;
        WidgetType type;
        if (StringUtils.isBlank((CharSequence)typeCategory)) {
            typeCategory = this.getDefaultStoreCategory();
        }
        if ((type = this.getLayoutStore().getWidgetType(typeCategory, typeName)) == null) {
            return null;
        }
        Class klass = type.getWidgetTypeClass();
        if (klass == null) {
            handler = new TemplateWidgetTypeHandler(config);
        } else {
            try {
                Constructor ctor = klass.getDeclaredConstructor(TagConfig.class);
                ctor.setAccessible(true);
                handler = (WidgetTypeHandler)((Object)ctor.newInstance(config));
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)"Caught error when instanciating widget type handler", (Throwable)e);
                return null;
            }
        }
        ((WidgetTypeHandler)handler).setProperties(type.getProperties());
        return handler;
    }

    @Override
    public WidgetTypeHandler getWidgetTypeHandler(TagConfig config, Widget widget) throws WidgetException {
        if (widget == null) {
            return null;
        }
        WidgetTypeHandler handler = this.getWidgetTypeHandler(config, widget.getTypeCategory(), widget.getType());
        if (handler != null) {
            handler.setWidget(widget);
        }
        return handler;
    }

    protected static Object evaluateExpression(FaceletContext context, String expression) {
        if (expression == null) {
            return null;
        }
        if (context == null) {
            return expression;
        }
        Object value = ComponentTagUtils.resolveElExpression((FaceletContext)context, (String)expression);
        if (value != null && value instanceof String) {
            value = ComponentTagUtils.resolveElExpression((FaceletContext)context, (String)((String)value));
        }
        return value;
    }

    protected static Boolean getBooleanValue(FaceletContext context, String expression) {
        Object value = WebLayoutManagerImpl.evaluateExpression(context, expression);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null || value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        log.error((Object)("Could not get boolean value for '" + value + "' in expression '" + expression + "'"));
        return Boolean.FALSE;
    }

    protected static String getStringValue(FaceletContext context, String expression) {
        Object value = WebLayoutManagerImpl.evaluateExpression(context, expression);
        if (value == null || value instanceof String) {
            return (String)value;
        }
        log.error((Object)("Could not get string value for '" + value + "' in expression '" + expression + "'"));
        return null;
    }

    protected static String getModeFromLayoutMode(FaceletContext context, WidgetDefinition wDef, String layoutMode) {
        String wMode = WebLayoutManagerImpl.getStringValue(context, wDef.getMode(layoutMode));
        if (wMode == null) {
            wMode = BuiltinModes.getWidgetModeFromLayoutMode((String)layoutMode);
        }
        return wMode;
    }

    @Override
    public Widget getWidget(FaceletContext ctx, String widgetName, String widgetCategory, String layoutMode, String valueName, String layoutName) {
        WidgetReferenceImpl widgetRef = new WidgetReferenceImpl(widgetCategory, widgetName);
        WidgetDefinition wDef = this.lookupWidget((WidgetReference)widgetRef);
        return this.getWidget(ctx, null, null, layoutName, null, wDef, widgetCategory, layoutMode, valueName, 0);
    }

    @Override
    public Widget getWidget(FaceletContext ctx, WidgetDefinition wDef, String layoutMode, String valueName, String layoutName) {
        return this.getWidget(ctx, null, null, layoutName, null, wDef, this.getDefaultStoreCategory(), layoutMode, valueName, 0);
    }

    @Override
    public Widget getWidget(FaceletContext ctx, LayoutConversionContext lctx, String conversionCat, WidgetDefinition widgetDef, String layoutMode, String valueName, String layoutName) {
        return this.getWidget(ctx, null, null, layoutName, null, widgetDef, this.getDefaultStoreCategory(), layoutMode, valueName, 0);
    }

    protected Widget getWidget(FaceletContext context, LayoutConversionContext lctx, String conversionCat, String layoutName, LayoutDefinition layoutDef, WidgetDefinition widgetDefinition, String widgetCategory, String layoutMode, String valueName, int level) {
        WidgetTypeConfiguration conf;
        WidgetReference[] swRefs;
        if (widgetDefinition == null) {
            return null;
        }
        WidgetDefinition wDef = widgetDefinition.clone();
        if (lctx != null && !StringUtils.isBlank((CharSequence)conversionCat)) {
            List lcs = this.getLayoutStore().getWidgetConverters(conversionCat);
            for (WidgetDefinitionConverter wc : lcs) {
                wDef = wc.getWidgetDefinition(wDef, lctx);
            }
        }
        VariableMapper orig = null;
        if (context != null) {
            orig = context.getVariableMapper();
            VariableMapperWrapper vm = new VariableMapperWrapper(orig);
            context.setVariableMapper((VariableMapper)vm);
            ExpressionFactory eFactory = context.getExpressionFactory();
            ValueExpression modeVe = eFactory.createValueExpression((Object)layoutMode, String.class);
            vm.setVariable(RenderVariables.globalVariables.mode.name(), modeVe);
        }
        String wMode = WebLayoutManagerImpl.getModeFromLayoutMode(context, wDef, layoutMode);
        if (context != null) {
            context.setVariableMapper(orig);
        }
        if ("hidden".equals(wMode)) {
            return null;
        }
        ArrayList<Widget> subWidgets = new ArrayList<Widget>();
        WidgetDefinition[] swDefs = wDef.getSubWidgetDefinitions();
        if (swDefs != null) {
            for (WidgetDefinition swDef : swDefs) {
                Widget subWidget = this.getWidget(context, lctx, conversionCat, layoutName, layoutDef, swDef, widgetCategory, wMode, valueName, level + 1);
                if (subWidget == null) continue;
                subWidgets.add(subWidget);
            }
        }
        if ((swRefs = wDef.getSubWidgetReferences()) != null) {
            for (WidgetReference swRef : swRefs) {
                WidgetDefinition swDef;
                String cat = swRef.getCategory();
                if (StringUtils.isBlank((CharSequence)cat)) {
                    cat = widgetCategory;
                }
                if ((swDef = this.lookupWidget(layoutDef, (WidgetReference)new WidgetReferenceImpl(cat, swRef.getName()))) == null) {
                    log.error((Object)("Widget '" + swRef.getName() + "' not found in layout " + layoutName));
                    continue;
                }
                Widget subWidget = this.getWidget(context, lctx, conversionCat, layoutName, layoutDef, swDef, cat, wMode, valueName, level + 1);
                if (subWidget == null) continue;
                subWidgets.add(subWidget);
            }
        }
        boolean required = WebLayoutManagerImpl.getBooleanValue(context, wDef.getRequired(layoutMode, wMode));
        String wType = wDef.getType();
        String wTypeCat = wDef.getTypeCategory();
        HashMap props = new HashMap();
        HashMap controls = new HashMap();
        String actualWTypeCat = this.getStoreCategory(wTypeCat);
        WidgetTypeDefinition def = this.getLayoutStore().getWidgetTypeDefinition(actualWTypeCat, wType);
        WidgetTypeConfiguration widgetTypeConfiguration = conf = def != null ? def.getConfiguration() : null;
        if (conf != null) {
            Map defaultControls;
            Map defaultProps = conf.getDefaultPropertyValues(wMode);
            if (defaultProps != null && !defaultProps.isEmpty()) {
                props.putAll(defaultProps);
            }
            if ((defaultControls = conf.getDefaultControlValues(wMode)) != null && !defaultControls.isEmpty()) {
                controls.putAll(defaultControls);
            }
        }
        props.putAll(wDef.getProperties(layoutMode, wMode));
        controls.putAll(wDef.getControls(layoutMode, wMode));
        WidgetImpl widget = new WidgetImpl(layoutName, wDef.getName(), wMode, wType, valueName, wDef.getFieldDefinitions(), wDef.getLabel(layoutMode), wDef.getHelpLabel(layoutMode), wDef.isTranslated(), wDef.isHandlingLabels(), props, required, subWidgets.toArray(new Widget[0]), level, wDef.getSelectOptions(), LayoutFunctions.computeWidgetDefinitionId((WidgetDefinition)wDef), wDef.getRenderingInfos(layoutMode));
        widget.setControls(controls);
        widget.setTypeCategory(actualWTypeCat);
        if (Framework.isDevModeSet()) {
            widget.setDefinition(wDef);
        }
        return widget;
    }

    @Override
    public Layout getLayout(FaceletContext ctx, String layoutName, String mode, String valueName) throws LayoutException {
        return this.getLayout(ctx, layoutName, mode, valueName, null, false);
    }

    @Override
    public Layout getLayout(FaceletContext ctx, String layoutName, String mode, String valueName, List<String> selectedRows, boolean selectAllRowsByDefault) {
        return this.getLayout(ctx, layoutName, null, mode, valueName, selectedRows, selectAllRowsByDefault);
    }

    @Override
    public Layout getLayout(FaceletContext ctx, String layoutName, String layoutCategory, String mode, String valueName, List<String> selectedRows, boolean selectAllRowsByDefault) {
        LayoutDefinition layoutDef;
        if (StringUtils.isBlank((CharSequence)layoutCategory)) {
            layoutCategory = this.getDefaultStoreCategory();
        }
        if ((layoutDef = this.getLayoutStore().getLayoutDefinition(layoutCategory, layoutName)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Layout '" + layoutName + "' not found for category '" + layoutCategory + "'"));
            }
            return null;
        }
        return this.getLayout(ctx, layoutDef, mode, valueName, selectedRows, selectAllRowsByDefault);
    }

    @Override
    public Layout getLayout(FaceletContext ctx, LayoutDefinition layoutDef, String mode, String valueName, List<String> selectedRows, boolean selectAllRowsByDefault) {
        return this.getLayout(ctx, null, null, layoutDef, mode, valueName, selectedRows, selectAllRowsByDefault);
    }

    @Override
    public Layout getLayout(FaceletContext ctx, LayoutConversionContext lctx, String conversionCat, LayoutDefinition layoutDefinition, String mode, String valueName, List<String> selectedRows, boolean selectAllRowsByDefault) {
        LayoutImpl layout;
        boolean scaffold;
        Map lprops;
        if (layoutDefinition == null) {
            log.debug((Object)"Layout definition is null");
            return null;
        }
        if (ctx == null) {
            log.warn((Object)"Layout creation computed in a null facelet context: expressions found in the layout definition will not be evaluated");
        }
        LayoutDefinition lDef = layoutDefinition.clone();
        if (lctx != null && !StringUtils.isBlank((CharSequence)conversionCat)) {
            List lcs = this.getLayoutStore().getLayoutConverters(conversionCat);
            for (LayoutDefinitionConverter lc : lcs) {
                lDef = lc.getLayoutDefinition(lDef, lctx);
            }
        }
        String layoutName = lDef.getName();
        String layoutTypeCategory = lDef.getTypeCategory();
        String actualLayoutTypeCategory = this.getStoreCategory(layoutTypeCategory);
        LayoutTypeDefinition layoutTypeDef = null;
        String layoutType = lDef.getType();
        if (!StringUtils.isBlank((CharSequence)layoutType) && (layoutTypeDef = this.getLayoutStore().getLayoutTypeDefinition(actualLayoutTypeCategory, layoutType)) == null) {
            log.warn((Object)("Layout type '" + layoutType + "' not found for category '" + layoutTypeCategory + "'"));
        }
        String template = lDef.getTemplate(mode);
        HashMap props = new HashMap();
        if (layoutTypeDef != null) {
            Map typeProps;
            LayoutTypeConfiguration conf;
            if (StringUtils.isEmpty((CharSequence)template)) {
                template = layoutTypeDef.getTemplate(mode);
            }
            if ((conf = layoutTypeDef.getConfiguration()) != null && (typeProps = conf.getDefaultPropertyValues(mode)) != null) {
                props.putAll(typeProps);
            }
        }
        if ((lprops = lDef.getProperties(mode)) != null) {
            props.putAll(lprops);
        }
        if (scaffold = Boolean.parseBoolean(String.valueOf(props.get("scaffold")))) {
            LinkedHashMap<String, Widget> widgetsMap = new LinkedHashMap<String, Widget>();
            Map widgetDefs = lDef.getWidgetDefinitions();
            if (widgetDefs != null) {
                for (WidgetDefinition widgetDef : widgetDefs.values()) {
                    WidgetDefinition wDef;
                    String widgetName = widgetDef.getName();
                    if (StringUtils.isBlank((CharSequence)widgetName)) continue;
                    String cat = null;
                    if (StringUtils.isBlank(cat)) {
                        cat = this.getDefaultStoreCategory();
                    }
                    if ((wDef = this.lookupWidget(lDef, (WidgetReference)new WidgetReferenceImpl(cat, widgetName))) == null) {
                        log.error((Object)("Widget '" + widgetName + "' not found in layout " + layoutName));
                        continue;
                    }
                    Widget widget = this.getWidget(ctx, lctx, conversionCat, layoutName, lDef, wDef, cat, mode, valueName, 0);
                    if (widget == null) continue;
                    widgetsMap.put(widgetName, widget);
                }
            }
            layout = new LayoutImpl(lDef.getName(), mode, template, widgetsMap, props, LayoutFunctions.computeLayoutDefinitionId((LayoutDefinition)lDef));
        } else {
            LayoutRowDefinition[] rowsDef = lDef.getRows();
            ArrayList<LayoutRowImpl> rows = new ArrayList<LayoutRowImpl>();
            HashSet<String> foundRowNames = new HashSet<String>();
            int rowIndex = -1;
            for (LayoutRowDefinition rowDef : rowsDef) {
                ++rowIndex;
                String rowName = rowDef.getName();
                if (rowName == null) {
                    rowName = rowDef.getDefaultName(rowIndex);
                    if (selectedRows != null && log.isDebugEnabled()) {
                        log.debug((Object)("Generating default name '" + rowName + "' in layout '" + layoutName + "' for row or column at index " + rowIndex));
                    }
                }
                boolean emptyRow = true;
                if (selectedRows != null && !selectedRows.contains(rowName) && !rowDef.isAlwaysSelected() || selectedRows == null && !selectAllRowsByDefault && !rowDef.isSelectedByDefault() && !rowDef.isAlwaysSelected()) continue;
                ArrayList<Widget> widgets = new ArrayList<Widget>();
                for (WidgetReference widgetRef : rowDef.getWidgetReferences()) {
                    WidgetDefinition wDef;
                    String widgetName = widgetRef.getName();
                    if (StringUtils.isBlank((CharSequence)widgetName)) {
                        widgets.add(null);
                        continue;
                    }
                    String cat = widgetRef.getCategory();
                    if (StringUtils.isBlank((CharSequence)cat)) {
                        cat = this.getDefaultStoreCategory();
                    }
                    if ((wDef = this.lookupWidget(lDef, (WidgetReference)new WidgetReferenceImpl(cat, widgetName))) == null) {
                        log.error((Object)("Widget '" + widgetName + "' not found in layout " + layoutName));
                        widgets.add(null);
                        continue;
                    }
                    Widget widget = this.getWidget(ctx, lctx, conversionCat, layoutName, lDef, wDef, cat, mode, valueName, 0);
                    if (widget != null) {
                        emptyRow = false;
                    }
                    widgets.add(widget);
                }
                if (!emptyRow) {
                    rows.add(new LayoutRowImpl(rowName, rowDef.isSelectedByDefault(), rowDef.isAlwaysSelected(), widgets, rowDef.getProperties(mode), LayoutFunctions.computeLayoutRowDefinitionId((LayoutRowDefinition)rowDef)));
                }
                foundRowNames.add(rowName);
            }
            if (selectedRows != null) {
                Collections.sort(rows, new LayoutRowComparator(selectedRows));
                for (String selectedRow : selectedRows) {
                    if (foundRowNames.contains(selectedRow)) continue;
                    log.warn((Object)("Selected row or column named '" + selectedRow + "' was not found in layout '" + layoutName + "'"));
                }
            }
            layout = new LayoutImpl(lDef.getName(), mode, template, rows, lDef.getColumns(), props, LayoutFunctions.computeLayoutDefinitionId((LayoutDefinition)lDef));
        }
        layout.setValueName(valueName);
        layout.setType(layoutType);
        layout.setTypeCategory(actualLayoutTypeCategory);
        if (Framework.isDevModeSet()) {
            String devTemplate;
            layout.setDefinition(lDef);
            Map templates = lDef.getTemplates();
            String string = devTemplate = templates != null ? (String)templates.get("dev") : null;
            if (layoutTypeDef != null && StringUtils.isEmpty((CharSequence)devTemplate)) {
                Map typeTemplates = layoutTypeDef.getTemplates();
                devTemplate = typeTemplates != null ? (String)typeTemplates.get("dev") : null;
            }
            layout.setDevTemplate(devTemplate);
        }
        return layout;
    }

    @Override
    public Widget createWidget(FaceletContext ctx, String type, String mode, String valueName, List<FieldDefinition> fieldDefinitions, String label, String helpLabel, Boolean translated, Map<String, Serializable> properties, Widget[] subWidgets) {
        return this.createWidget(ctx, this.createWidgetDefinition(ctx, type, null, mode, valueName, fieldDefinitions, null, label, helpLabel, translated, properties, subWidgets), mode, valueName, subWidgets);
    }

    @Override
    public Widget createWidget(FaceletContext ctx, WidgetDefinition wDef, String mode, String valueName, Widget[] subWidgets) {
        Map modeControls;
        Map modeProps;
        WidgetTypeConfiguration conf;
        String wType = wDef.getType();
        String wTypeCat = wDef.getTypeCategory();
        HashMap props = new HashMap();
        HashMap controls = new HashMap();
        String actualWTypeCat = this.getStoreCategory(wTypeCat);
        WidgetTypeDefinition def = this.getLayoutStore().getWidgetTypeDefinition(actualWTypeCat, wType);
        boolean required = false;
        WidgetTypeConfiguration widgetTypeConfiguration = conf = def != null ? def.getConfiguration() : null;
        if (conf != null) {
            Map defaultControls;
            Map defaultProps = conf.getDefaultPropertyValues(mode);
            if (defaultProps != null && !defaultProps.isEmpty()) {
                props.putAll(defaultProps);
            }
            if ((defaultControls = conf.getDefaultControlValues(mode)) != null && !defaultControls.isEmpty()) {
                controls.putAll(defaultControls);
            }
        }
        if ((modeProps = wDef.getProperties(mode, mode)) != null) {
            props.putAll(modeProps);
            Serializable requiredProp = (Serializable)props.get("required");
            if (requiredProp != null) {
                if (requiredProp instanceof Boolean) {
                    required = (Boolean)requiredProp;
                } else if (requiredProp instanceof String) {
                    required = WebLayoutManagerImpl.getBooleanValue(ctx, (String)((Object)requiredProp));
                } else {
                    log.error((Object)("Invalid property 'required' on widget: '" + requiredProp + "'."));
                }
            }
        }
        if ((modeControls = wDef.getControls(mode, mode)) != null) {
            controls.putAll(modeControls);
        }
        WidgetImpl widget = new WidgetImpl("layout", wDef.getName(), mode, wType, valueName, wDef.getFieldDefinitions(), wDef.getLabel(mode), wDef.getHelpLabel(mode), wDef.isTranslated(), props, required, subWidgets, 0, null, LayoutFunctions.computeWidgetDefinitionId((WidgetDefinition)wDef));
        widget.setControls(controls);
        widget.setTypeCategory(actualWTypeCat);
        widget.setDynamic(wDef.isDynamic());
        widget.setGlobal(wDef.isGlobal());
        if (Framework.isDevModeSet()) {
            widget.setDefinition(wDef);
        }
        return widget;
    }

    protected WidgetDefinition createWidgetDefinition(FaceletContext ctx, String type, String category, String mode, String valueName, List<FieldDefinition> fieldDefinitions, String widgetName, String label, String helpLabel, Boolean translated, Map<String, Serializable> properties, Widget[] subWidgets) {
        String wName = widgetName;
        if (StringUtils.isBlank((CharSequence)widgetName)) {
            wName = type;
        }
        WidgetDefinitionImpl wDef = new WidgetDefinitionImpl(wName, type, label, helpLabel, Boolean.TRUE.equals(translated), null, fieldDefinitions, properties, null);
        wDef.setDynamic(true);
        return wDef;
    }

    protected void registerDisabledPropertyRef(DisabledPropertyRefDescriptor desc) {
        this.disabledPropertyRefsReg.addContribution(desc);
        log.info((Object)String.format("Registered disabled property reference descriptor: %s", desc.toString()));
    }

    protected void unregisterDisabledPropertyRef(DisabledPropertyRefDescriptor desc) {
        this.disabledPropertyRefsReg.removeContribution(desc);
        log.info((Object)String.format("Removed disabled property reference descriptor: %s", desc.toString()));
    }

    @Override
    public boolean referencePropertyAsExpression(String name, Serializable value, String widgetType, String widgetTypeCategory, String widgetMode, String template) {
        if (value instanceof String && ComponentTagUtils.isValueReference((String)((String)((Object)value)))) {
            return false;
        }
        String cat = widgetTypeCategory;
        if (widgetTypeCategory == null) {
            cat = "jsf";
        }
        for (DisabledPropertyRefDescriptor desc : this.disabledPropertyRefsReg.getDisabledPropertyRefs()) {
            if (!Boolean.TRUE.equals(desc.getEnabled()) || !desc.matches(name, widgetType, cat, widgetMode, template)) continue;
            return false;
        }
        return true;
    }
}

