/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.invalidations;

import java.lang.reflect.Method;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.core.BijectionInterceptor;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.invalidations.DocumentContextInvalidation;

@Interceptor(stateless=true, within={BijectionInterceptor.class})
public class DocumentContextInvalidatorInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;

    public Object aroundInvoke(InvocationContext invocationContext) throws Exception {
        this.beforeInvocation(invocationContext);
        return invocationContext.proceed();
    }

    private void beforeInvocation(InvocationContext invocationContext) {
        Object target = invocationContext.getTarget();
        for (Method meth : target.getClass().getMethods()) {
            if (!meth.isAnnotationPresent(DocumentContextInvalidation.class)) continue;
            this.doInvalidationCall(target, meth);
        }
    }

    private void doInvalidationCall(Object target, Method meth) {
        try {
            if (meth.getParameterTypes().length == 0) {
                meth.invoke(target, new Object[0]);
            } else {
                DocumentModel currentDoc = this.getCurrentDocumentModel();
                meth.invoke(target, currentDoc);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private DocumentModel getCurrentDocumentModel() {
        NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext", (ScopeType)ScopeType.CONVERSATION);
        return navigationContext.getCurrentDocument();
    }

    public boolean isInterceptorEnabled() {
        return true;
    }
}

