/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public final class MessageFactory {
    private MessageFactory() {
    }

    public static FacesMessage createMessage(FacesContext context, String messageId) {
        FacesMessage message;
        Locale locale = MessageFactory.getCurrentLocale(context);
        String messageBundle = context.getApplication().getMessageBundle();
        try {
            if (null != messageBundle) {
                try {
                    message = MessageFactory.getMessageFromBundle(locale, messageBundle, messageId);
                }
                catch (MissingResourceException e) {
                    message = MessageFactory.getMessageFromBundle(locale, "javax.faces.Messages", messageId);
                }
            } else {
                message = MessageFactory.getMessageFromBundle(locale, "javax.faces.Messages", messageId);
            }
        }
        catch (MissingResourceException e) {
            return new FacesMessage("conversion error");
        }
        return message;
    }

    private static FacesMessage getMessageFromBundle(Locale locale, String messageBundle, String messageId) throws MissingResourceException {
        String detail;
        ResourceBundle bundle = ResourceBundle.getBundle(messageBundle, locale, MessageFactory.getCurrentLoader(messageId));
        String summary = bundle.getString(messageId);
        try {
            detail = bundle.getString(messageId + "_detail");
        }
        catch (MissingResourceException e) {
            return new FacesMessage(summary);
        }
        return new FacesMessage(summary, detail);
    }

    public static Locale getCurrentLocale(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        Locale locale = null == viewRoot ? Locale.getDefault() : viewRoot.getLocale();
        return locale;
    }

    private static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }
}

