/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.file;

import com.sun.faces.renderkit.html_basic.FileRenderer;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileUploadBase;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.platform.ui.web.util.files.FileUtils;

public class NXFileRenderer
extends FileRenderer {
    public static final String RENDERER_TYPE = "javax.faces.NXFile";

    public void decode(FacesContext context, UIComponent component) {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldDecode(component)) {
            return;
        }
        String clientId = this.decodeBehaviors(context, component);
        if (clientId == null) {
            clientId = component.getClientId(context);
        }
        assert (clientId != null);
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestParameterMap();
        if (requestMap.containsKey(clientId)) {
            this.setSubmittedValue(component, requestMap.get(clientId));
        }
        HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
        try {
            Collection parts = request.getParts();
            for (Part cur : parts) {
                if (!clientId.equals(cur.getName())) continue;
                this.setSubmittedValue(component, FileUtils.createBlob(cur));
            }
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
        catch (ServletException se) {
            Throwable cause = se.getCause();
            if (cause instanceof FileUploadBase.InvalidContentTypeException || cause != null && cause.getClass().getName().contains("InvalidContentTypeException")) {
                this.setSubmittedValue(component, Blobs.createBlob((String)""));
            }
            throw new FacesException((Throwable)se);
        }
    }
}

