/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;

public class ValueExpressionHelper {
    private ValueExpressionHelper() {
    }

    public static boolean isFormattedAsELExpression(String expression) {
        return expression.contains(".") || expression.contains("[");
    }

    public static String createBareExpressionString(String valueName, FieldDefinition field) {
        String[] splittedFieldName;
        String propertyName;
        String[] s;
        if (field == null || "".equals(field.getPropertyName())) {
            return valueName;
        }
        String fieldName = field.getFieldName();
        if (ComponentTagUtils.isStrictValueReference((String)fieldName)) {
            return ComponentTagUtils.getBareValueName((String)fieldName);
        }
        if (ValueExpressionHelper.isFormattedAsELExpression(fieldName)) {
            StringBuilder builder = new StringBuilder();
            builder.append(valueName);
            if (!fieldName.startsWith(".") && !fieldName.startsWith("[")) {
                builder.append(".");
            }
            builder.append(fieldName);
            return builder.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(valueName);
        String schemaName = field.getSchemaName();
        if (schemaName == null && (s = (propertyName = field.getFieldName()).split(":")).length == 2) {
            schemaName = s[0];
            fieldName = s[1];
        }
        if (schemaName != null) {
            builder.append("['").append(schemaName).append("']");
        }
        for (String item : splittedFieldName = fieldName.split("/")) {
            builder.append("[");
            try {
                builder.append(Integer.parseInt(item));
            }
            catch (NumberFormatException e) {
                builder.append("'").append(item).append("'");
            }
            builder.append("]");
        }
        return builder.toString();
    }

    public static String createExpressionString(String valueName, FieldDefinition field) {
        String bareExpression = ValueExpressionHelper.createBareExpressionString(valueName, field);
        return "#{" + bareExpression + "}";
    }
}

