/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.platform.ui.web.directory.DirectorySelectItem;

public class Selection
implements Serializable {
    private static final long serialVersionUID = 2448256162710214563L;
    private final DirectorySelectItem[] columns;

    public Selection(DirectorySelectItem[] columns) {
        this.columns = columns;
    }

    public DirectorySelectItem[] getColumns() {
        return this.columns;
    }

    public DirectorySelectItem getColumn(int i) {
        return this.columns[i];
    }

    public String getColumnValue(int i) {
        if (i >= this.columns.length || this.columns[i] == null) {
            return null;
        }
        return (String)this.columns[i].getValue();
    }

    public String[] getValues() {
        String[] values = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            values[i] = (String)this.columns[i].getValue();
        }
        return values;
    }

    public String getValue() {
        return this.getValue(null);
    }

    public String getValue(String keySeparator) {
        Object[] values = this.getValues();
        return StringUtils.join((Object[])values, (String)(keySeparator != null ? keySeparator : "/"));
    }

    public String[] getLabels() {
        String[] labels = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            labels[i] = this.columns[i].getLabel();
        }
        return labels;
    }

    public String getParentKey(int index, boolean qualifiedParentKeys, String keySeparator) {
        if (index == 0) {
            return null;
        }
        String parentValue = null;
        if (qualifiedParentKeys) {
            Object[] keys = new String[index];
            for (int i = 0; i < index; ++i) {
                keys[i] = this.getColumnValue(i);
            }
            parentValue = StringUtils.join((Object[])keys, (String)(keySeparator != null ? keySeparator : "/"));
        } else {
            parentValue = this.getColumnValue(index - 1);
        }
        return parentValue;
    }

    public String toString() {
        return this.getValue(null);
    }

    public int getSize() {
        return this.columns.length;
    }
}

