/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.component;

import java.util.logging.Level;
import java.util.regex.Pattern;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.Router;
import org.restlet.VirtualHost;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class HostRoute
extends Route {
    public HostRoute(Router router, VirtualHost target) {
        super(router, "", (Restlet)target);
    }

    public VirtualHost getVirtualHost() {
        return (VirtualHost)this.getNext();
    }

    public void setNext(VirtualHost next) {
        super.setNext((Restlet)next);
    }

    public float score(Request request, Response response) {
        String serverAddress;
        int resourcePortValue;
        String resourceDomain;
        float result = 0.0f;
        String hostDomain = "";
        String hostPort = "";
        String hostScheme = "";
        if (request.getHostRef() != null) {
            int basePortValue;
            hostDomain = request.getHostRef().getHostDomain();
            if (hostDomain == null) {
                hostDomain = "";
            }
            if ((basePortValue = request.getHostRef().getHostPort()) == -1) {
                basePortValue = request.getHostRef().getSchemeProtocol().getDefaultPort();
            }
            hostPort = Integer.toString(basePortValue);
            hostScheme = request.getHostRef().getScheme();
            if (hostScheme == null) {
                hostScheme = "";
            }
        }
        if ((resourceDomain = request.getResourceRef().getHostDomain()) == null) {
            resourceDomain = "";
        }
        if ((resourcePortValue = request.getResourceRef().getHostPort()) == -1) {
            resourcePortValue = request.getResourceRef().getSchemeProtocol().getDefaultPort();
        }
        String resourcePort = Integer.toString(resourcePortValue);
        String resourceScheme = request.getResourceRef().getScheme();
        if (resourceScheme == null) {
            resourceScheme = "";
        }
        if ((serverAddress = response.getServerInfo().getAddress()) == null) {
            serverAddress = "";
        }
        String serverPort = "";
        if (response.getServerInfo().getPort() != -1) {
            serverPort = Integer.toString(response.getServerInfo().getPort());
        }
        if (this.matches(this.getVirtualHost().getHostDomain(), hostDomain) && this.matches(this.getVirtualHost().getHostPort(), hostPort) && this.matches(this.getVirtualHost().getHostScheme(), hostScheme) && this.matches(this.getVirtualHost().getResourceDomain(), resourceDomain) && this.matches(this.getVirtualHost().getResourcePort(), resourcePort) && this.matches(this.getVirtualHost().getResourceScheme(), resourceScheme) && this.matches(this.getVirtualHost().getServerAddress(), serverAddress) && this.matches(this.getVirtualHost().getServerPort(), serverPort)) {
            result = 1.0f;
        }
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer("Call score for the \"" + this.getVirtualHost().getName() + "\" host: " + result);
        }
        return result;
    }

    private boolean matches(String regex, String formattedString) {
        return Pattern.compile(regex, 2).matcher(formattedString).matches();
    }

    protected void beforeHandle(Request request, Response response) {
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().fine("New base URI: " + request.getResourceRef().getBaseRef());
            this.getLogger().fine("New remaining part: " + request.getResourceRef().getRemainingPart());
        }
    }
}

