/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.context.FacesContext;
import org.jboss.seam.excel.ExcelWorkbook;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.WorksheetItem;
import org.jboss.seam.excel.ui.ExcelComponent;
import org.jboss.seam.excel.ui.UIWorksheet;
import org.jboss.seam.excel.ui.command.Command;

public class UIColumn
extends ExcelComponent {
    public static final String COMPONENT_TYPE = "org.jboss.seam.excel.ui.UIColumn";
    public static final String HEADER_FACET_NAME = "header";
    private static final String FOOTER_FACET_NAME = "footer";

    public String getFamily() {
        return COMPONENT_TYPE;
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        ExcelWorkbook excelWorkbook = this.getWorkbook(this.getParent());
        if (excelWorkbook == null) {
            throw new ExcelWorkbookException("Could not find excel workbook");
        }
        excelWorkbook.applyColumnSettings(this);
        UIWorksheet sheet = (UIWorksheet)this.getParentByClass(this.getParent(), UIWorksheet.class);
        if (sheet == null) {
            throw new ExcelWorkbookException("Could not find worksheet");
        }
        WorksheetItem headerItem = (WorksheetItem)this.getFacet(HEADER_FACET_NAME);
        if (headerItem != null) {
            excelWorkbook.addItem(headerItem);
        }
        List<Command> commands = UIColumn.getCommands(this.getChildren());
        for (Command command : commands) {
            excelWorkbook.executeCommand(command);
        }
        for (WorksheetItem item : UIColumn.getItems(this.getChildren())) {
            Object oldValue = null;
            Iterator iterator = null;
            if (sheet.getVar() != null) {
                oldValue = FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get(sheet.getVar());
                iterator = sheet.getDataIterator();
            } else {
                iterator = new ArrayList().iterator();
            }
            while (iterator.hasNext()) {
                FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(sheet.getVar(), iterator.next());
                excelWorkbook.addItem(item);
            }
            if (sheet.getVar() == null) continue;
            if (oldValue == null) {
                FacesContext.getCurrentInstance().getExternalContext().getRequestMap().remove(sheet.getVar());
                continue;
            }
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(sheet.getVar(), oldValue);
        }
        WorksheetItem footerItem = (WorksheetItem)this.getFacet(FOOTER_FACET_NAME);
        if (footerItem != null) {
            excelWorkbook.addItem(footerItem);
        }
        excelWorkbook.nextColumn();
    }
}

