/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.view.facelets;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import org.richfaces.component.attribute.AutocompleteProps;
import org.richfaces.view.facelets.MethodMetadata;

public class AutocompleteHandler
extends ComponentHandler {
    private static final MetaRule AUTOCOMPLETE_METHOD_META_RULE = new MetaRule(){

        public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
            if (meta.isTargetInstanceOf(AutocompleteProps.class)) {
                if ("autocompleteMethod".equals(name)) {
                    final MethodMetadata oneParameterMetadata = new MethodMetadata(attribute, new Class[]{String.class}){

                        public void applyMetadata(FaceletContext ctx, Object instance) {
                            ((AutocompleteProps)instance).setAutocompleteMethodWithOneParameter(this.getMethodExpression(ctx));
                        }
                    };
                    return new MethodMetadata(attribute, new Class[]{FacesContext.class, UIComponent.class, String.class}){

                        public void applyMetadata(FaceletContext ctx, Object instance) {
                            ((AutocompleteProps)instance).setAutocompleteMethod(this.getMethodExpression(ctx));
                            ((AutocompleteProps)instance).setAutocompleteMethodWithOneParameter(oneParameterMetadata.getMethodExpression(ctx));
                        }
                    };
                }
                if ("converter".equals(name)) {
                    return new ConverterMetadata(attribute){

                        public void applyMetadata(FaceletContext ctx, Object instance) {
                            ((ValueHolder)instance).setConverter(this.getConverter(ctx, this.getAttr().getValueExpression(ctx, Converter.class)));
                        }
                    };
                }
            }
            return null;
        }
    };

    public AutocompleteHandler(ComponentConfig config) {
        super(config);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset metaRuleset = super.createMetaRuleset(type);
        metaRuleset.addRule(AUTOCOMPLETE_METHOD_META_RULE);
        return metaRuleset;
    }

    static abstract class ConverterMetadata
    extends Metadata {
        private final TagAttribute attr;

        public ConverterMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        public TagAttribute getAttr() {
            return this.attr;
        }

        public Converter getConverter(FaceletContext ctx, ValueExpression converter) {
            ValueExpression ve = null;
            Converter c = null;
            if (converter != null) {
                ve = converter;
                try {
                    c = (Converter)ve.getValue((ELContext)ctx);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (c == null) {
                c = this.createConverter(ctx);
            }
            if (c == null) {
                // empty if block
            }
            return c;
        }

        private String getConverterId(FaceletContext ctx) {
            return this.getAttr().getValue(ctx);
        }

        private Converter createConverter(FaceletContext ctx) {
            return ctx.getFacesContext().getApplication().createConverter(this.getConverterId(ctx));
        }
    }
}

