/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.component;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import org.jboss.seam.framework.Query;
import org.jboss.seam.ui.converter.ConverterChain;
import org.jboss.seam.ui.converter.NoSelectionConverter;
import org.jboss.seam.util.Strings;
import org.richfaces.cdk.annotations.Alias;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.Description;

public abstract class UISelectItems
extends javax.faces.component.UISelectItems {
    private List<SelectItem> selectItems;
    private Object originalValue;
    private static final String NO_SELECTION_VALUE = null;
    private String label;

    @Attribute(aliases={@Alias(value="itemLabel")}, description=@Description(value="the label to be used when rendering the SelectItem. Can reference the var variable"))
    public String getLabel() {
        Object object;
        ValueExpression ve = this.getValueExpression("label");
        if (ve != null && (object = ve.getValue(this.getFacesContext().getELContext())) != null) {
            return object.toString();
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public abstract void setHideNoSelectionLabel(Boolean var1);

    @Attribute(defaultValue="false", description=@Description(value="if true, the noSelectionLabel will be hidden when a value is selected"))
    public abstract Boolean isHideNoSelectionLabel();

    @Attribute(description=@Description(value="specifies the (optional) label to place at the top of list (if required=\"true\" is also specified then selecting this value will cause a validation error)"))
    public abstract String getNoSelectionLabel();

    public abstract void setNoSelectionLabel(String var1);

    @Attribute(description=@Description(value="defines the name of the local variable that holds the current object during iteration"))
    public abstract String getVar();

    public abstract void setVar(String var1);

    @Attribute(aliases={@Alias(value="itemDisabled")}, description=@Description(value="if true the SelectItem will be rendered disabled. Can reference the var variable"))
    public abstract Boolean isDisabled();

    public abstract void setDisabled(Boolean var1);

    @Attribute(defaultValue="true", description=@Description(value="if false, characters in the label will not be escaped. Beware that this is a safety issue when the label is in any way derived from input supplied by the application's user. . Can reference the var variable"))
    public abstract Boolean isEscape();

    public abstract void setEscape(Boolean var1);

    @Attribute(description=@Description(value="Value to return to the server if this option is selected. Optional, by default the var object is used. Can reference the var variable"))
    public abstract Object getItemValue();

    public abstract void setItemValue(Object var1);

    public void decode(FacesContext context) {
        super.decode(context);
        this.addConverterChainIfRequired();
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        this.addConverterChainIfRequired();
    }

    private void addConverterChainIfRequired() {
        NoSelectionConverter noSelectionConverter;
        ConverterChain converterChain;
        if (this.isShowNoSelectionLabel() && !(converterChain = new ConverterChain(this.getParent())).containsConverterType(noSelectionConverter = new NoSelectionConverter())) {
            converterChain.addConverterToChain(noSelectionConverter, 0);
        }
    }

    @Attribute(description=@Description(value="an EL expression specifying the data that backs the List&lt;SelectItem&gt;"))
    public Object getValue() {
        ArrayList<SelectItem> temporarySelectItems = new ArrayList<SelectItem>();
        SelectItem noSelectionLabel = this.noSelectionLabel();
        if (noSelectionLabel != null) {
            temporarySelectItems.add(noSelectionLabel);
        }
        if (this.selectItems == null || this.originalValue == null || !this.originalValue.equals(super.getValue())) {
            this.originalValue = super.getValue();
            this.selectItems = new ArrayList<SelectItem>();
            if (this.originalValue instanceof Iterable) {
                this.selectItems.addAll(this.asSelectItems((Iterable)this.originalValue));
            } else if (this.originalValue instanceof DataModel && ((DataModel)this.originalValue).getWrappedData() instanceof Iterable) {
                this.selectItems.addAll(this.asSelectItems((Iterable)((DataModel)this.originalValue).getWrappedData()));
            } else if (this.originalValue instanceof Query) {
                this.selectItems.addAll(this.asSelectItems(((Query)this.originalValue).getResultList()));
            } else if (this.originalValue != null && this.originalValue.getClass().isArray()) {
                this.selectItems.addAll(this.asSelectItems(UISelectItems.arrayAsList(this.originalValue)));
            } else if (temporarySelectItems.size() == 0) {
                return this.originalValue;
            }
        }
        temporarySelectItems.addAll(this.selectItems);
        return temporarySelectItems;
    }

    private List<SelectItem> asSelectItems(Iterable iterable) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (Object o : iterable) {
            selectItems.add(new ContextualSelectItem(o){

                @Override
                protected Boolean getSelectItemDisabled() {
                    Boolean disabled = UISelectItems.this.isDisabled();
                    return disabled == null ? false : disabled;
                }

                @Override
                protected Boolean getSelectItemEscape() {
                    Boolean escape = UISelectItems.this.isEscape();
                    return escape == null ? true : escape;
                }

                @Override
                protected String getSelectItemLabel() {
                    return Strings.emptyIfNull((String)UISelectItems.this.getLabel());
                }

                @Override
                protected Object getSelectItemValue() {
                    Object value = UISelectItems.this.getItemValue();
                    return value == null ? this.getVarValue() : value;
                }
            }.create());
        }
        return selectItems;
    }

    private SelectItem noSelectionLabel() {
        if (this.isShowNoSelectionLabel()) {
            NullableSelectItem s = new NullableSelectItem(NO_SELECTION_VALUE, this.getNoSelectionLabel());
            return s;
        }
        return null;
    }

    private boolean isShowNoSelectionLabel() {
        ValueExpression vb = this.getValueExpression("noSelectionLabel");
        String noSelectionLabel = this.getNoSelectionLabel();
        Boolean hideNoSelectionLabel = this.isHideNoSelectionLabel();
        Object parentValue = this.getParentValue();
        if (!(noSelectionLabel == null || vb != null || hideNoSelectionLabel.booleanValue() && parentValue != null)) {
            return true;
        }
        return noSelectionLabel != null && !"".equals(noSelectionLabel) && (hideNoSelectionLabel == false || parentValue == null);
    }

    private Object getParentValue() {
        if (this.getParent() instanceof ValueHolder) {
            ValueHolder parent = (ValueHolder)this.getParent();
            return parent.getValue();
        }
        return null;
    }

    private static List arrayAsList(Object array) {
        if (array.getClass().getComponentType().isPrimitive()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(array); ++i) {
                list.add(Array.get(array, i));
            }
            return list;
        }
        return Arrays.asList((Object[])array);
    }

    private abstract class ContextualSelectItem {
        private Object varValue;

        public ContextualSelectItem(Object varValue) {
            if (varValue == null) {
                throw new FacesException("var attribute must be set");
            }
            this.varValue = varValue;
        }

        protected Object getVarValue() {
            return this.varValue;
        }

        private void setup() {
            UISelectItems.this.getFacesContext().getExternalContext().getRequestMap().put(UISelectItems.this.getVar(), this.varValue);
        }

        private void cleanup() {
            UISelectItems.this.getFacesContext().getExternalContext().getRequestMap().remove(UISelectItems.this.getVar());
        }

        protected abstract Object getSelectItemValue();

        protected abstract String getSelectItemLabel();

        protected abstract Boolean getSelectItemDisabled();

        protected abstract Boolean getSelectItemEscape();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SelectItem create() {
            try {
                this.setup();
                SelectItem selectItem = new SelectItem(this.getSelectItemValue(), this.getSelectItemLabel(), "", this.getSelectItemDisabled().booleanValue(), this.getSelectItemEscape().booleanValue());
                return selectItem;
            }
            finally {
                this.cleanup();
            }
        }
    }

    private class NullableSelectItem
    extends SelectItem {
        private Object value;

        private NullableSelectItem(Object value, String label) {
            super.setLabel(label);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

