/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.io;

import java.io.File;
import java.net.URI;
import yarfraw.core.datamodel.FeedFormat;

abstract class AbstractBaseIO {
    protected File _file;
    protected FeedFormat _format = FeedFormat.RSS20;

    public AbstractBaseIO() {
    }

    public AbstractBaseIO(File file, FeedFormat format) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this._file = file;
        this.setFormat(format);
    }

    public AbstractBaseIO(String pathName, FeedFormat format) {
        this(new File(pathName), format);
    }

    public AbstractBaseIO(URI uri, FeedFormat format) {
        this(new File(uri), format);
    }

    public AbstractBaseIO(File file) {
        this(file, FeedFormat.RSS20);
    }

    public AbstractBaseIO(String pathName) {
        this(new File(pathName), FeedFormat.RSS20);
    }

    public AbstractBaseIO(URI uri) {
        this(new File(uri), FeedFormat.RSS20);
    }

    public File getFile() {
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public FeedFormat getFormat() {
        return this._format;
    }

    public void setFormat(FeedFormat format) {
        if (format != null) {
            this._format = format;
        }
    }
}

