/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.MAPIPropName;
import net.freeutils.tnef.MAPIValue;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFUtils;

public class ContactHandler {
    static ContactField[] contactFields = new ContactField[]{new ContactField("BEGIN", "VCARD"), new ContactField("VERSION", "3.0"), new ContactField("FN", new Integer[]{new Integer(14854), new Integer(14916), new Integer(14865), new Integer(14853)}, 1, "%s %s %s %s"), new ContactField("N", new Integer[]{new Integer(14865), new Integer(14854), new Integer(14916), new Integer(14917), new Integer(14853)}, 1, "%s;%s;%s;%s;%s"), new ContactField("NICKNAME", new Integer(14927)), new ContactField("BDAY", new Integer(14914), 0, "yyyy-MM-dd'T'HH:mm:ss'Z'"), new ContactField("ADR;TYPE=WORK", new Integer[]{null, new Integer(14873), new Integer(14889), new Integer(14887), new Integer(14888), new Integer(14890), new Integer(14886)}, 0, "%s;%s;%s;%s;%s;%s;%s"), new ContactField("LABEL;TYPE=WORK", new Integer[]{new Integer(14873), new Integer(14889), new Integer(14887), new Integer(14888), new Integer(14890), new Integer(14886)}, 0, "%s\r\n%s\r\n%s, %s %s\r\n%s"), new ContactField("ADR;TYPE=HOME", new Integer[]{null, null, new Integer(14941), new Integer(14937), new Integer(14940), new Integer(14939), new Integer(14938)}, 0, "%s;%s;%s;%s;%s;%s;%s"), new ContactField("LABEL;TYPE=HOME", new Integer[]{new Integer(14941), new Integer(14937), new Integer(14940), new Integer(14939), new Integer(14938)}, 0, "%s\r\n%s, %s %s\r\n%s"), new ContactField("ADR;TYPE=POSTAL", new Integer[]{null, null, new Integer(14947), new Integer(14943), new Integer(14946), new Integer(14945), new Integer(14944)}, 0, "%s;%s;%s;%s;%s;%s;%s"), new ContactField("LABEL;TYPE=POSTAL", new Integer[]{new Integer(14947), new Integer(14943), new Integer(14946), new Integer(14945), new Integer(14944)}, 0, "%s\r\n%s, %s %s\r\n%s"), new ContactField("TEL;TYPE=HOME,VOICE", new Integer(14857)), new ContactField("TEL;TYPE=HOME", new Integer(14895)), new ContactField("TEL;TYPE=HOME,FAX", new Integer(14885)), new ContactField("TEL;TYPE=WORK,VOICE", new Integer(14856)), new ContactField("TEL;TYPE=WORK,VOICE", new Integer(14875)), new ContactField("TEL;TYPE=WORK,FAX", new Integer(14884)), new ContactField("TEL;TYPE=CELL,VOICE", new Integer(14876)), new ContactField("TEL;TYPE=CAR,VOICE", new Integer(14878)), new ContactField("TEL;TYPE=PREF,VOICE", new Integer(14850)), new ContactField("TEL;TYPE=VOICE", new Integer(14879)), new ContactField("TEL;TYPE=PAGER,VOICE", new Integer(14881)), new ContactField("TEL;TYPE=ISDN", new Integer(14893)), new ContactField("TEL;TYPE=PREF", new Integer(14874)), new ContactField("EMAIL;TYPE=PREF,INTERNET", new MAPIPropName(MAPIProp.GUID_CDOPROPSETID3, 32899L)), new ContactField("EMAIL;TYPE=TLX", new Integer(14892)), new ContactField("TITLE", new Integer(14871)), new ContactField("ROLE", new Integer(14918)), new ContactField("ORG", new Integer[]{new Integer(14870), new Integer(14872)}, 0, "%s;%s"), new ContactField("NOTE", new Integer(32780), 2, null), new ContactField("URL;TYPE=WORK", new Integer(14929)), new ContactField("KEY;TYPE=X509", new Integer(14960), 12, null), new ContactField("END", "VCARD")};

    public static Multipart convert(Message message) throws IOException, MessagingException {
        StringBuffer vcard = new StringBuffer();
        for (int i = 0; i < contactFields.length; ++i) {
            String v = contactFields[i].getValue(message);
            if (v == null) continue;
            vcard.append(v);
        }
        String name = (String)message.getAttribute(32772).getValue() + ".vcf";
        name = MimeUtility.encodeWord((String)name, (String)"UTF-8", null);
        MimeBodyPart part = new MimeBodyPart();
        part.setText(vcard.toString(), "UTF-8");
        part.setHeader("Content-Type", "text/x-vcard; charset=UTF-8; name=\"" + name + '\"');
        part.setHeader("Content-Disposition", "attachment; filename=\"" + name + '\"');
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)part);
        return mp;
    }

    static class ContactField {
        public static final int NONE = 0;
        public static final int MUST = 1;
        public static final int ATTR = 2;
        public static final int BINARY = 4;
        public static final int CERT = 8;
        String type;
        Object src;
        int flags;
        String format;

        public ContactField(String type, Object src, int flags, String format) {
            this.type = type;
            this.src = src;
            this.flags = flags;
            this.format = format;
            if (this.isFlag(4)) {
                this.type = this.type + ";ENCODING=b";
            }
        }

        public ContactField(String type, Object src) {
            this(type, src, 0, null);
        }

        public String getValue(Message message) throws IOException {
            String v = null;
            if (this.src instanceof Integer) {
                int id = (Integer)this.src;
                if (this.isFlag(2)) {
                    Attr attr = message.getAttribute(id);
                    if (attr != null) {
                        v = this.toVCardField(this.toString(attr.getValue()), true);
                    }
                } else {
                    v = this.toVCardFields(message.getMAPIProps().getProp(id));
                }
            } else if (this.src instanceof MAPIPropName) {
                MAPIPropName propname = (MAPIPropName)this.src;
                v = this.toVCardFields(message.getMAPIProps().getProp(propname));
            } else if (this.src instanceof Integer[]) {
                Integer[] ids = (Integer[])this.src;
                int len = ids.length;
                String[] vals = new String[len];
                boolean hasValue = false;
                for (int i = 0; i < len; ++i) {
                    Integer id = ids[i];
                    String string = vals[i] = id == null ? null : this.escape((String)message.getMAPIProps().getPropValue(id));
                    if (vals[i] == null) continue;
                    hasValue = true;
                }
                if (hasValue) {
                    v = this.toVCardField(this.format(vals), false);
                }
            } else if (this.src instanceof String) {
                v = this.toVCardField((String)this.src, true);
            } else {
                throw new IllegalArgumentException("Invalid source: " + this.src);
            }
            return v;
        }

        private String toVCardFields(MAPIProp prop) throws IOException {
            MAPIValue[] vals;
            String v = null;
            if (prop != null && (vals = prop.getValues()) != null) {
                v = "";
                for (int i = 0; i < vals.length; ++i) {
                    if (vals[i] == null) continue;
                    v = v + this.toVCardField(this.toString(vals[i].getValue()), true);
                }
            }
            return v;
        }

        String toVCardField(String v, boolean escape) {
            if (escape) {
                v = this.escape(v);
            }
            if (v != null && v.trim().length() == 0) {
                v = null;
            }
            if (this.isFlag(1) && v == null) {
                v = "";
            }
            if (v != null) {
                v = TNEFUtils.replace(v, "\r\n", "\\n");
                v = TNEFUtils.replace(v, "\n", "\\n");
                v = this.fold(this.type + ":" + v) + "\r\n";
            }
            return v;
        }

        boolean isFlag(int flag) {
            return (this.flags & flag) != 0;
        }

        String toString(Object val) throws IOException {
            String v = null;
            if (val != null) {
                if (val instanceof Date) {
                    SimpleDateFormat df = new SimpleDateFormat(this.format);
                    df.setTimeZone(TimeZone.getTimeZone("GMT"));
                    v = df.format((Date)val);
                } else if (val instanceof RawInputStream) {
                    RawInputStream ris = (RawInputStream)val;
                    if (this.isFlag(8) && (ris = this.getTLVProp(ris, 3)) != null && ris.available() <= 32) {
                        ris = null;
                    }
                    if (ris != null) {
                        try {
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            OutputStream out = MimeUtility.encode((OutputStream)bout, (String)"base64");
                            out.write(ris.toByteArray());
                            out.flush();
                            v = bout.toString("US-ASCII");
                            v = TNEFUtils.replace(v, "\r\n", "");
                        }
                        catch (MessagingException ignore) {}
                    }
                } else {
                    v = val.toString();
                }
            }
            return v;
        }

        String fold(String v) {
            int vlen = v.length();
            if (vlen > 75) {
                StringBuffer folded = new StringBuffer(vlen * 1);
                int breakpos = -1;
                int count = 0;
                for (int i = 0; i < vlen; ++i) {
                    char ch = v.charAt(i);
                    if (Character.isWhitespace(ch) || ch == '\\') {
                        breakpos = i;
                    }
                    if (count == 74) {
                        if (breakpos == -1) {
                            breakpos = i;
                        }
                        folded.append(v.substring(i - count, breakpos)).append("\r\n ");
                        count = i - breakpos;
                        breakpos = -1;
                    }
                    ++count;
                }
                if (count > 0) {
                    folded.append(v.substring(vlen - count));
                }
                v = folded.toString();
            }
            return v;
        }

        String format(String[] vals) {
            StringBuffer sb = new StringBuffer();
            int len = this.format.length();
            int ind = 0;
            for (int i = 0; i < len; ++i) {
                char c = this.format.charAt(i);
                if (c == '%') {
                    if (++i >= len) {
                        throw new IllegalArgumentException("format error at position " + i + ": " + this.format);
                    }
                    c = this.format.charAt(i);
                    if (c == 's') {
                        if (ind >= vals.length) {
                            throw new IllegalArgumentException("format error (too few parameters): " + this.format);
                        }
                        if (vals[ind] != null) {
                            sb.append(vals[ind]);
                        }
                        ++ind;
                        continue;
                    }
                    if (c == '%') {
                        sb.append('%');
                        continue;
                    }
                    throw new IllegalArgumentException("format error at position " + i + ": " + this.format);
                }
                sb.append(c);
            }
            return sb.toString();
        }

        String escape(String v) {
            if (v == null) {
                return null;
            }
            v = TNEFUtils.replace(v, "\r\n", "\\n");
            v = TNEFUtils.replace(v, "\n", "\\n");
            v = TNEFUtils.replace(v, ",", "\\,");
            v = TNEFUtils.replace(v, ";", "\\;");
            return v;
        }

        RawInputStream getTLVProp(RawInputStream in, int tag) throws IOException {
            in = new RawInputStream(in);
            while (in.available() >= 4) {
                int tg = in.readU16();
                int len = in.readU16() - 4;
                if (tg == tag) {
                    return (RawInputStream)in.newStream(0L, len);
                }
                in.skip(len);
            }
            return null;
        }
    }
}

