/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.freeutils.tnef.TNEFUtils;

public class RawInputStream
extends InputStream {
    InputStream in;
    byte[] buf;
    File file;
    long offset;
    long length;
    long position;
    long mark;

    void init(InputStream in, long offset, long length) throws IOException {
        if (in instanceof FileInputStream && length > 16L) {
            in = new BufferedInputStream(in, length < 4096L ? (int)length : 4096);
        }
        this.in = in;
        this.length = offset;
        if (this.skip(offset) != offset) {
            throw new IOException("can't skip to offset " + offset + " in stream");
        }
        this.length = length;
        this.offset = offset;
        this.position = offset;
        this.mark = offset;
    }

    public RawInputStream(byte[] buf, long offset, long length) throws IOException {
        this.buf = buf;
        this.init(new ByteArrayInputStream(buf), offset, length);
    }

    public RawInputStream(byte[] buf) throws IOException {
        this(buf, 0L, (long)buf.length);
    }

    public RawInputStream(String filename, long offset, long length) throws IOException {
        this(new File(filename), offset, length);
    }

    public RawInputStream(String filename) throws IOException {
        this(new File(filename));
    }

    public RawInputStream(File file) throws IOException {
        this(file, 0L, file.length());
    }

    public RawInputStream(File file, long offset, long length) throws IOException {
        this.file = file;
        this.init(new FileInputStream(this.file), offset, length);
    }

    public RawInputStream(RawInputStream ris) throws IOException {
        this(ris, 0L, (long)ris.available());
    }

    public RawInputStream(RawInputStream ris, long offset, long length) throws IOException {
        this.file = ris.file;
        this.buf = ris.buf;
        InputStream in = this.file != null ? new FileInputStream(this.file) : new ByteArrayInputStream(this.buf);
        this.init(in, ris.position + offset, length);
    }

    public long getLength() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() throws IOException {
        int len = this.available();
        byte[] buf = new byte[len];
        if (len > 0) {
            RawInputStream ris = new RawInputStream(this);
            try {
                ris.readFully(buf);
            }
            finally {
                ris.close();
            }
        }
        return buf;
    }

    public int read() throws IOException {
        if (this.length - (this.position - this.offset) > 0L) {
            ++this.position;
            return this.in.read();
        }
        return -1;
    }

    public long skip(long n) throws IOException {
        long total;
        long skipped;
        if (n <= 0L) {
            return 0L;
        }
        if (n > (long)this.available()) {
            n = this.available();
        }
        for (total = 0L; total < n; total += skipped) {
            skipped = this.in.skip(n - total);
            if (skipped == 0L) {
                return 0L;
            }
            this.position += skipped;
        }
        return total;
    }

    public int available() throws IOException {
        return (int)(this.length - (this.position - this.offset));
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.position;
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.position = this.mark;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public long getPosition() {
        return this.position;
    }

    public InputStream newStream(long start, long end) {
        RawInputStream newStream;
        if (start < 0L) {
            throw new IllegalArgumentException("start < 0");
        }
        if (end == -1L) {
            end = this.length;
        }
        try {
            newStream = new RawInputStream(this, start, end - start);
        }
        catch (IOException ioe) {
            newStream = null;
        }
        return newStream;
    }

    void readFully(byte[] b, int offset, int length) throws IOException {
        int read;
        for (int total = 0; total < length; total += read) {
            read = this.read(b, offset + total, length - total);
            if (read >= 0) continue;
            throw new IOException("Unexpected end of stream");
        }
    }

    void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public int readU8() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new IOException("Unexpected end of stream");
        }
        return b;
    }

    public int readU16() throws IOException {
        return (this.readU8() | this.readU8() << 8) & 0xFFFF;
    }

    public long readU32() throws IOException {
        return (long)(this.readU8() | this.readU8() << 8 | this.readU8() << 16 | this.readU8() << 24) & 0xFFFFFFFFL;
    }

    public long readU64() throws IOException {
        return this.readU32() & 0xFFFFFFFFL | (this.readU32() & 0xFFFFFFFFL) << 32;
    }

    public byte[] readBytes(int length) throws IOException {
        byte[] b = new byte[length];
        this.readFully(b, 0, length);
        return b;
    }

    public String readString(int length) throws IOException {
        return TNEFUtils.createString(this.readBytes(length), 0, length);
    }

    public String readStringUnicode(int length) throws IOException {
        return TNEFUtils.createStringUnicode(this.readBytes(length), 0, length);
    }

    public String toString() {
        byte[] buf = null;
        try {
            buf = this.toByteArray();
        }
        catch (IOException ioe) {
            return "RawInputStream can't get bytes: " + ioe;
        }
        return TNEFUtils.toHexString(buf, 512);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

