/*
 * Decompiled with CFR 0.152.
 */
package fj.test;

import fj.Bottom;
import fj.F;
import fj.Show;
import fj.data.List;
import fj.data.Option;
import fj.test.Arg;
import java.io.PrintWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CheckResult {
    private final R r;
    private final Option<List<Arg<?>>> args;
    private final Option<Throwable> ex;
    private final int succeeded;
    private final int discarded;
    public static final Show<CheckResult> summary = CheckResult.summary(Arg.argShow);
    public static final Show<CheckResult> summaryEx = CheckResult.summaryEx(Arg.argShow);

    private CheckResult(R r, Option<List<Arg<?>>> option, Option<Throwable> option2, int n, int n2) {
        this.r = r;
        this.args = option;
        this.ex = option2;
        this.succeeded = n;
        this.discarded = n2;
    }

    public static CheckResult passed(int n, int n2) {
        return new CheckResult(R.Passed, Option.<List<Arg<?>>>none(), Option.<Throwable>none(), n, n2);
    }

    public static CheckResult proven(List<Arg<?>> list, int n, int n2) {
        return new CheckResult(R.Proven, Option.some(list), Option.<Throwable>none(), n, n2);
    }

    public static CheckResult falsified(List<Arg<?>> list, int n, int n2) {
        return new CheckResult(R.Falsified, Option.some(list), Option.<Throwable>none(), n, n2);
    }

    public static CheckResult exhausted(int n, int n2) {
        return new CheckResult(R.Exhausted, Option.<List<Arg<?>>>none(), Option.<Throwable>none(), n, n2);
    }

    public static CheckResult propException(List<Arg<?>> list, Throwable throwable, int n, int n2) {
        return new CheckResult(R.PropException, Option.some(list), Option.some(throwable), n, n2);
    }

    public static CheckResult genException(Throwable throwable, int n, int n2) {
        return new CheckResult(R.GenException, Option.<List<Arg<?>>>none(), Option.some(throwable), n, n2);
    }

    public boolean isPassed() {
        return this.r == R.Passed;
    }

    public boolean isProven() {
        return this.r == R.Proven;
    }

    public boolean isFalsified() {
        return this.r == R.Falsified;
    }

    public boolean isExhausted() {
        return this.r == R.Exhausted;
    }

    public boolean isPropException() {
        return this.r == R.PropException;
    }

    public boolean isGenException() {
        return this.r == R.GenException;
    }

    public Option<List<Arg<?>>> args() {
        return this.args;
    }

    public Option<Throwable> exception() {
        return this.ex;
    }

    public int succeeded() {
        return this.succeeded;
    }

    public int discarded() {
        return this.discarded;
    }

    public static Show<CheckResult> summary(final Show<Arg<?>> show) {
        return Show.showS(new F<CheckResult, String>(){

            private String test(CheckResult checkResult) {
                return checkResult.succeeded() == 1 ? "test" : "tests";
            }

            private String arguments(CheckResult checkResult) {
                List<Arg<?>> list = checkResult.args().some();
                return list.length() == 1 ? "argument: " + show.showS(list.head()) : "arguments: " + Show.listShow(show).showS(list);
            }

            @Override
            public String f(CheckResult checkResult) {
                if (checkResult.isProven()) {
                    return "OK, property proven with " + this.arguments(checkResult);
                }
                if (checkResult.isPassed()) {
                    return "OK, passed " + checkResult.succeeded() + ' ' + this.test(checkResult) + (checkResult.discarded() > 0 ? " (" + checkResult.discarded() + " discarded)" : "") + '.';
                }
                if (checkResult.isFalsified()) {
                    return "Falsified after " + checkResult.succeeded() + " passed " + this.test(checkResult) + " with " + this.arguments(checkResult);
                }
                if (checkResult.isExhausted()) {
                    return "Gave up after " + checkResult.succeeded() + " passed " + this.test(checkResult) + " and " + checkResult.discarded() + " discarded tests.";
                }
                if (checkResult.isPropException()) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    checkResult.exception().some().printStackTrace(printWriter);
                    return "Exception on property evaluation with " + this.arguments(checkResult) + System.getProperty("line.separator") + stringWriter;
                }
                if (checkResult.isGenException()) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    checkResult.exception().some().printStackTrace(printWriter);
                    return "Exception on argument generation " + System.getProperty("line.separator") + stringWriter;
                }
                throw Bottom.decons(checkResult.getClass());
            }
        });
    }

    public static Show<CheckResult> summaryEx(final Show<Arg<?>> show) {
        return Show.showS(new F<CheckResult, String>(){

            @Override
            public String f(CheckResult checkResult) {
                String string = CheckResult.summary(show).show(checkResult).toString();
                if (checkResult.isProven() || checkResult.isPassed() || checkResult.isExhausted()) {
                    return string;
                }
                if (checkResult.isFalsified() || checkResult.isPropException() || checkResult.isGenException()) {
                    throw new Error(string);
                }
                throw Bottom.decons(checkResult.getClass());
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum R {
        Passed,
        Proven,
        Falsified,
        Exhausted,
        PropException,
        GenException;

    }
}

