/*
 * Decompiled with CFR 0.152.
 */
package fj.function;

import fj.F;
import fj.F2;
import fj.F3;
import fj.Function;
import fj.Monoid;
import fj.Semigroup;
import fj.data.List;
import fj.data.Stream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Booleans {
    public static final F<Boolean, F<Boolean, Boolean>> or = Semigroup.disjunctionSemigroup.sum();
    public static final F<Boolean, F<Boolean, Boolean>> and = Semigroup.conjunctionSemigroup.sum();
    public static final F<Boolean, F<Boolean, Boolean>> xor = Semigroup.exclusiveDisjunctionSemiGroup.sum();
    public static final F<Boolean, Boolean> not = new F<Boolean, Boolean>(){

        @Override
        public Boolean f(Boolean bl) {
            return bl == false;
        }
    };
    public static final F<Boolean, F<Boolean, Boolean>> implies = Function.curry(new F2<Boolean, Boolean, Boolean>(){

        @Override
        public Boolean f(Boolean bl, Boolean bl2) {
            return bl == false || bl2 != false;
        }
    });
    public static final F<Boolean, F<Boolean, Boolean>> if_ = Function.flip(implies);
    public static final F<Boolean, F<Boolean, Boolean>> iff = Function.compose2(not, xor);
    public static final F<Boolean, F<Boolean, Boolean>> nimp = Function.compose2(not, implies);
    public static final F<Boolean, F<Boolean, Boolean>> nif = Function.compose2(not, if_);
    public static final F<Boolean, F<Boolean, Boolean>> nor = Function.compose2(not, or);

    private Booleans() {
        throw new UnsupportedOperationException();
    }

    public static boolean and(List<Boolean> list) {
        return Monoid.conjunctionMonoid.sumLeft(list);
    }

    public static boolean and(Stream<Boolean> stream) {
        return Monoid.conjunctionMonoid.sumLeft(stream);
    }

    public static boolean or(List<Boolean> list) {
        return Monoid.disjunctionMonoid.sumLeft(list);
    }

    public static boolean or(Stream<Boolean> stream) {
        return Monoid.disjunctionMonoid.sumLeft(stream);
    }

    public static <A> F<A, Boolean> not(F<A, Boolean> f) {
        return Function.compose(not, f);
    }

    public static <A> F<Boolean, F<A, F<A, A>>> cond() {
        return Function.curry(new F3<Boolean, A, A, A>(){

            @Override
            public A f(Boolean bl, A a, A a2) {
                return bl != false ? a : a2;
            }
        });
    }
}

