/*
 * Decompiled with CFR 0.152.
 */
package fj.data.fingertrees;

import fj.F;
import fj.Monoid;
import fj.data.fingertrees.Digit;
import fj.data.fingertrees.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Measured<V, A> {
    private final Monoid<V> m;
    private final F<A, V> measure;

    private Measured(Monoid<V> monoid, F<A, V> f) {
        this.m = monoid;
        this.measure = f;
    }

    public static <V, A> Measured<V, A> measured(Monoid<V> monoid, F<A, V> f) {
        return new Measured<V, A>(monoid, f);
    }

    public Monoid<V> monoid() {
        return this.m;
    }

    public F<A, V> measure() {
        return this.measure;
    }

    public V measure(A a) {
        return this.measure.f(a);
    }

    public V sum(V v, V v2) {
        return this.m.sum(v, v2);
    }

    public V zero() {
        return this.m.zero();
    }

    public Measured<V, Node<V, A>> nodeMeasured() {
        return new Measured<V, A>(this.m, new F<Node<V, A>, V>(){

            @Override
            public V f(Node<V, A> node) {
                return node.measure();
            }
        });
    }

    public Measured<V, Digit<V, A>> digitMeasured() {
        return new Measured<V, A>(this.m, new F<Digit<V, A>, V>(){

            @Override
            public V f(Digit<V, A> digit) {
                return digit.measure();
            }
        });
    }
}

