/*
 * Decompiled with CFR 0.152.
 */
package fj.data.fingertrees;

import fj.F;
import fj.F2;
import fj.Function;
import fj.data.fingertrees.Empty;
import fj.data.fingertrees.FingerTree;
import fj.data.fingertrees.Four;
import fj.data.fingertrees.MakeTree;
import fj.data.fingertrees.Measured;
import fj.data.fingertrees.One;
import fj.data.fingertrees.Three;
import fj.data.fingertrees.Two;
import fj.data.vector.V2;
import fj.data.vector.V3;
import fj.data.vector.V4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Digit<V, A> {
    private final Measured<V, A> m;

    public abstract <B> B foldRight(F<A, F<B, B>> var1, B var2);

    public abstract <B> B foldLeft(F<B, F<A, B>> var1, B var2);

    public final A reduceRight(final F<A, F<A, A>> f) {
        return (A)this.match(new F<One<V, A>, A>(){

            @Override
            public A f(One<V, A> one) {
                return one.value();
            }
        }, new F<Two<V, A>, A>(){

            @Override
            public A f(Two<V, A> two) {
                V2 v2 = two.values();
                return ((F)f.f(v2._1())).f(v2._2());
            }
        }, new F<Three<V, A>, A>(){

            @Override
            public A f(Three<V, A> three) {
                V3 v3 = three.values();
                return ((F)f.f(v3._1())).f(((F)f.f(v3._2())).f(v3._3()));
            }
        }, new F<Four<V, A>, A>(){

            @Override
            public A f(Four<V, A> four) {
                V4 v4 = four.values();
                return ((F)f.f(v4._1())).f(((F)f.f(v4._2())).f(((F)f.f(v4._3())).f(v4._4())));
            }
        });
    }

    public final A reduceLeft(final F<A, F<A, A>> f) {
        return (A)this.match(new F<One<V, A>, A>(){

            @Override
            public A f(One<V, A> one) {
                return one.value();
            }
        }, new F<Two<V, A>, A>(){

            @Override
            public A f(Two<V, A> two) {
                V2 v2 = two.values();
                return ((F)f.f(v2._1())).f(v2._2());
            }
        }, new F<Three<V, A>, A>(){

            @Override
            public A f(Three<V, A> three) {
                V3 v3 = three.values();
                return ((F)f.f(((F)f.f(v3._1())).f(v3._2()))).f(v3._3());
            }
        }, new F<Four<V, A>, A>(){

            @Override
            public A f(Four<V, A> four) {
                V4 v4 = four.values();
                return ((F)f.f(((F)f.f(((F)f.f(v4._1())).f(v4._2()))).f(v4._3()))).f(v4._4());
            }
        });
    }

    public final <B> Digit<V, B> map(final F<A, B> f, final Measured<V, B> measured) {
        return (Digit)this.match(new F<One<V, A>, Digit<V, B>>(){

            @Override
            public Digit<V, B> f(One<V, A> one) {
                return new One(measured, f.f(one.value()));
            }
        }, new F<Two<V, A>, Digit<V, B>>(){

            @Override
            public Digit<V, B> f(Two<V, A> two) {
                return new Two(measured, two.values().map(f));
            }
        }, new F<Three<V, A>, Digit<V, B>>(){

            @Override
            public Digit<V, B> f(Three<V, A> three) {
                return new Three(measured, three.values().map(f));
            }
        }, new F<Four<V, A>, Digit<V, B>>(){

            @Override
            public Digit<V, B> f(Four<V, A> four) {
                return new Four(measured, four.values().map(f));
            }
        });
    }

    public abstract <B> B match(F<One<V, A>, B> var1, F<Two<V, A>, B> var2, F<Three<V, A>, B> var3, F<Four<V, A>, B> var4);

    Digit(Measured<V, A> measured) {
        this.m = measured;
    }

    public final V measure() {
        return (V)this.foldLeft(Function.curry(new F2<V, A, V>(){

            @Override
            public V f(V v, A a) {
                return Digit.this.m.sum(v, Digit.this.m.measure(a));
            }
        }), this.m.zero());
    }

    public final FingerTree<V, A> toTree() {
        final MakeTree<V, A> makeTree = FingerTree.mkTree(this.m);
        return (FingerTree)this.match(new F<One<V, A>, FingerTree<V, A>>(){

            @Override
            public FingerTree<V, A> f(One<V, A> one) {
                return makeTree.single(one.value());
            }
        }, new F<Two<V, A>, FingerTree<V, A>>(){

            @Override
            public FingerTree<V, A> f(Two<V, A> two) {
                return makeTree.deep(makeTree.one(two.values()._1()), new Empty(Digit.this.m.nodeMeasured()), makeTree.one(two.values()._2()));
            }
        }, new F<Three<V, A>, FingerTree<V, A>>(){

            @Override
            public FingerTree<V, A> f(Three<V, A> three) {
                return makeTree.deep(makeTree.two(three.values()._1(), three.values()._2()), new Empty(Digit.this.m.nodeMeasured()), makeTree.one(three.values()._3()));
            }
        }, new F<Four<V, A>, FingerTree<V, A>>(){

            @Override
            public FingerTree<V, A> f(Four<V, A> four) {
                return makeTree.deep(makeTree.two(four.values()._1(), four.values()._2()), new Empty(Digit.this.m.nodeMeasured()), makeTree.two(four.values()._3(), four.values()._4()));
            }
        });
    }
}

