/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Function;
import fj.Monoid;
import fj.data.fingertrees.FingerTree;
import fj.data.fingertrees.MakeTree;
import fj.data.fingertrees.Measured;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Seq<A> {
    private final FingerTree<Integer, A> ftree;

    private static <A> MakeTree<Integer, A> mkTree() {
        return FingerTree.mkTree(Seq.<A>elemMeasured());
    }

    private Seq(FingerTree<Integer, A> fingerTree) {
        this.ftree = fingerTree;
    }

    private static <A> Measured<Integer, A> elemMeasured() {
        return FingerTree.measured(Monoid.intAdditionMonoid, Function.constant(1));
    }

    public static <A> Seq<A> empty() {
        return new Seq<A>(Seq.mkTree().empty());
    }

    public static <A> Seq<A> single(A a) {
        return new Seq<A>(Seq.mkTree().single(a));
    }

    public Seq<A> cons(A a) {
        return new Seq<A>(this.ftree.cons(a));
    }

    public Seq<A> snoc(A a) {
        return new Seq<A>(this.ftree.snoc(a));
    }

    public Seq<A> append(Seq<A> seq) {
        return new Seq<A>(this.ftree.append(seq.ftree));
    }

    public boolean isEmpty() {
        return this.ftree.isEmpty();
    }

    public int length() {
        return this.ftree.measure();
    }

    public A index(int n) {
        if (n < 0 || n >= this.length()) {
            throw Bottom.error("Index " + n + "out of bounds.");
        }
        return this.ftree.lookup(Function.identity(), n)._2();
    }
}

