/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Effect;
import fj.F;
import fj.data.Conversions;
import fj.data.List;
import fj.data.Option;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonEmptyList<A>
implements Iterable<A> {
    public final A head;
    public final List<A> tail;

    @Override
    public Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    private NonEmptyList(A a, List<A> list) {
        this.head = a;
        this.tail = list;
    }

    public NonEmptyList<A> cons(A a) {
        return NonEmptyList.nel(a, this.tail.cons(this.head));
    }

    public NonEmptyList<A> append(NonEmptyList<A> nonEmptyList) {
        List.Buffer<A> buffer = new List.Buffer<A>();
        buffer.append(this.tail);
        buffer.snoc(nonEmptyList.head);
        buffer.append(nonEmptyList.tail);
        List list = buffer.toList();
        return NonEmptyList.nel(this.head, list);
    }

    public <B> NonEmptyList<B> map(F<A, B> f) {
        return NonEmptyList.nel(f.f(this.head), this.tail.map(f));
    }

    public <B> NonEmptyList<B> bind(final F<A, NonEmptyList<B>> f) {
        final List.Buffer<A> buffer = new List.Buffer<A>();
        NonEmptyList<B> nonEmptyList = f.f(this.head);
        buffer.snoc(nonEmptyList.head);
        buffer.append(nonEmptyList.tail);
        this.tail.foreach(new Effect<A>(){

            @Override
            public void e(A a) {
                NonEmptyList nonEmptyList = (NonEmptyList)f.f(a);
                buffer.snoc(nonEmptyList.head);
                buffer.append(nonEmptyList.tail);
            }
        });
        List list = buffer.toList();
        return NonEmptyList.nel(list.head(), list.tail());
    }

    public NonEmptyList<NonEmptyList<A>> sublists() {
        return NonEmptyList.fromList(Option.somes(this.toList().toStream().substreams().map(new F<List<A>, Option<NonEmptyList<A>>>(){

            @Override
            public Option<NonEmptyList<A>> f(List<A> list) {
                return NonEmptyList.fromList(list);
            }
        }.o(Conversions.Stream_List())).toList())).some();
    }

    public NonEmptyList<NonEmptyList<A>> tails() {
        return NonEmptyList.fromList(Option.somes(this.toList().tails().map(new F<List<A>, Option<NonEmptyList<A>>>(){

            @Override
            public Option<NonEmptyList<A>> f(List<A> list) {
                return NonEmptyList.fromList(list);
            }
        }))).some();
    }

    public <B> NonEmptyList<B> mapTails(F<NonEmptyList<A>, B> f) {
        return this.tails().map(f);
    }

    public List<A> toList() {
        return this.tail.cons(this.head);
    }

    public Collection<A> toCollection() {
        return this.toList().toCollection();
    }

    public static <A> F<NonEmptyList<A>, List<A>> toList_() {
        return new F<NonEmptyList<A>, List<A>>(){

            @Override
            public List<A> f(NonEmptyList<A> nonEmptyList) {
                return nonEmptyList.toList();
            }
        };
    }

    public static <A> NonEmptyList<A> nel(A a, List<A> list) {
        return new NonEmptyList<A>(a, list);
    }

    public static <A> NonEmptyList<A> nel(A a) {
        return NonEmptyList.nel(a, List.nil());
    }

    public static <A> F<A, NonEmptyList<A>> nel() {
        return new F<A, NonEmptyList<A>>(){

            @Override
            public NonEmptyList<A> f(A a) {
                return NonEmptyList.nel(a);
            }
        };
    }

    public static <A> Option<NonEmptyList<A>> fromList(List<A> list) {
        return list.isEmpty() ? Option.none() : Option.some(NonEmptyList.nel(list.head(), list.tail()));
    }
}

