/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Equal;
import fj.F;
import fj.F2;
import fj.Function;
import fj.P;
import fj.P1;
import fj.P2;
import fj.data.Option;
import fj.data.Stream;
import fj.function.Booleans;
import fj.function.Characters;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyString
implements CharSequence {
    private final Stream<Character> s;
    public static final LazyString empty = LazyString.str("");
    public static final F<LazyString, Stream<Character>> toStream = new F<LazyString, Stream<Character>>(){

        @Override
        public Stream<Character> f(LazyString lazyString) {
            return lazyString.toStream();
        }
    };
    public static final F<Stream<Character>, LazyString> fromStream = new F<Stream<Character>, LazyString>(){

        @Override
        public LazyString f(Stream<Character> stream) {
            return LazyString.fromStream(stream);
        }
    };
    private static final Equal<Stream<Character>> eqS = Equal.streamEqual(Equal.charEqual);

    private LazyString(Stream<Character> stream) {
        this.s = stream;
    }

    public static LazyString str(String string) {
        return new LazyString(Stream.unfold(new F<P2<String, Integer>, Option<P2<Character, P2<String, Integer>>>>(){

            @Override
            public Option<P2<Character, P2<String, Integer>>> f(P2<String, Integer> p2) {
                String string = p2._1();
                int n = p2._2();
                Option<P2<Character, P2<String, Integer>>> option = Option.none();
                return string.length() <= n ? option : Option.some(P.p(Character.valueOf(string.charAt(n)), P.p(string, n + 1)));
            }
        }, P.p(string, 0)));
    }

    public static LazyString fromStream(Stream<Character> stream) {
        return new LazyString(stream);
    }

    public Stream<Character> toStream() {
        return this.s;
    }

    @Override
    public int length() {
        return this.s.length();
    }

    @Override
    public char charAt(int n) {
        return this.s.index(n).charValue();
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return LazyString.fromStream(this.s.drop(n).take(n2 - n));
    }

    @Override
    public String toString() {
        return new StringBuilder(this).toString();
    }

    public LazyString append(LazyString lazyString) {
        return LazyString.fromStream(this.s.append(lazyString.s));
    }

    public LazyString append(String string) {
        return this.append(LazyString.str(string));
    }

    public boolean contains(LazyString lazyString) {
        return Booleans.or(this.s.tails().map(Function.compose(LazyString.startsWith().f(lazyString), fromStream)));
    }

    public boolean endsWith(LazyString lazyString) {
        return this.reverse().startsWith(lazyString.reverse());
    }

    public boolean startsWith(LazyString lazyString) {
        return lazyString.isEmpty() || !this.isEmpty() && Equal.charEqual.eq(Character.valueOf(this.head()), Character.valueOf(lazyString.head())) && this.tail().startsWith(lazyString.tail());
    }

    public static F<LazyString, F<LazyString, Boolean>> startsWith() {
        return Function.curry(new F2<LazyString, LazyString, Boolean>(){

            @Override
            public Boolean f(LazyString lazyString, LazyString lazyString2) {
                return lazyString2.startsWith(lazyString);
            }
        });
    }

    public char head() {
        return this.s.head().charValue();
    }

    public LazyString tail() {
        return LazyString.fromStream(this.s.tail()._1());
    }

    @Override
    public boolean isEmpty() {
        return this.s.isEmpty();
    }

    public LazyString reverse() {
        return LazyString.fromStream(this.s.reverse());
    }

    public Option<Integer> indexOf(char c) {
        return this.s.indexOf(Equal.charEqual.eq(Character.valueOf(c)));
    }

    public Option<Integer> indexOf(LazyString lazyString) {
        return this.s.substreams().indexOf(eqS.eq(lazyString.s));
    }

    public boolean matches(String string) {
        return Pattern.matches(string, this);
    }

    public Stream<LazyString> split(final F<Character, Boolean> f) {
        Stream<Character> stream = this.s.dropWhile(f);
        final P2<Stream<Character>, Stream<Character>> p2 = stream.split(f);
        return stream.isEmpty() ? Stream.nil() : Stream.cons(LazyString.fromStream(p2._1()), new P1<Stream<LazyString>>(){

            @Override
            public Stream<LazyString> _1() {
                return LazyString.fromStream((Stream)p2._2()).split(f);
            }
        });
    }

    public Stream<LazyString> split(char c) {
        return this.split(Equal.charEqual.eq(Character.valueOf(c)));
    }

    public Stream<LazyString> words() {
        return this.split(Characters.isSpaceChar);
    }

    public Stream<LazyString> lines() {
        return this.split('\n');
    }

    public static LazyString unlines(Stream<LazyString> stream) {
        return LazyString.fromStream(Stream.join(stream.intersperse(LazyString.str("\n")).map(toStream)));
    }

    public static LazyString unwords(Stream<LazyString> stream) {
        return LazyString.fromStream(Stream.join(stream.intersperse(LazyString.str(" ")).map(toStream)));
    }
}

