/*
 * Decompiled with CFR 0.152.
 */
package fj.control.parallel;

import fj.Effect;
import fj.F;
import fj.F2;
import fj.Function;
import fj.P;
import fj.P1;
import fj.control.parallel.Callables;
import fj.data.Array;
import fj.data.Java;
import fj.data.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Strategy<A> {
    private final F<P1<A>, P1<A>> f;

    private Strategy(F<P1<A>, P1<A>> f) {
        this.f = f;
    }

    public F<P1<A>, P1<A>> f() {
        return this.f;
    }

    public static <A> Strategy<A> strategy(F<P1<A>, P1<A>> f) {
        return new Strategy<A>(f);
    }

    public P1<A> par(P1<A> p1) {
        return this.f().f(p1);
    }

    public <B> F<B, P1<A>> concurry(F<B, A> f) {
        return Function.compose(this.f(), P1.curry(f));
    }

    public <B, C> F<B, F<C, P1<A>>> concurry(final F2<B, C, A> f2) {
        return new F<B, F<C, P1<A>>>(){

            @Override
            public F<C, P1<A>> f(B b) {
                return Strategy.this.concurry(Function.curry(f2).f(b));
            }
        };
    }

    public static <A> List<P1<A>> mergeAll(List<Future<A>> list) {
        return list.map(Strategy.<Future<A>>obtain());
    }

    public P1<List<A>> parList(List<P1<A>> list) {
        return P1.sequence(list.map(this.f()));
    }

    public <B> P1<List<A>> parMap(F<B, A> f, List<B> list) {
        return P1.sequence(list.map(this.concurry(f)));
    }

    public <B> P1<Array<A>> parMap(F<B, A> f, Array<B> array) {
        return P1.sequence(array.map(this.concurry(f)));
    }

    public <B> List<A> parMap1(F<B, A> f, List<B> list) {
        return (List)Function.compose(P1.__1(), this.parMapList(f)).f(list);
    }

    public <B> Array<A> parMap1(F<B, A> f, Array<B> array) {
        return (Array)Function.compose(P1.__1(), this.parMapArray(f)).f(array);
    }

    public <B> F<List<B>, P1<List<A>>> parMapList(final F<B, A> f) {
        return new F<List<B>, P1<List<A>>>(){

            @Override
            public P1<List<A>> f(List<B> list) {
                return Strategy.this.parMap(f, list);
            }
        };
    }

    public <B> F<F<B, A>, F<List<B>, P1<List<A>>>> parMapList() {
        return new F<F<B, A>, F<List<B>, P1<List<A>>>>(){

            @Override
            public F<List<B>, P1<List<A>>> f(F<B, A> f) {
                return Strategy.this.parMapList(f);
            }
        };
    }

    public <B> F<F<B, A>, F<List<B>, List<A>>> parMapList1() {
        return new F<F<B, A>, F<List<B>, List<A>>>(){

            @Override
            public F<List<B>, List<A>> f(final F<B, A> f) {
                return new F<List<B>, List<A>>(){

                    @Override
                    public List<A> f(List<B> list) {
                        return Strategy.this.parMap1(f, list);
                    }
                };
            }
        };
    }

    public <B> F<Array<B>, P1<Array<A>>> parMapArray(final F<B, A> f) {
        return new F<Array<B>, P1<Array<A>>>(){

            @Override
            public P1<Array<A>> f(Array<B> array) {
                return Strategy.this.parMap(f, array);
            }
        };
    }

    public <B> F<F<B, A>, F<Array<B>, P1<Array<A>>>> parMapArray() {
        return new F<F<B, A>, F<Array<B>, P1<Array<A>>>>(){

            @Override
            public F<Array<B>, P1<Array<A>>> f(F<B, A> f) {
                return Strategy.this.parMapArray(f);
            }
        };
    }

    public <B> F<F<B, A>, F<Array<B>, Array<A>>> parMapArray1() {
        return new F<F<B, A>, F<Array<B>, Array<A>>>(){

            @Override
            public F<Array<B>, Array<A>> f(final F<B, A> f) {
                return new F<Array<B>, Array<A>>(){

                    @Override
                    public Array<A> f(Array<B> array) {
                        return Strategy.this.parMap1(f, array);
                    }
                };
            }
        };
    }

    public static <A, B> P1<List<B>> parFlatMap(Strategy<List<B>> strategy, F<A, List<B>> f, List<A> list) {
        return P1.fmap(List.join()).f(strategy.parMap(f, list));
    }

    public static <A, B> P1<Array<B>> parFlatMap(Strategy<Array<B>> strategy, F<A, Array<B>> f, Array<A> array) {
        return P1.fmap(Array.join()).f(strategy.parMap(f, array));
    }

    public static <A> P1<List<A>> parListChunk(Strategy<List<A>> strategy, int n, List<P1<A>> list) {
        return P1.fmap(List.join()).f(strategy.parList(list.partition(n).map(P1.sequenceList())));
    }

    public <B, C> P1<List<A>> parZipWith(F2<B, C, A> f2, List<B> list, List<C> list2) {
        return P1.sequence(list.zipWith(list2, this.concurry(f2)));
    }

    public <B, C> P1<Array<A>> parZipWith(F2<B, C, A> f2, Array<B> array, Array<C> array2) {
        return P1.sequence(array.zipWith(array2, this.concurry(f2)));
    }

    public <B, C> F2<List<B>, List<C>, P1<List<A>>> parZipListWith(final F2<B, C, A> f2) {
        return new F2<List<B>, List<C>, P1<List<A>>>(){

            @Override
            public P1<List<A>> f(List<B> list, List<C> list2) {
                return Strategy.this.parZipWith(f2, list, list2);
            }
        };
    }

    public <B, C> F2<Array<B>, Array<C>, P1<Array<A>>> parZipArrayWith(final F2<B, C, A> f2) {
        return new F2<Array<B>, Array<C>, P1<Array<A>>>(){

            @Override
            public P1<Array<A>> f(Array<B> array, Array<C> array2) {
                return Strategy.this.parZipWith(f2, array, array2);
            }
        };
    }

    public static <A> F<Future<A>, P1<A>> obtain() {
        return new F<Future<A>, P1<A>>(){

            @Override
            public P1<A> f(Future<A> future) {
                return Strategy.obtain(future);
            }
        };
    }

    public static <A> P1<A> obtain(final Future<A> future) {
        return new P1<A>(){

            @Override
            public A _1() {
                try {
                    return future.get();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new Error(interruptedException);
                }
                catch (ExecutionException executionException) {
                    throw new Error(executionException);
                }
            }
        };
    }

    public static <A> Effect<Future<A>> discard() {
        return new Effect<Future<A>>(){

            @Override
            public void e(Future<A> future) {
                Strategy.obtain().f(future)._1();
            }
        };
    }

    public static <A> Strategy<A> simpleThreadStrategy() {
        return Strategy.strategy(new F<P1<A>, P1<A>>(){

            @Override
            public P1<A> f(P1<A> p1) {
                FutureTask futureTask = new FutureTask(Java.P1_Callable().f(p1));
                new Thread(futureTask).start();
                return Strategy.obtain(futureTask);
            }
        });
    }

    public static <A> Strategy<A> executorStrategy(final ExecutorService executorService) {
        return Strategy.strategy(new F<P1<A>, P1<A>>(){

            @Override
            public P1<A> f(P1<A> p1) {
                return Strategy.obtain(executorService.submit(Java.P1_Callable().f(p1)));
            }
        });
    }

    public static <A> Strategy<A> completionStrategy(final CompletionService<A> completionService) {
        return Strategy.strategy(new F<P1<A>, P1<A>>(){

            @Override
            public P1<A> f(P1<A> p1) {
                return Strategy.obtain(completionService.submit(Java.P1_Callable().f(p1)));
            }
        });
    }

    public static <A> Strategy<A> seqStrategy() {
        return Strategy.strategy(new F<P1<A>, P1<A>>(){

            @Override
            public P1<A> f(P1<A> p1) {
                return P.p(p1._1());
            }
        });
    }

    public static <A> Strategy<A> idStrategy() {
        return Strategy.strategy(Function.identity());
    }

    public <B> Strategy<B> xmap(F<P1<A>, P1<B>> f, F<P1<B>, P1<A>> f2) {
        return Strategy.strategy(Function.compose(f, Function.compose(this.f(), f2)));
    }

    public Strategy<A> map(F<P1<A>, P1<A>> f) {
        return this.xmap(f, Function.identity());
    }

    public Strategy<A> comap(F<P1<A>, P1<A>> f) {
        return this.xmap(Function.identity(), f);
    }

    public Strategy<A> errorStrategy(Effect<Error> effect) {
        return Strategy.errorStrategy(this, effect);
    }

    public static <A> Strategy<A> errorStrategy(Strategy<A> strategy, final Effect<Error> effect) {
        return strategy.comap(new F<P1<A>, P1<A>>(){

            @Override
            public P1<A> f(final P1<A> p1) {
                return new P1<A>(){

                    @Override
                    public A _1() {
                        try {
                            return p1._1();
                        }
                        catch (Throwable throwable) {
                            Error error = new Error(throwable);
                            effect.e(error);
                            throw error;
                        }
                    }
                };
            }
        });
    }

    public static <A> Strategy<Callable<A>> callableStrategy(Strategy<Callable<A>> strategy) {
        return strategy.comap(new F<P1<Callable<A>>, P1<Callable<A>>>(){

            @Override
            public P1<Callable<A>> f(P1<Callable<A>> p1) {
                return P1.curry(Callables.normalise()).f(p1._1());
            }
        });
    }
}

