/*
 * Decompiled with CFR 0.152.
 */
package fj.control.parallel;

import fj.Effect;
import fj.F;
import fj.F2;
import fj.Function;
import fj.Monoid;
import fj.P;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.P4;
import fj.Unit;
import fj.control.parallel.Actor;
import fj.control.parallel.Promise;
import fj.control.parallel.QueueActor;
import fj.control.parallel.Strategy;
import fj.data.Array;
import fj.data.IterableW;
import fj.data.List;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Stream;
import fj.data.Tree;
import fj.data.TreeZipper;
import fj.data.Zipper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParModule {
    private final Strategy<Unit> strategy;

    private ParModule(Strategy<Unit> strategy) {
        this.strategy = strategy;
    }

    public static ParModule parModule(Strategy<Unit> strategy) {
        return new ParModule(strategy);
    }

    public <A> Promise<A> promise(P1<A> p1) {
        return Promise.promise(this.strategy, p1);
    }

    public <A> F<P1<A>, Promise<A>> promise() {
        return new F<P1<A>, Promise<A>>(){

            @Override
            public Promise<A> f(P1<A> p1) {
                return ParModule.this.promise(p1);
            }
        };
    }

    public <A, B> F<A, Promise<B>> promise(F<A, B> f) {
        return f.promiseK(this.strategy);
    }

    public <A, B> F<F<A, B>, F<A, Promise<B>>> promisePure() {
        return new F<F<A, B>, F<A, Promise<B>>>(){

            @Override
            public F<A, Promise<B>> f(F<A, B> f) {
                return ParModule.this.promise(f);
            }
        };
    }

    public <A, B, C> F2<A, B, Promise<C>> promise(F2<A, B, C> f2) {
        return P2.untuple(f2.tuple().promiseK(this.strategy));
    }

    public <A> Actor<A> effect(Effect<A> effect) {
        return Actor.actor(this.strategy, effect);
    }

    public <A> F<Effect<A>, Actor<A>> effect() {
        return new F<Effect<A>, Actor<A>>(){

            @Override
            public Actor<A> f(Effect<A> effect) {
                return ParModule.this.effect(effect);
            }
        };
    }

    public <A> QueueActor<A> actor(Effect<A> effect) {
        return QueueActor.queueActor(this.strategy, effect);
    }

    public <A> F<Effect<A>, QueueActor<A>> actor() {
        return new F<Effect<A>, QueueActor<A>>(){

            @Override
            public QueueActor<A> f(Effect<A> effect) {
                return ParModule.this.actor(effect);
            }
        };
    }

    public <A> Promise<List<A>> sequence(List<Promise<A>> list) {
        return Promise.sequence(this.strategy, list);
    }

    public <A> F<List<Promise<A>>, Promise<List<A>>> sequenceList() {
        return new F<List<Promise<A>>, Promise<List<A>>>(){

            @Override
            public Promise<List<A>> f(List<Promise<A>> list) {
                return ParModule.this.sequence(list);
            }
        };
    }

    public <A> Promise<Stream<A>> sequence(Stream<Promise<A>> stream) {
        return Promise.sequence(this.strategy, stream);
    }

    public <A> F<Stream<Promise<A>>, Promise<Stream<A>>> sequenceStream() {
        return new F<Stream<Promise<A>>, Promise<Stream<A>>>(){

            @Override
            public Promise<Stream<A>> f(Stream<Promise<A>> stream) {
                return ParModule.this.sequence(stream);
            }
        };
    }

    public <A> Promise<P1<A>> sequence(P1<Promise<A>> p1) {
        return Promise.sequence(this.strategy, p1);
    }

    public <A, B> Promise<List<B>> mapM(List<A> list, F<A, Promise<B>> f) {
        return this.sequence(list.map(f));
    }

    public <A, B> F<F<A, Promise<B>>, F<List<A>, Promise<List<B>>>> mapList() {
        return Function.curry(new F2<F<A, Promise<B>>, List<A>, Promise<List<B>>>(){

            @Override
            public Promise<List<B>> f(F<A, Promise<B>> f, List<A> list) {
                return ParModule.this.mapM(list, f);
            }
        });
    }

    public <A, B> Promise<Stream<B>> mapM(Stream<A> stream, F<A, Promise<B>> f) {
        return this.sequence(stream.map(f));
    }

    public <A, B> F<F<A, Promise<B>>, F<Stream<A>, Promise<Stream<B>>>> mapStream() {
        return Function.curry(new F2<F<A, Promise<B>>, Stream<A>, Promise<Stream<B>>>(){

            @Override
            public Promise<Stream<B>> f(F<A, Promise<B>> f, Stream<A> stream) {
                return ParModule.this.mapM(stream, f);
            }
        });
    }

    public <A, B> Promise<P1<B>> mapM(P1<A> p1, F<A, Promise<B>> f) {
        return this.sequence(p1.map(f));
    }

    public <A, B> Promise<List<B>> parMap(List<A> list, F<A, B> f) {
        return this.mapM(list, this.promise(f));
    }

    public <A, B> F<F<A, B>, F<List<A>, Promise<List<B>>>> parMapList() {
        return Function.curry(new F2<F<A, B>, List<A>, Promise<List<B>>>(){

            @Override
            public Promise<List<B>> f(F<A, B> f, List<A> list) {
                return ParModule.this.parMap(list, f);
            }
        });
    }

    public <A, B> Promise<NonEmptyList<B>> parMap(NonEmptyList<A> nonEmptyList, F<A, B> f) {
        return this.mapM(nonEmptyList.toList(), this.promise(f)).fmap(new F<List<B>, NonEmptyList<B>>(){

            @Override
            public NonEmptyList<B> f(List<B> list) {
                return NonEmptyList.fromList(list).some();
            }
        });
    }

    public <A, B> Promise<Stream<B>> parMap(Stream<A> stream, F<A, B> f) {
        return this.mapM(stream, this.promise(f));
    }

    public <A, B> F<F<A, B>, F<Stream<A>, Promise<Stream<B>>>> parMapStream() {
        return Function.curry(new F2<F<A, B>, Stream<A>, Promise<Stream<B>>>(){

            @Override
            public Promise<Stream<B>> f(F<A, B> f, Stream<A> stream) {
                return ParModule.this.parMap(stream, f);
            }
        });
    }

    public <A, B> Promise<Iterable<B>> parMap(Iterable<A> iterable, F<A, B> f) {
        return this.parMap(Stream.iterableStream(iterable), f).fmap(Function.vary(Function.identity()));
    }

    public <A, B> F<F<A, B>, F<Iterable<A>, Promise<Iterable<B>>>> parMapIterable() {
        return Function.curry(new F2<F<A, B>, Iterable<A>, Promise<Iterable<B>>>(){

            @Override
            public Promise<Iterable<B>> f(F<A, B> f, Iterable<A> iterable) {
                return ParModule.this.parMap(iterable, f);
            }
        });
    }

    public <A, B> Promise<Array<B>> parMap(Array<A> array, F<A, B> f) {
        return this.parMap(array.toStream(), f).fmap(new F<Stream<B>, Array<B>>(){

            @Override
            public Array<B> f(Stream<B> stream) {
                return stream.toArray();
            }
        });
    }

    public <A, B> F<F<A, B>, F<Array<A>, Promise<Array<B>>>> parMapArray() {
        return Function.curry(new F2<F<A, B>, Array<A>, Promise<Array<B>>>(){

            @Override
            public Promise<Array<B>> f(F<A, B> f, Array<A> array) {
                return ParModule.this.parMap(array, f);
            }
        });
    }

    public <A, B> Promise<Zipper<B>> parMap(Zipper<A> zipper, F<A, B> f) {
        return this.parMap(zipper.rights(), f).apply(this.promise(f).f(zipper.focus()).apply(this.parMap(zipper.lefts(), f).fmap(Function.curry(Zipper.zipper()))));
    }

    public <A, B> Promise<Tree<B>> parMap(Tree<A> tree, F<A, B> f) {
        return this.mapM(tree.subForest(), this.mapStream().f(this.parMapTree().f(f))).apply(this.promise(f).f(tree.root()).fmap(Tree.node()));
    }

    public <A, B> F<F<A, B>, F<Tree<A>, Promise<Tree<B>>>> parMapTree() {
        return Function.curry(new F2<F<A, B>, Tree<A>, Promise<Tree<B>>>(){

            @Override
            public Promise<Tree<B>> f(F<A, B> f, Tree<A> tree) {
                return ParModule.this.parMap(tree, f);
            }
        });
    }

    public <A, B> Promise<TreeZipper<B>> parMap(TreeZipper<A> treeZipper, final F<A, B> f) {
        final F f2 = Tree.fmap_().f(f);
        P4<Tree<A>, Stream<Tree<A>>, Stream<Tree<A>>, Stream<P3<Stream<Tree<A>>, A, Stream<Tree<A>>>>> p4 = treeZipper.p();
        return this.mapM(p4._4(), new F<P3<Stream<Tree<A>>, A, Stream<Tree<A>>>, Promise<P3<Stream<Tree<B>>, B, Stream<Tree<B>>>>>(){

            @Override
            public Promise<P3<Stream<Tree<B>>, B, Stream<Tree<B>>>> f(P3<Stream<Tree<A>>, A, Stream<Tree<A>>> p3) {
                return ParModule.this.parMap(p3._3(), f2).apply(ParModule.this.promise(f).f(p3._2()).apply(ParModule.this.parMap(p3._1(), f2).fmap(P.p3())));
            }
        }).apply(this.parMap(treeZipper.rights(), f2).apply(this.parMap(treeZipper.lefts(), f2).apply(this.parMap(p4._1(), f).fmap(TreeZipper.treeZipper()))));
    }

    public <A, B> Promise<List<B>> parFlatMap(List<A> list, F<A, List<B>> f) {
        return this.parFoldMap(list, f, Monoid.listMonoid());
    }

    public <A, B> Promise<Stream<B>> parFlatMap(Stream<A> stream, F<A, Stream<B>> f) {
        return this.parFoldMap(stream, f, Monoid.streamMonoid());
    }

    public <A, B> Promise<Array<B>> parFlatMap(Array<A> array, F<A, Array<B>> f) {
        return this.parMap(array, f).fmap(Array.join());
    }

    public <A, B> Promise<Iterable<B>> parFlatMap(Iterable<A> iterable, F<A, Iterable<B>> f) {
        return this.parMap(iterable, f).fmap(IterableW.join()).fmap(Function.vary(Function.identity()));
    }

    public <A, B, C> Promise<List<C>> parZipWith(List<A> list, List<B> list2, F<A, F<B, C>> f) {
        return this.sequence(list.zipWith(list2, this.promise(Function.uncurryF2(f))));
    }

    public <A, B, C> Promise<Stream<C>> parZipWith(Stream<A> stream, Stream<B> stream2, F<A, F<B, C>> f) {
        return this.sequence(stream.zipWith(stream2, this.promise(Function.uncurryF2(f))));
    }

    public <A, B, C> Promise<Array<C>> parZipWith(Array<A> array, Array<B> array2, F<A, F<B, C>> f) {
        return this.parZipWith(array.toStream(), array2.toStream(), f).fmap(new F<Stream<C>, Array<C>>(){

            @Override
            public Array<C> f(Stream<C> stream) {
                return stream.toArray();
            }
        });
    }

    public <A, B, C> Promise<Iterable<C>> parZipWith(Iterable<A> iterable, Iterable<B> iterable2, F<A, F<B, C>> f) {
        return this.parZipWith(Stream.iterableStream(iterable), Stream.iterableStream(iterable2), f).fmap(Function.vary(Function.identity()));
    }

    public <A, B> Promise<B> parFoldMap(Stream<A> stream, F<A, B> f, Monoid<B> monoid) {
        return stream.isEmpty() ? this.promise(P.p(monoid.zero())) : stream.map(this.promise(f)).foldLeft1(Promise.liftM2(monoid.sum()));
    }

    public <A, B> Promise<B> parFoldMap(Stream<A> stream, F<A, B> f, final Monoid<B> monoid, final F<Stream<A>, P2<Stream<A>, Stream<A>>> f2) {
        return this.parMap(Stream.unfold(new F<Stream<A>, Option<P2<Stream<A>, Stream<A>>>>(){

            @Override
            public Option<P2<Stream<A>, Stream<A>>> f(Stream<A> stream) {
                return stream.isEmpty() ? Option.none() : Option.some(f2.f(stream));
            }
        }, stream), Stream.map_().f(f)).bind(new F<Stream<Stream<B>>, Promise<B>>(){

            @Override
            public Promise<B> f(Stream<Stream<B>> stream) {
                return ParModule.this.parMap(stream, monoid.sumLeftS()).fmap(monoid.sumLeftS());
            }
        });
    }

    public <A, B> Promise<B> parFoldMap(Iterable<A> iterable, F<A, B> f, Monoid<B> monoid, final F<Iterable<A>, P2<Iterable<A>, Iterable<A>>> f2) {
        return this.parFoldMap(Stream.iterableStream(iterable), f, monoid, new F<Stream<A>, P2<Stream<A>, Stream<A>>>(){

            @Override
            public P2<Stream<A>, Stream<A>> f(Stream<A> stream) {
                F f = new F<Iterable<A>, Stream<A>>(){

                    @Override
                    public Stream<A> f(Iterable<A> iterable) {
                        return Stream.iterableStream(iterable);
                    }
                };
                return ((P2)f2.f(stream)).map1(f).map2(f);
            }
        });
    }

    public <A, B> Promise<B> parFoldMap(Iterable<A> iterable, F<A, B> f, Monoid<B> monoid) {
        return this.parFoldMap(Stream.iterableStream(iterable), f, monoid);
    }

    public <A, B> Promise<Zipper<B>> parExtend(Zipper<A> zipper, F<Zipper<A>, B> f) {
        return this.parMap(zipper.positions(), f);
    }

    public <A, B> Promise<Tree<B>> parExtend(Tree<A> tree, F<Tree<A>, B> f) {
        return this.parMap(tree.cojoin(), f);
    }

    public <A, B> Promise<TreeZipper<B>> parExtend(TreeZipper<A> treeZipper, F<TreeZipper<A>, B> f) {
        return this.parMap(treeZipper.positions(), f);
    }

    public <A, B> Promise<NonEmptyList<B>> parExtend(NonEmptyList<A> nonEmptyList, F<NonEmptyList<A>, B> f) {
        return this.parMap(nonEmptyList.tails(), f);
    }
}

