/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.Equal;
import fj.F;
import fj.F2;
import fj.Function;
import fj.Ordering;
import fj.P;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.Unit;
import fj.data.Array;
import fj.data.Either;
import fj.data.List;
import fj.data.Natural;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Set;
import fj.data.Stream;
import fj.data.Validation;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Ord<A> {
    private final F<A, F<A, Ordering>> f;
    public final F<A, F<A, A>> max = Function.curry(new F2<A, A, A>(){

        @Override
        public A f(A a, A a2) {
            return Ord.this.max(a, a2);
        }
    });
    public final F<A, F<A, A>> min = Function.curry(new F2<A, A, A>(){

        @Override
        public A f(A a, A a2) {
            return Ord.this.min(a, a2);
        }
    });
    public static final Ord<Boolean> booleanOrd = new Ord<Boolean>(new F<Boolean, F<Boolean, Ordering>>(){

        @Override
        public F<Boolean, Ordering> f(final Boolean bl) {
            return new F<Boolean, Ordering>(){

                @Override
                public Ordering f(Boolean bl2) {
                    int n = bl.compareTo(bl2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<Byte> byteOrd = new Ord<Byte>(new F<Byte, F<Byte, Ordering>>(){

        @Override
        public F<Byte, Ordering> f(final Byte by) {
            return new F<Byte, Ordering>(){

                @Override
                public Ordering f(Byte by2) {
                    int n = by.compareTo(by2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<Character> charOrd = new Ord<Character>(new F<Character, F<Character, Ordering>>(){

        @Override
        public F<Character, Ordering> f(final Character c) {
            return new F<Character, Ordering>(){

                @Override
                public Ordering f(Character c2) {
                    int n = c.compareTo(c2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<Double> doubleOrd = new Ord<Double>(new F<Double, F<Double, Ordering>>(){

        @Override
        public F<Double, Ordering> f(final Double d) {
            return new F<Double, Ordering>(){

                @Override
                public Ordering f(Double d2) {
                    int n = d.compareTo(d2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<Float> floatOrd = new Ord<Float>(new F<Float, F<Float, Ordering>>(){

        @Override
        public F<Float, Ordering> f(final Float f) {
            return new F<Float, Ordering>(){

                @Override
                public Ordering f(Float f2) {
                    int n = f.compareTo(f2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<Integer> intOrd = new Ord<Integer>(new F<Integer, F<Integer, Ordering>>(){

        @Override
        public F<Integer, Ordering> f(final Integer n) {
            return new F<Integer, Ordering>(){

                @Override
                public Ordering f(Integer n3) {
                    int n2 = n.compareTo(n3);
                    return n2 < 0 ? Ordering.LT : (n2 == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<BigInteger> bigintOrd = new Ord<BigInteger>(new F<BigInteger, F<BigInteger, Ordering>>(){

        @Override
        public F<BigInteger, Ordering> f(final BigInteger bigInteger) {
            return new F<BigInteger, Ordering>(){

                @Override
                public Ordering f(BigInteger bigInteger2) {
                    int n = bigInteger.compareTo(bigInteger2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<BigDecimal> bigdecimalOrd = new Ord<BigDecimal>(new F<BigDecimal, F<BigDecimal, Ordering>>(){

        @Override
        public F<BigDecimal, Ordering> f(final BigDecimal bigDecimal) {
            return new F<BigDecimal, Ordering>(){

                @Override
                public Ordering f(BigDecimal bigDecimal2) {
                    int n = bigDecimal.compareTo(bigDecimal2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<Long> longOrd = new Ord<Long>(new F<Long, F<Long, Ordering>>(){

        @Override
        public F<Long, Ordering> f(final Long l) {
            return new F<Long, Ordering>(){

                @Override
                public Ordering f(Long l2) {
                    int n = l.compareTo(l2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<Short> shortOrd = new Ord<Short>(new F<Short, F<Short, Ordering>>(){

        @Override
        public F<Short, Ordering> f(final Short s) {
            return new F<Short, Ordering>(){

                @Override
                public Ordering f(Short s2) {
                    int n = s.compareTo(s2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<Ordering> orderingOrd = new Ord<Ordering>(Function.curry(new F2<Ordering, Ordering, Ordering>(){

        @Override
        public Ordering f(Ordering ordering, Ordering ordering2) {
            return ordering == ordering2 ? Ordering.EQ : (ordering == Ordering.LT ? Ordering.LT : (ordering2 == Ordering.LT ? Ordering.GT : (ordering == Ordering.EQ ? Ordering.LT : Ordering.GT)));
        }
    }));
    public static final Ord<String> stringOrd = new Ord<String>(new F<String, F<String, Ordering>>(){

        @Override
        public F<String, Ordering> f(final String string) {
            return new F<String, Ordering>(){

                @Override
                public Ordering f(String string2) {
                    int n = string.compareTo(string2);
                    return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                }
            };
        }
    });
    public static final Ord<StringBuffer> stringBufferOrd = new Ord<StringBuffer>(new F<StringBuffer, F<StringBuffer, Ordering>>(){

        @Override
        public F<StringBuffer, Ordering> f(final StringBuffer stringBuffer) {
            return new F<StringBuffer, Ordering>(){

                @Override
                public Ordering f(StringBuffer stringBuffer2) {
                    return stringOrd.compare(stringBuffer.toString(), stringBuffer2.toString());
                }
            };
        }
    });
    public static final Ord<StringBuilder> stringBuilderOrd = new Ord<StringBuilder>(new F<StringBuilder, F<StringBuilder, Ordering>>(){

        @Override
        public F<StringBuilder, Ordering> f(final StringBuilder stringBuilder) {
            return new F<StringBuilder, Ordering>(){

                @Override
                public Ordering f(StringBuilder stringBuilder2) {
                    return stringOrd.compare(stringBuilder.toString(), stringBuilder2.toString());
                }
            };
        }
    });
    public static final Ord<Unit> unitOrd = Ord.ord(Function.curry(new F2<Unit, Unit, Ordering>(){

        @Override
        public Ordering f(Unit unit, Unit unit2) {
            return Ordering.EQ;
        }
    }));
    public static final Ord<Natural> naturalOrd = bigintOrd.comap(Natural.bigIntegerValue);

    private Ord(F<A, F<A, Ordering>> f) {
        this.f = f;
    }

    public F<A, F<A, Ordering>> compare() {
        return this.f;
    }

    public Ordering compare(A a, A a2) {
        return this.f.f(a).f(a2);
    }

    public boolean eq(A a, A a2) {
        return this.compare(a, a2) == Ordering.EQ;
    }

    public Equal<A> equal() {
        return Equal.equal(Function.curry(new F2<A, A, Boolean>(){

            @Override
            public Boolean f(A a, A a2) {
                return Ord.this.eq(a, a2);
            }
        }));
    }

    public <B> Ord<B> comap(F<B, A> f) {
        return Ord.ord(f.andThen().o(this.f).o(f));
    }

    public boolean isLessThan(A a, A a2) {
        return this.compare(a, a2) == Ordering.LT;
    }

    public boolean isGreaterThan(A a, A a2) {
        return this.compare(a, a2) == Ordering.GT;
    }

    public F<A, Boolean> isLessThan(final A a) {
        return new F<A, Boolean>(){

            @Override
            public Boolean f(A a2) {
                return Ord.this.compare(a2, a) == Ordering.LT;
            }
        };
    }

    public F<A, Boolean> isGreaterThan(final A a) {
        return new F<A, Boolean>(){

            @Override
            public Boolean f(A a2) {
                return Ord.this.compare(a2, a) == Ordering.GT;
            }
        };
    }

    public A max(A a, A a2) {
        return this.isGreaterThan(a, a2) ? a : a2;
    }

    public A min(A a, A a2) {
        return this.isLessThan(a, a2) ? a : a2;
    }

    public static <A> Ord<A> ord(F<A, F<A, Ordering>> f) {
        return new Ord<A>(f);
    }

    public static <A> Ord<Option<A>> optionOrd(final Ord<A> ord) {
        return new Ord<Option<A>>(new F<Option<A>, F<Option<A>, Ordering>>(){

            @Override
            public F<Option<A>, Ordering> f(final Option<A> option) {
                return new F<Option<A>, Ordering>(){

                    @Override
                    public Ordering f(Option<A> option2) {
                        return option.isNone() ? (option2.isNone() ? Ordering.EQ : Ordering.LT) : (option2.isNone() ? Ordering.GT : (Ordering)((Object)((F)ord.f.f(option.some())).f(option2.some())));
                    }
                };
            }
        });
    }

    public static <A, B> Ord<Either<A, B>> eitherOrd(final Ord<A> ord, final Ord<B> ord2) {
        return new Ord<Either<A, B>>(new F<Either<A, B>, F<Either<A, B>, Ordering>>(){

            @Override
            public F<Either<A, B>, Ordering> f(final Either<A, B> either) {
                return new F<Either<A, B>, Ordering>(){

                    @Override
                    public Ordering f(Either<A, B> either2) {
                        return either.isLeft() ? (either2.isLeft() ? (Ordering)((Object)((F)ord.f.f(either.left().value())).f(either2.left().value())) : Ordering.LT) : (either2.isLeft() ? Ordering.GT : (Ordering)((Object)((F)ord2.f.f(either.right().value())).f(either2.right().value())));
                    }
                };
            }
        });
    }

    public static <A, B> Ord<Validation<A, B>> validationOrd(Ord<A> ord, Ord<B> ord2) {
        return Ord.eitherOrd(ord, ord2).comap(Validation.either());
    }

    public static <A> Ord<List<A>> listOrd(final Ord<A> ord) {
        return new Ord<List<A>>(new F<List<A>, F<List<A>, Ordering>>(){

            @Override
            public F<List<A>, Ordering> f(final List<A> list) {
                return new F<List<A>, Ordering>(){

                    @Override
                    public Ordering f(List<A> list2) {
                        if (list.isEmpty()) {
                            return list2.isEmpty() ? Ordering.EQ : Ordering.LT;
                        }
                        if (list2.isEmpty()) {
                            return list.isEmpty() ? Ordering.EQ : Ordering.GT;
                        }
                        Ordering ordering = ord.compare(list.head(), list2.head());
                        return ordering == Ordering.EQ ? (Ordering)((Object)((F)Ord.listOrd(ord).f.f(list.tail())).f(list2.tail())) : ordering;
                    }
                };
            }
        });
    }

    public static <A> Ord<NonEmptyList<A>> nonEmptyListOrd(Ord<A> ord) {
        return Ord.listOrd(ord).comap(NonEmptyList.toList_());
    }

    public static <A> Ord<Stream<A>> streamOrd(final Ord<A> ord) {
        return new Ord<Stream<A>>(new F<Stream<A>, F<Stream<A>, Ordering>>(){

            @Override
            public F<Stream<A>, Ordering> f(final Stream<A> stream) {
                return new F<Stream<A>, Ordering>(){

                    @Override
                    public Ordering f(Stream<A> stream2) {
                        if (stream.isEmpty()) {
                            return stream2.isEmpty() ? Ordering.EQ : Ordering.LT;
                        }
                        if (stream2.isEmpty()) {
                            return stream.isEmpty() ? Ordering.EQ : Ordering.GT;
                        }
                        Ordering ordering = ord.compare(stream.head(), stream2.head());
                        return ordering == Ordering.EQ ? (Ordering)((Object)((F)Ord.streamOrd(ord).f.f(stream.tail()._1())).f(stream2.tail()._1())) : ordering;
                    }
                };
            }
        });
    }

    public static <A> Ord<Array<A>> arrayOrd(final Ord<A> ord) {
        return new Ord<Array<A>>(new F<Array<A>, F<Array<A>, Ordering>>(){

            @Override
            public F<Array<A>, Ordering> f(final Array<A> array) {
                return new F<Array<A>, Ordering>(){

                    @Override
                    public Ordering f(Array<A> array2) {
                        int n;
                        for (n = 0; n < array.length() && n < array2.length(); ++n) {
                            Ordering ordering = ord.compare(array.get(n), array2.get(n));
                            if (ordering != Ordering.GT && ordering != Ordering.LT) continue;
                            return ordering;
                        }
                        return n == array.length() ? (n == array2.length() ? Ordering.EQ : Ordering.LT) : (n == array.length() ? Ordering.EQ : Ordering.GT);
                    }
                };
            }
        });
    }

    public static <A> Ord<Set<A>> setOrd(Ord<A> ord) {
        return Ord.streamOrd(ord).comap(new F<Set<A>, Stream<A>>(){

            @Override
            public Stream<A> f(Set<A> set) {
                return set.toStream();
            }
        });
    }

    public static <A> Ord<P1<A>> p1Ord(Ord<A> ord) {
        return ord.comap(P1.__1());
    }

    public static <A, B> Ord<P2<A, B>> p2Ord(final Ord<A> ord, final Ord<B> ord2) {
        return Ord.ord(Function.curry(new F2<P2<A, B>, P2<A, B>, Ordering>(){

            @Override
            public Ordering f(P2<A, B> p2, P2<A, B> p22) {
                return ord.eq(p2._1(), p22._1()) ? ord2.compare(p2._2(), p22._2()) : ord.compare(p2._1(), p22._1());
            }
        }));
    }

    public static <A, B, C> Ord<P3<A, B, C>> p3Ord(final Ord<A> ord, final Ord<B> ord2, final Ord<C> ord3) {
        return Ord.ord(Function.curry(new F2<P3<A, B, C>, P3<A, B, C>, Ordering>(){

            @Override
            public Ordering f(P3<A, B, C> p3, P3<A, B, C> p32) {
                return ord.eq(p3._1(), p32._1()) ? Ord.p2Ord(ord2, ord3).compare(P.p(p3._2(), p3._3()), P.p(p32._2(), p32._3())) : ord.compare(p3._1(), p32._1());
            }
        }));
    }

    public static <A extends Comparable<A>> Ord<A> comparableOrd() {
        return Ord.ord(new F<A, F<A, Ordering>>(){

            @Override
            public F<A, Ordering> f(A a) {
                return new F<A, Ordering>((Comparable)a){
                    final /* synthetic */ Comparable val$a1;
                    {
                        this.val$a1 = comparable;
                    }

                    @Override
                    public Ordering f(A a) {
                        int n = this.val$a1.compareTo(a);
                        return n < 0 ? Ordering.LT : (n == 0 ? Ordering.EQ : Ordering.GT);
                    }
                };
            }
        });
    }
}

