/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.F;
import fj.Function;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.P4;
import fj.P5;
import fj.P6;
import fj.P7;
import fj.P8;
import fj.data.Array;
import fj.data.Either;
import fj.data.List;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Stream;
import fj.data.Tree;
import fj.data.Validation;
import fj.data.vector.V2;
import fj.data.vector.V3;
import fj.data.vector.V4;
import fj.data.vector.V5;
import fj.data.vector.V6;
import fj.data.vector.V7;
import fj.data.vector.V8;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Hash<A> {
    private final F<A, Integer> f;
    public static final Hash<Boolean> booleanHash = Hash.anyHash();
    public static final Hash<Byte> byteHash = Hash.anyHash();
    public static final Hash<Character> charHash = Hash.anyHash();
    public static final Hash<Double> doubleHash = Hash.anyHash();
    public static final Hash<Float> floatHash = Hash.anyHash();
    public static final Hash<Integer> intHash = Hash.anyHash();
    public static final Hash<Long> longHash = Hash.anyHash();
    public static final Hash<Short> shortHash = Hash.anyHash();
    public static final Hash<String> stringHash = Hash.anyHash();
    public static final Hash<StringBuffer> stringBufferHash = new Hash<StringBuffer>(new F<StringBuffer, Integer>(){

        @Override
        public Integer f(StringBuffer stringBuffer) {
            int n = 239;
            for (int i = 0; i < stringBuffer.length(); ++i) {
                n = 419 * n + stringBuffer.charAt(i);
            }
            return n;
        }
    });
    public static final Hash<StringBuilder> stringBuilderHash = new Hash<StringBuilder>(new F<StringBuilder, Integer>(){

        @Override
        public Integer f(StringBuilder stringBuilder) {
            int n = 239;
            for (int i = 0; i < stringBuilder.length(); ++i) {
                n = 419 * n + stringBuilder.charAt(i);
            }
            return n;
        }
    });

    private Hash(F<A, Integer> f) {
        this.f = f;
    }

    public int hash(A a) {
        return this.f.f(a);
    }

    public <B> Hash<B> comap(F<B, A> f) {
        return new Hash<B>(Function.compose(this.f, f));
    }

    public static <A> Hash<A> hash(F<A, Integer> f) {
        return new Hash<A>(f);
    }

    public static <A> Hash<A> anyHash() {
        return new Hash<A>(new F<A, Integer>(){

            @Override
            public Integer f(A a) {
                return a.hashCode();
            }
        });
    }

    public static <A, B> Hash<Either<A, B>> eitherHash(final Hash<A> hash, final Hash<B> hash2) {
        return new Hash<Either<A, B>>(new F<Either<A, B>, Integer>(){

            @Override
            public Integer f(Either<A, B> either) {
                return either.isLeft() ? hash.hash(either.left().value()) : hash2.hash(either.right().value());
            }
        });
    }

    public static <A, B> Hash<Validation<A, B>> validationHash(Hash<A> hash, Hash<B> hash2) {
        return Hash.eitherHash(hash, hash2).comap(Validation.either());
    }

    public static <A> Hash<List<A>> listHash(final Hash<A> hash) {
        return new Hash<List<A>>(new F<List<A>, Integer>(){

            @Override
            public Integer f(List<A> list) {
                int n = 239;
                List list2 = list;
                while (!list2.isEmpty()) {
                    n = 419 * n + hash.hash(list2.head());
                    list2 = list2.tail();
                }
                return n;
            }
        });
    }

    public static <A> Hash<NonEmptyList<A>> nonEmptyListHash(Hash<A> hash) {
        return Hash.listHash(hash).comap(NonEmptyList.toList_());
    }

    public static <A> Hash<Option<A>> optionHash(final Hash<A> hash) {
        return new Hash<Option<A>>(new F<Option<A>, Integer>(){

            @Override
            public Integer f(Option<A> option) {
                return option.isNone() ? 0 : hash.hash(option.some());
            }
        });
    }

    public static <A> Hash<Stream<A>> streamHash(final Hash<A> hash) {
        return new Hash<Stream<A>>(new F<Stream<A>, Integer>(){

            @Override
            public Integer f(Stream<A> stream) {
                int n = 239;
                Stream stream2 = stream;
                while (!stream2.isEmpty()) {
                    n = 419 * n + hash.hash(stream2.head());
                    stream2 = stream2.tail()._1();
                }
                return n;
            }
        });
    }

    public static <A> Hash<Array<A>> arrayHash(final Hash<A> hash) {
        return new Hash<Array<A>>(new F<Array<A>, Integer>(){

            @Override
            public Integer f(Array<A> array) {
                int n = 239;
                for (int i = 0; i < array.length(); ++i) {
                    n = 419 * n + hash.hash(array.get(i));
                }
                return n;
            }
        });
    }

    public static <A> Hash<Tree<A>> treeHash(Hash<A> hash) {
        return Hash.streamHash(hash).comap(Tree.flatten_());
    }

    public static <A> Hash<P1<A>> p1Hash(Hash<A> hash) {
        return hash.comap(P1.__1());
    }

    public static <A, B> Hash<P2<A, B>> p2Hash(final Hash<A> hash, final Hash<B> hash2) {
        return new Hash<P2<A, B>>(new F<P2<A, B>, Integer>(){

            @Override
            public Integer f(P2<A, B> p2) {
                int n = 239;
                n = 419 * n + hash.hash(p2._1());
                n = 419 * n + hash2.hash(p2._2());
                return n;
            }
        });
    }

    public static <A, B, C> Hash<P3<A, B, C>> p3Hash(final Hash<A> hash, final Hash<B> hash2, final Hash<C> hash3) {
        return new Hash<P3<A, B, C>>(new F<P3<A, B, C>, Integer>(){

            @Override
            public Integer f(P3<A, B, C> p3) {
                int n = 239;
                n = 419 * n + hash.hash(p3._1());
                n = 419 * n + hash2.hash(p3._2());
                n = 419 * n + hash3.hash(p3._3());
                return n;
            }
        });
    }

    public static <A, B, C, D> Hash<P4<A, B, C, D>> p4Hash(final Hash<A> hash, final Hash<B> hash2, final Hash<C> hash3, final Hash<D> hash4) {
        return new Hash<P4<A, B, C, D>>(new F<P4<A, B, C, D>, Integer>(){

            @Override
            public Integer f(P4<A, B, C, D> p4) {
                int n = 239;
                n = 419 * n + hash.hash(p4._1());
                n = 419 * n + hash2.hash(p4._2());
                n = 419 * n + hash3.hash(p4._3());
                n = 419 * n + hash4.hash(p4._4());
                return n;
            }
        });
    }

    public static <A, B, C, D, E> Hash<P5<A, B, C, D, E>> p5Hash(final Hash<A> hash, final Hash<B> hash2, final Hash<C> hash3, final Hash<D> hash4, final Hash<E> hash5) {
        return new Hash<P5<A, B, C, D, E>>(new F<P5<A, B, C, D, E>, Integer>(){

            @Override
            public Integer f(P5<A, B, C, D, E> p5) {
                int n = 239;
                n = 419 * n + hash.hash(p5._1());
                n = 419 * n + hash2.hash(p5._2());
                n = 419 * n + hash3.hash(p5._3());
                n = 419 * n + hash4.hash(p5._4());
                n = 419 * n + hash5.hash(p5._5());
                return n;
            }
        });
    }

    public static <A, B, C, D, E, F$> Hash<P6<A, B, C, D, E, F$>> p6Hash(final Hash<A> hash, final Hash<B> hash2, final Hash<C> hash3, final Hash<D> hash4, final Hash<E> hash5, final Hash<F$> hash6) {
        return new Hash<P6<A, B, C, D, E, F$>>(new F<P6<A, B, C, D, E, F$>, Integer>(){

            @Override
            public Integer f(P6<A, B, C, D, E, F$> p6) {
                int n = 239;
                n = 419 * n + hash.hash(p6._1());
                n = 419 * n + hash2.hash(p6._2());
                n = 419 * n + hash3.hash(p6._3());
                n = 419 * n + hash4.hash(p6._4());
                n = 419 * n + hash5.hash(p6._5());
                n = 419 * n + hash6.hash(p6._6());
                return n;
            }
        });
    }

    public static <A, B, C, D, E, F$, G> Hash<P7<A, B, C, D, E, F$, G>> p7Hash(final Hash<A> hash, final Hash<B> hash2, final Hash<C> hash3, final Hash<D> hash4, final Hash<E> hash5, final Hash<F$> hash6, final Hash<G> hash7) {
        return new Hash<P7<A, B, C, D, E, F$, G>>(new F<P7<A, B, C, D, E, F$, G>, Integer>(){

            @Override
            public Integer f(P7<A, B, C, D, E, F$, G> p7) {
                int n = 239;
                n = 419 * n + hash.hash(p7._1());
                n = 419 * n + hash2.hash(p7._2());
                n = 419 * n + hash3.hash(p7._3());
                n = 419 * n + hash4.hash(p7._4());
                n = 419 * n + hash5.hash(p7._5());
                n = 419 * n + hash6.hash(p7._6());
                n = 419 * n + hash7.hash(p7._7());
                return n;
            }
        });
    }

    public static <A, B, C, D, E, F$, G, H> Hash<P8<A, B, C, D, E, F$, G, H>> p8Hash(final Hash<A> hash, final Hash<B> hash2, final Hash<C> hash3, final Hash<D> hash4, final Hash<E> hash5, final Hash<F$> hash6, final Hash<G> hash7, final Hash<H> hash8) {
        return new Hash<P8<A, B, C, D, E, F$, G, H>>(new F<P8<A, B, C, D, E, F$, G, H>, Integer>(){

            @Override
            public Integer f(P8<A, B, C, D, E, F$, G, H> p8) {
                int n = 239;
                n = 419 * n + hash.hash(p8._1());
                n = 419 * n + hash2.hash(p8._2());
                n = 419 * n + hash3.hash(p8._3());
                n = 419 * n + hash4.hash(p8._4());
                n = 419 * n + hash5.hash(p8._5());
                n = 419 * n + hash6.hash(p8._6());
                n = 419 * n + hash7.hash(p8._7());
                n = 419 * n + hash8.hash(p8._8());
                return n;
            }
        });
    }

    public static <A> Hash<V2<A>> v2Hash(Hash<A> hash) {
        return Hash.streamHash(hash).comap(V2.toStream_());
    }

    public static <A> Hash<V3<A>> v3Hash(Hash<A> hash) {
        return Hash.streamHash(hash).comap(V3.toStream_());
    }

    public static <A> Hash<V4<A>> v4Hash(Hash<A> hash) {
        return Hash.streamHash(hash).comap(V4.toStream_());
    }

    public static <A> Hash<V5<A>> v5Hash(Hash<A> hash) {
        return Hash.streamHash(hash).comap(V5.toStream_());
    }

    public static <A> Hash<V6<A>> v6Hash(Hash<A> hash) {
        return Hash.streamHash(hash).comap(V6.toStream_());
    }

    public static <A> Hash<V7<A>> v7Hash(Hash<A> hash) {
        return Hash.streamHash(hash).comap(V7.toStream_());
    }

    public static <A> Hash<V8<A>> v8Hash(Hash<A> hash) {
        return Hash.streamHash(hash).comap(V8.toStream_());
    }
}

