/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.esupecm.workflow.service;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.orioai.esupecm.OriOaiMetadataType;
import org.orioai.esupecm.workflow.WsDescriptor;
import org.orioai.esupecm.workflow.service.OriOaiWorkflowService;
import org.orioai.ws.workflow.IOriWorkflowService;
import org.orioai.ws.workflow.InstanceInfos;

public class OriOaiWorkflowServiceImpl
extends DefaultComponent
implements OriOaiWorkflowService {
    private static final Log log = LogFactory.getLog(OriOaiWorkflowServiceImpl.class);
    protected WsDescriptor config;
    protected HashMap<String, IOriWorkflowService> _oriWorkflowServices;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        this.config = (WsDescriptor)contribution;
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (this.config == contribution) {
            this.config = null;
        }
    }

    private IOriWorkflowService getRemoteOriWorkflowService(String username) {
        IOriWorkflowService oriWorkflowService;
        if (this._oriWorkflowServices == null) {
            this._oriWorkflowServices = new HashMap();
        }
        if ((oriWorkflowService = this._oriWorkflowServices.get(username)) == null) {
            String wsUrl = this.config.getWsUrl();
            log.info((Object)("getRemoteOriWorkflowService :: contacting Web Service from URL : " + wsUrl));
            try {
                QName service_name = new QName("http://remote.services.workflow.orioai.org/", "OriWorkflowServiceService");
                Service service = Service.create((URL)new URL(wsUrl + "?wsdl"), (QName)service_name);
                oriWorkflowService = (IOriWorkflowService)service.getPort(IOriWorkflowService.class);
                this._oriWorkflowServices.put(username, oriWorkflowService);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("pb retireving ori-oai-workflow Web Service", e);
            }
        }
        return oriWorkflowService;
    }

    @Override
    public List<OriOaiMetadataType> getMetadataTypes(String username) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMetadataTypes :: going to get metadataTypes for " + username));
        }
        IOriWorkflowService oriWorkflowService = this.getRemoteOriWorkflowService(username);
        Map metadataTypes = oriWorkflowService.getMetadataTypes(username);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMetadataTypes :: get metadataTypes for " + username + " from Web Service ok : " + metadataTypes.toString()));
        }
        ArrayList<OriOaiMetadataType> oriOaiMetadataTypes = new ArrayList<OriOaiMetadataType>();
        for (String metadataTypeId : metadataTypes.keySet()) {
            String metadataTypeLabel = (String)metadataTypes.get(metadataTypeId);
            OriOaiMetadataType metadataType = new OriOaiMetadataType(metadataTypeId, metadataTypeLabel);
            oriOaiMetadataTypes.add(metadataType);
        }
        return oriOaiMetadataTypes;
    }

    @Override
    public Long newWorkflowInstance(String username, String metadataTypeId) {
        IOriWorkflowService oriWorkflowService = this.getRemoteOriWorkflowService(username);
        log.debug((Object)"newWorkflowInstance :: call newWorkflowInstance from Web Service ...");
        Long id = oriWorkflowService.newWorkflowInstance(null, metadataTypeId, username);
        return id;
    }

    @Override
    public Map<String, String> getCurrentStates(String username, String idp, String language) {
        IOriWorkflowService oriWorkflowService = this.getRemoteOriWorkflowService(username);
        Map currentStates = oriWorkflowService.getCurrentStates(idp, language);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCurrentStates :: currentStates=" + currentStates));
        }
        return currentStates;
    }

    public Vector<String> getCurrentStates(Map<String, String> statesMap) {
        Vector<String> currentStates = new Vector<String>();
        for (String key : statesMap.keySet()) {
            currentStates.add(statesMap.get(key));
        }
        return currentStates;
    }

    @Override
    public List<String> getCurrentInformations(String username, String idp, String language) {
        IOriWorkflowService oriWorkflowService = this.getRemoteOriWorkflowService(username);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCurrentInformations :: idp=" + idp));
            log.debug((Object)("getCurrentInformations :: language=" + language));
        }
        Map currentInformations = oriWorkflowService.getErrors(idp, language);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCurrentInformations :: currentInformations=" + currentInformations));
        }
        ArrayList<String> informations = new ArrayList<String>();
        for (Map.Entry entry : currentInformations.entrySet()) {
            if (entry.getKey() == null) continue;
            informations.add((String)entry.getValue());
        }
        return informations;
    }

    @Override
    public List<String> getCurrentInformations(Map<String, String> currentInformations) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCurrentInformations :: currentInformations=" + currentInformations));
        }
        ArrayList<String> informations = new ArrayList<String>();
        for (Map.Entry<String, String> entry : currentInformations.entrySet()) {
            if (entry.getKey() == null) continue;
            informations.add(entry.getValue());
        }
        return informations;
    }

    @Override
    public OriOaiMetadataType getMetadataType(String username, String idp) {
        IOriWorkflowService oriWorkflowService = this.getRemoteOriWorkflowService(username);
        try {
            String metadataTypeId = oriWorkflowService.getMetadataType(idp);
            return new OriOaiMetadataType(metadataTypeId, (String)oriWorkflowService.getMetadataTypes().get(metadataTypeId));
        }
        catch (Exception e) {
            log.error((Object)("getMetadataType :: can't retrieve metadata type from idp " + idp), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getMetadataSchemaNamespace(String username, String metadataTypeId) {
        IOriWorkflowService oriWorkflowService = this.getRemoteOriWorkflowService(username);
        try {
            String metadataSchemaNamespace = oriWorkflowService.getMetadataSchemaNamespace(metadataTypeId);
            return metadataSchemaNamespace;
        }
        catch (Exception e) {
            log.error((Object)("getMetadataSchemaNamespace :: can't retrieve metadata namespace from metadataTypeId " + metadataTypeId), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getIdp(String username, Long id) {
        IOriWorkflowService oriWorkflowService = this.getRemoteOriWorkflowService(username);
        return oriWorkflowService.getIdp(id, username);
    }

    private String getReplacedMdEditorUrl(String mdEditorUrl) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getReplacedMdEditorUrl :: mdEditorUrl=" + mdEditorUrl));
            log.debug((Object)("getReplacedMdEditorUrl :: config.getMdEditorFromUrl()=" + this.config.getMdEditorFromUrl()));
            log.debug((Object)("getReplacedMdEditorUrl :: config.getMdEditorToUrl()=" + this.config.getMdEditorToUrl()));
            log.debug((Object)("getReplacedMdEditorUrl :: config.isMdEditorTranslationSet()=" + this.config.isMdEditorTranslationSet()));
        }
        String result = mdEditorUrl;
        if (this.config.isMdEditorTranslationSet()) {
            result = mdEditorUrl.replaceFirst(this.config.getMdEditorFromUrl(), this.config.getMdEditorToUrl());
        }
        return result;
    }

    @Override
    public String getMdeditorUrl(String username, String idp) {
        return this.getMdeditorUrlWS(username, idp);
    }

    public String getMdeditorUrlWS(String username, String idp) {
        IOriWorkflowService oriWorkflowService = this.getRemoteOriWorkflowService(username);
        Map formsMap = oriWorkflowService.getMdEditorUrl(idp);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMdeditorUrlWS :: formsMap.get(0)=" + (String)formsMap.get(0)));
        }
        String result = this.getReplacedMdEditorUrl((String)formsMap.get(0));
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMdeditorUrlWS :: result=" + result));
        }
        return result;
    }

    @Override
    public Map<String, String> getMdeditorUrls(String username, String idp) {
        IOriWorkflowService oriWorkflowService = this.getRemoteOriWorkflowService(username);
        Map formsMap = oriWorkflowService.getMdEditorUrl(idp);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMdeditorUrlWS :: before formsMap=" + formsMap));
        }
        for (String key : formsMap.keySet()) {
            String value = this.getReplacedMdEditorUrl((String)formsMap.get(key));
            if (log.isDebugEnabled()) {
                log.debug((Object)("getMdeditorUrlWS :: put(" + key + ", " + value + ")"));
            }
            formsMap.put(key, value);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMdeditorUrlWS :: after formsMap=" + formsMap));
        }
        return formsMap;
    }

    @Override
    public Map<String, String> getAvailableActions(String username, String idp, String language) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAvailableActions :: idp=" + idp));
            log.debug((Object)("getAvailableActions :: language=" + language));
        }
        IOriWorkflowService oriWorkflowService = this.getRemoteOriWorkflowService(username);
        Map actionsMap = oriWorkflowService.getAvailableActions(idp, language);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAvailableActions :: actionsMap=" + actionsMap));
        }
        return actionsMap;
    }

    @Override
    public boolean performAction(String username, String idp, int actionId, String observation) {
        log.info((Object)("performAction :: idp=" + idp + ", actionId=" + actionId + ", observation=" + observation));
        IOriWorkflowService oriWorkflowService = this.getRemoteOriWorkflowService(username);
        return oriWorkflowService.performAction(idp, actionId, observation);
    }

    @Override
    public String getXMLForms(String username, String idp) {
        IOriWorkflowService oriWorkflowService = this.getRemoteOriWorkflowService(username);
        String xml = oriWorkflowService.getXMLForms(idp);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getXMLForms :: xml=" + xml));
        }
        return xml;
    }

    @Override
    public void saveXML(String username, String idp, String xmlContent) {
        IOriWorkflowService oriWorkflowService = this.getRemoteOriWorkflowService(username);
        oriWorkflowService.saveXML(idp, xmlContent);
    }

    @Override
    public InstanceInfos getInstanceInfos(Long id, String userId, String language) {
        IOriWorkflowService oriWorkflowService = this.getRemoteOriWorkflowService(userId);
        try {
            return oriWorkflowService.getInstanceInfos(id, userId, language);
        }
        catch (SOAPFaultException se) {
            log.warn((Object)(se.getMessage() + " For id " + id));
            log.debug((Object)se, (Throwable)se);
            return null;
        }
    }
}

