/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.esupecm.webapp.action;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.versioning.api.VersioningManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.versioning.VersionedActions;
import org.nuxeo.runtime.api.Framework;
import org.orioai.esupecm.OriOaiMetadataType;
import org.orioai.esupecm.nuxeo2xml.service.OriOaiNuxeo2XmlService;
import org.orioai.esupecm.relations.OriOaiRelationActionsBean;
import org.orioai.esupecm.webapp.action.ReferencingVersion;
import org.orioai.esupecm.workflow.ActionInfo;
import org.orioai.esupecm.workflow.EditorInfo;
import org.orioai.esupecm.workflow.OriOaiDocumentInfo;
import org.orioai.esupecm.workflow.service.OriOaiWorkflowService;
import org.orioai.ws.workflow.InstanceInfos;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="oriManager")
@Transactional
public class WorkflowActions
implements Serializable {
    private boolean useCache = false;
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(WorkflowActions.class);
    protected static final String INIT_ORIWORKFLOW = "INIT_ORIWORKFLOW";
    protected static final String ORI_READ_ONLY = "ORI_READ_ONLY";
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected transient VersionedActions versionedActions;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient VersioningManager versioningManager;
    @In(create=true)
    private OriOaiRelationActionsBean referencingManager;
    @In(create=true)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In
    protected transient Principal currentUser;
    @RequestParameter
    private String oriIdParam;
    @RequestParameter
    private String oriIdpParam;
    @RequestParameter
    private String actionIdParam;
    @RequestParameter
    private String actionNameParam;
    private OriOaiWorkflowService oriOaiWorkflowService = null;
    private Map<String, List<OriOaiMetadataType>> metadataTypes = null;
    Map<String, List<OriOaiDocumentInfo>> oriInfosCache = new HashMap<String, List<OriOaiDocumentInfo>>();
    private boolean callEditor;
    private List<EditorInfo> currentMdEditorUrls;
    private String currentMdEditorIdp;
    private Long currentMdEditorId;
    private DocumentModel currentMdEditorVersionDoc;

    @PrePassivate
    public void prePassivate() {
        log.debug((Object)"prePassivate :: ");
    }

    @PostActivate
    public void postActivate() {
        log.debug((Object)"postActivate :: ");
    }

    @Remove
    @Destroy
    public void destroy() {
        log.debug((Object)"destroy :: ");
    }

    private OriOaiWorkflowService getOriOaiWorkflowService() throws ClientException {
        boolean fail = false;
        if (this.oriOaiWorkflowService == null) {
            try {
                this.oriOaiWorkflowService = (OriOaiWorkflowService)Framework.getService(OriOaiWorkflowService.class);
                if (this.oriOaiWorkflowService == null) {
                    fail = true;
                }
            }
            catch (Exception e) {
                log.error((Object)"can't access Workflow WS", (Throwable)e);
                fail = true;
            }
        }
        if (fail) {
            this.facesMessages.add(FacesMessage.SEVERITY_ERROR, (String)this.resourcesAccessor.getMessages().get("oriref.error.cantaccess.workflow.service"), new Object[0]);
            return null;
        }
        return this.oriOaiWorkflowService;
    }

    private OriOaiNuxeo2XmlService getOriOaiNuxeo2XmlService() throws ClientException {
        OriOaiNuxeo2XmlService service;
        try {
            service = (OriOaiNuxeo2XmlService)Framework.getService(OriOaiNuxeo2XmlService.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        return service;
    }

    public List<OriOaiDocumentInfo> getVersionOriInfos(DocumentModel versionDoc) throws ClientException {
        if (this.useCache && this.oriInfosCache != null && this.oriInfosCache.containsKey(versionDoc.getId())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getVersionOriInfos :: get from cache :: versionDoc.getId()=" + versionDoc.getId()));
            }
            return this.oriInfosCache.get(versionDoc.getId());
        }
        List<String> oriIdProp = this.referencingManager.getOriIdsForDocument(versionDoc);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getVersionOriInfos :: update cache :: versionDoc.getId()=" + versionDoc.getId() + ", oriIdProp=" + oriIdProp));
        }
        return this.updateOriInfoCache(versionDoc, oriIdProp);
    }

    public List<OriOaiDocumentInfo> fetchOriInfosOld(DocumentModel currentDoc, List<String> oriIdProp) throws ClientException {
        ArrayList<OriOaiDocumentInfo> oriInfos = new ArrayList<OriOaiDocumentInfo>();
        OriOaiWorkflowService oriOaiWorkflowService = this.getOriOaiWorkflowService();
        if (oriIdProp != null) {
            for (String oriIdString : oriIdProp) {
                Long oriId = Long.parseLong(oriIdString);
                OriOaiMetadataType metadataType = null;
                Vector<String> states = null;
                List<String> informations = null;
                List<EditorInfo> mdEditorUrls = null;
                List<ActionInfo> actions = null;
                boolean deletableRelation = false;
                String idp = null;
                if (oriOaiWorkflowService != null) {
                    idp = oriOaiWorkflowService.getIdp(this.currentUser.getName(), oriId);
                    if (idp != null) {
                        metadataType = oriOaiWorkflowService.getMetadataType(this.currentUser.getName(), idp);
                        if (metadataType != null) {
                            String language = FacesContext.getCurrentInstance().getViewRoot().getLocale().getLanguage();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("fetchOriInfos :: language=" + language));
                            }
                            Map<String, String> statesMap = oriOaiWorkflowService.getCurrentStates(this.currentUser.getName(), idp, language);
                            states = new Vector<String>();
                            for (String key : statesMap.keySet()) {
                                states.add(statesMap.get(key));
                            }
                            informations = oriOaiWorkflowService.getCurrentInformations(this.currentUser.getName(), idp, language);
                            Map<String, String> mdEditorUrlsMap = oriOaiWorkflowService.getMdeditorUrls(this.currentUser.getName(), idp);
                            mdEditorUrls = this.getMdEditorInfos(mdEditorUrlsMap);
                            Map<String, String> actionsMap = oriOaiWorkflowService.getAvailableActions(this.currentUser.getName(), idp, language);
                            actions = this.getActions(actionsMap);
                        } else {
                            log.warn((Object)("fetchOriInfos :: metadataType is null for ORI ID " + oriId));
                            deletableRelation = true;
                        }
                    } else {
                        log.warn((Object)("fetchOriInfos :: idp is null for ORI ID " + oriId));
                        deletableRelation = true;
                    }
                } else {
                    log.warn((Object)"fetchOriInfos :: Workflow Web Service is NULL : ori infos unavailable");
                }
                if (!deletableRelation) {
                    OriOaiDocumentInfo newOriInfo = new OriOaiDocumentInfo(oriId, metadataType, states, idp, mdEditorUrls, actions, informations);
                    newOriInfo.setProxyTitle(currentDoc.getTitle());
                    DocumentRef parentRef = currentDoc.getParentRef();
                    DocumentModel section = this.documentManager.getDocument(parentRef);
                    newOriInfo.setSectionTitle(section.getTitle());
                    newOriInfo.setDeletableRelation(deletableRelation);
                    oriInfos.add(newOriInfo);
                    continue;
                }
                log.warn((Object)("fetchOriInfos :: delete relation for ORI ID " + oriId));
                try {
                    this.referencingManager.deleteOriRelation(oriId, currentDoc);
                    Object[] params = new Object[2];
                    params[0] = this.versioningManager.getVersionLabel(currentDoc);
                    this.facesMessages.add(FacesMessage.SEVERITY_WARN, (String)this.resourcesAccessor.getMessages().get("oriref.error.relation.deleted"), params);
                }
                catch (Exception e) {
                    log.error((Object)("fetchOriInfos :: can't delete relation for ORI ID " + oriId), (Throwable)e);
                }
            }
        } else {
            log.warn((Object)"fetchOriInfos :: list of ORI ID is NULL");
        }
        return oriInfos;
    }

    protected OriOaiDocumentInfo getDocumentInfo(InstanceInfos infos) {
        OriOaiDocumentInfo newOriInfo = null;
        OriOaiMetadataType metadataType = null;
        List<String> states = null;
        List<String> informations = null;
        List<EditorInfo> mdEditorUrls = null;
        List<ActionInfo> actions = null;
        metadataType = new OriOaiMetadataType(infos.getMetadataType(), infos.getMetadataTypeLabel());
        states = this.oriOaiWorkflowService.getCurrentStates(infos.getStatesMap());
        informations = this.oriOaiWorkflowService.getCurrentInformations(infos.getCurrentInformations());
        mdEditorUrls = this.getMdEditorInfos(infos.getMdEditorUrlsMap());
        actions = this.getActions(infos.getActionsMap());
        newOriInfo = new OriOaiDocumentInfo(infos.getOriId(), metadataType, states, infos.getIdp(), mdEditorUrls, actions, informations);
        return newOriInfo;
    }

    public List<OriOaiDocumentInfo> fetchOriInfos(DocumentModel currentDoc, List<String> oriIdProp) throws ClientException {
        ArrayList<OriOaiDocumentInfo> oriInfos = new ArrayList<OriOaiDocumentInfo>();
        OriOaiWorkflowService oriOaiWorkflowService = this.getOriOaiWorkflowService();
        if (oriIdProp == null) {
            log.warn((Object)"fetchOriInfos :: list of ORI ID is NULL");
        } else if (oriOaiWorkflowService == null) {
            log.warn((Object)"fetchOriInfos :: Workflow Web Service is NULL : ori infos unavailable");
        } else {
            for (String oriIdString : oriIdProp) {
                Long oriId = Long.parseLong(oriIdString);
                String language = FacesContext.getCurrentInstance().getViewRoot().getLocale().getLanguage();
                InstanceInfos infos = oriOaiWorkflowService.getInstanceInfos(oriId, this.currentUser.getName(), language);
                boolean deletableRelation = false;
                if (infos != null) {
                    OriOaiDocumentInfo newOriInfo = this.getDocumentInfo(infos);
                    newOriInfo.setProxyTitle(currentDoc.getTitle());
                    DocumentRef parentRef = currentDoc.getParentRef();
                    DocumentModel section = this.documentManager.getDocument(parentRef);
                    newOriInfo.setSectionTitle(section.getTitle());
                    newOriInfo.setDeletableRelation(deletableRelation);
                    oriInfos.add(newOriInfo);
                } else {
                    log.warn((Object)("fetchOriInfos :: instanceInfos is null for ORI ID " + oriId));
                }
                if (!deletableRelation) continue;
                log.warn((Object)("fetchOriInfos :: delete relation for ORI ID " + oriId));
                try {
                    this.referencingManager.deleteOriRelation(oriId, currentDoc);
                    Object[] params = new Object[2];
                    params[0] = this.versioningManager.getVersionLabel(currentDoc);
                    this.facesMessages.add(FacesMessage.SEVERITY_WARN, (String)this.resourcesAccessor.getMessages().get("oriref.error.relation.deleted"), params);
                }
                catch (Exception e) {
                    log.error((Object)("fetchOriInfos :: can't delete relation for ORI ID " + oriId), (Throwable)e);
                }
            }
        }
        return oriInfos;
    }

    public List<OriOaiDocumentInfo> updateOriInfoCache(DocumentModel currentDoc, List<String> oriIdProp) throws ClientException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateOriInfoCache :: currentDoc.getId()=" + currentDoc.getId()));
            log.debug((Object)("updateOriInfoCache :: oriIdProp=" + oriIdProp));
        }
        List<OriOaiDocumentInfo> oriInfos = this.fetchOriInfos(currentDoc, oriIdProp);
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateOriInfoCache :: oriInfos=" + oriInfos));
        }
        if (!this.useCache) {
            return oriInfos;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateOriInfoCache :: oriInfosCache=" + this.oriInfosCache));
        }
        if (this.oriInfosCache == null) {
            this.oriInfosCache = new HashMap<String, List<OriOaiDocumentInfo>>();
        }
        if (this.oriInfosCache.containsKey(currentDoc.getId())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("updateOriInfoCache :: oriInfosCache contains " + currentDoc.getId()));
            }
            List<OriOaiDocumentInfo> oldInfos = this.oriInfosCache.remove(currentDoc.getId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("updateOriInfoCache :: oldInfos=" + oldInfos));
            }
            for (int old = 0; oldInfos != null && old < oldInfos.size(); ++old) {
                OriOaiDocumentInfo oldInfo = oldInfos.get(old);
                boolean found = false;
                for (int up = 0; !found && oriInfos != null && up < oriInfos.size(); ++up) {
                    OriOaiDocumentInfo docInfo = oriInfos.get(up);
                    found = docInfo.getOriId().equals(oldInfo.getOriId());
                }
                if (found) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("updateOriInfoCache :: add to oriInfos oldInfo=" + oldInfo));
                }
                oriInfos.add(oldInfo);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("updateOriInfoCache :: oriInfosCache doesn't contain " + currentDoc.getId()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateOriInfoCache :: put to oriInfosCache currentDoc.getId()=" + currentDoc.getId() + ", oriInfos=" + oriInfos));
        }
        this.oriInfosCache.put(currentDoc.getId(), oriInfos);
        return oriInfos;
    }

    protected List<EditorInfo> getMdEditorInfos(Map<String, String> mdEditorUrlsMap) {
        ArrayList<EditorInfo> result = new ArrayList<EditorInfo>();
        for (Map.Entry<String, String> entry : mdEditorUrlsMap.entrySet()) {
            if (entry.getKey() == null) continue;
            result.add(new EditorInfo(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    protected List<ActionInfo> getActions(Map<String, String> actionsMap) {
        ArrayList<ActionInfo> result = new ArrayList<ActionInfo>();
        for (Map.Entry<String, String> entry : actionsMap.entrySet()) {
            if (entry.getKey() == null) continue;
            result.add(new ActionInfo(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public List<Action> getActionsForInitOriWorkflow() throws ClientException {
        List actions = this.webActions.getActionsList(INIT_ORIWORKFLOW);
        for (Action action : actions) {
            action.setAvailable(true);
        }
        return actions;
    }

    public boolean getCanUnpublish() throws ClientException {
        log.debug((Object)"getCanUnpublish :: CANUNPUBLISH evaluation");
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        List<String> oriIds = this.getOriIds(currentDoc);
        return oriIds == null || oriIds.isEmpty();
    }

    public List<String> getOriIds(DocumentModel doc) throws ClientException {
        return this.referencingManager.getOriIdsForDocument(doc);
    }

    protected OriOaiMetadataType getMetadataType(String metaId) throws ClientException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMetadataType :: metaId=" + metaId));
        }
        for (OriOaiMetadataType type : this.getMetadataTypes()) {
            if (!type.getId().equals(metaId)) continue;
            return type;
        }
        return null;
    }

    public String processWorkflowAction(DocumentModel versionDoc) throws ClientException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("processWorkflowAction :: actionNameParam=" + this.actionNameParam + ", oriIdParam=" + this.oriIdParam));
        }
        if (this.actionIdParam != null && this.oriIdParam != null) {
            OriOaiWorkflowService oriOaiWorkflowService = this.getOriOaiWorkflowService();
            int actionId = Integer.parseInt(this.actionIdParam);
            if (log.isDebugEnabled()) {
                log.debug((Object)("processWorkflowAction :: actionId=" + actionId));
            }
            String observation = (String)this.resourcesAccessor.getMessages().get("oriref.action.performed.observation");
            if (log.isDebugEnabled()) {
                log.debug((Object)("processWorkflowAction :: observation=" + observation));
            }
            boolean performActionResult = oriOaiWorkflowService.performAction(this.currentUser.getName(), this.oriIdpParam, actionId, observation);
            ArrayList<String> oriIdProp = new ArrayList<String>();
            oriIdProp.add(this.oriIdParam);
            if (log.isDebugEnabled()) {
                log.debug((Object)("processWorkflowAction :: oriIdProp=" + oriIdProp));
            }
            if (performActionResult) {
                String msg = (String)this.resourcesAccessor.getMessages().get("oriref.action.performed.success");
                this.facesMessages.add(FacesMessage.SEVERITY_INFO, msg + this.actionNameParam, new Object[0]);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("processWorkflowAction :: performActionResult=" + performActionResult + " --> add message=" + msg + this.actionNameParam));
                }
                this.updateOriInfoCache(versionDoc, oriIdProp);
                return null;
            }
            String msg = (String)this.resourcesAccessor.getMessages().get("oriref.action.performed.failure");
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, msg + this.actionNameParam, new Object[0]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("processWorkflowAction :: performActionResult=" + performActionResult + " --> add message=" + msg + this.actionNameParam));
            }
            this.updateOriInfoCache(versionDoc, oriIdProp);
            return null;
        }
        return null;
    }

    public void initOriWorkflow(DocumentModel versionToRef, String selectedMetadataType, String callEditor) throws ClientException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("initOriWorkflow :: selectedMetatypes=" + selectedMetadataType + ", callEditor=" + callEditor));
        }
        HashMap<String, String> oriIdsMap = new HashMap<String, String>();
        Long oriId = this.initWorkflow(versionToRef, selectedMetadataType);
        if (oriId != null) {
            oriIdsMap.put(oriId.toString(), selectedMetadataType);
        }
        this.createNewReferencedRelations(versionToRef, oriIdsMap);
        this.updateOriInfoCache(versionToRef, new ArrayList<String>(oriIdsMap.keySet()));
        Object[] params = new Object[]{versionToRef.getName(), this.getMetadataType(selectedMetadataType).getLabel()};
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("oriref.report"), params);
    }

    protected String createNewReferencedRelations(DocumentModel versionDocu, Map<String, String> orIdsToRef) throws ClientException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("initOriWorkflow :: set the property oriId and create a versionproxyDoc.ref : " + versionDocu.getRef() + " oriIdsToRef : " + orIdsToRef.toString()));
        }
        String refMessage = "";
        try {
            for (Map.Entry<String, String> oriIdToRef : orIdsToRef.entrySet()) {
                String mesgStatus = this.referencingManager.createOriRelation(oriIdToRef.getKey(), versionDocu, oriIdToRef.getValue());
                refMessage = refMessage + "\n" + (String)this.resourcesAccessor.getMessages().get(mesgStatus);
            }
        }
        catch (Exception e) {
            log.error((Object)"createNewReferencedRelations :: can't create relation for referencing", (Throwable)e);
        }
        return refMessage;
    }

    protected Long initWorkflow(DocumentModel proxyDoc, String type) throws ClientException {
        String debug = "proxyDoc.ref : " + proxyDoc.getRef() + " metadata Type id  : " + type;
        String metadataTypeId = type;
        log.info((Object)("initWorkflow :: try to init a new ori-oai workflow (metadataTypeId=" + metadataTypeId + ") ..."));
        if (this.documentManager.getLock(proxyDoc.getRef()) != null) {
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, (String)this.resourcesAccessor.getMessages().get("error.document.locked.for.publish"), new Object[0]);
            return null;
        }
        try {
            OriOaiWorkflowService oriOaiWorkflowService = this.getOriOaiWorkflowService();
            Long oriWorkflowId = oriOaiWorkflowService.newWorkflowInstance(this.currentUser.getName(), metadataTypeId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("initWorkflow :: metadataTypeId=" + metadataTypeId + ", currentUser.getName()=" + this.currentUser.getName() + " --> oriWorkflowId=" + oriWorkflowId));
            }
            String idp = oriOaiWorkflowService.getIdp(this.currentUser.getName(), oriWorkflowId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("initWorkflow :: idp=" + idp));
            }
            String xmlFromWorkflow = oriOaiWorkflowService.getXMLForms(this.currentUser.getName(), idp);
            OriOaiNuxeo2XmlService oriOaiNuxeo2XmlService = this.getOriOaiNuxeo2XmlService();
            String metadataSchemaNamespace = oriOaiWorkflowService.getMetadataSchemaNamespace(this.currentUser.getName(), metadataTypeId);
            String mergedXmlContent = oriOaiNuxeo2XmlService.mergeXmlDoc(this.documentManager, proxyDoc, metadataSchemaNamespace, xmlFromWorkflow);
            if (log.isDebugEnabled()) {
                log.debug((Object)("initWorkflow :: mergedXmlContent=" + mergedXmlContent));
            }
            oriOaiWorkflowService.saveXML(this.currentUser.getName(), idp, mergedXmlContent);
            log.debug((Object)"initWorkflow :: mergedXmlContent saved");
            Map<String, String> mdEditorUrlsMap = oriOaiWorkflowService.getMdeditorUrls(this.currentUser.getName(), idp);
            if (log.isDebugEnabled()) {
                log.debug((Object)("initWorkflow :: mdEditorUrlsMap=" + mdEditorUrlsMap));
            }
            this.processCallEditor(idp, oriWorkflowId, proxyDoc, this.getMdEditorInfos(mdEditorUrlsMap));
            return oriWorkflowId;
        }
        catch (Exception e) {
            log.error((Object)("fail to init ori workflow : " + debug), (Throwable)e);
            return null;
        }
    }

    public int getVersionsCount() throws ClientException {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        List versions = this.documentManager.getVersionsForDocument(doc.getRef());
        if (versions != null) {
            return versions.size();
        }
        return 0;
    }

    public Collection<ReferencingVersion> getVersionsReferencedModel() throws ClientException {
        HashMap<String, ReferencingVersion> versionsProxiesModelMap = new HashMap<String, ReferencingVersion>();
        log.debug((Object)"");
        log.debug((Object)"");
        log.debug((Object)"getVersionsReferencedModel :: BEGIN METHOD");
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getVersionsReferencedModel :: doc.getId()=" + doc.getId()));
            log.debug((Object)("getVersionsReferencedModel :: doc=" + doc));
        }
        List versions = this.documentManager.getVersionsForDocument(doc.getRef());
        if (log.isDebugEnabled()) {
            log.debug((Object)("getVersionsReferencedModel :: versions=" + versions));
        }
        for (VersionModel versionModel : versions) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getVersionsReferencedModel");
                log.debug((Object)("getVersionsReferencedModel :: doc.getRef()=" + doc.getRef()));
            }
            DocumentModel versionDoc = this.documentManager.getDocumentWithVersion(doc.getRef(), versionModel);
            if (log.isDebugEnabled()) {
                log.debug((Object)("getVersionsReferencedModel :: versionDoc.getId()=" + versionDoc.getId()));
            }
            if (versionDoc != null) {
                String versionLabel = this.versioningManager.getVersionLabel(versionDoc);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getVersionsReferencedModel :: versionLabel=" + versionLabel));
                }
                if (!versionsProxiesModelMap.containsKey(versionDoc.getId())) {
                    List<OriOaiDocumentInfo> allProxyOriInfos = this.getVersionOriInfos(versionDoc);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getVersionsReferencedModel :: allProxyOriInfos=" + allProxyOriInfos));
                    }
                    ReferencingVersion referencingVersion = new ReferencingVersion(versionLabel, versionDoc, versionModel, allProxyOriInfos);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getVersionsReferencedModel :: versionDoc.getId()=" + versionDoc.getId()));
                    }
                    versionsProxiesModelMap.put(versionDoc.getId(), referencingVersion);
                }
            }
            log.debug((Object)"getVersionsReferencedModel");
        }
        log.debug((Object)"getVersionsReferencedModel :: END METHOD");
        log.debug((Object)"");
        log.debug((Object)"");
        Collection result = versionsProxiesModelMap.values();
        ArrayList<ReferencingVersion> versionsList = new ArrayList<ReferencingVersion>(result);
        Collections.sort(versionsList);
        return versionsList;
    }

    public List<OriOaiMetadataType> getReferencableMetadataTypes(DocumentModel versionDoc) throws ClientException {
        if (versionDoc.hasFacet(ORI_READ_ONLY)) {
            return Collections.emptyList();
        }
        log.debug((Object)"getReferencableMetadataTypes :: ");
        List<OriOaiDocumentInfo> selectedProxyOriInfos = this.getVersionOriInfos(versionDoc);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getReferencableMetadataTypes :: selectedProxyOriInfos=" + selectedProxyOriInfos));
        }
        ArrayList<OriOaiMetadataType> availTypes = new ArrayList<OriOaiMetadataType>(this.getMetadataTypes());
        if (log.isDebugEnabled()) {
            log.debug((Object)("getReferencableMetadataTypes :: availTypes=" + availTypes));
        }
        block0: for (OriOaiDocumentInfo oriInfo : selectedProxyOriInfos) {
            for (OriOaiMetadataType availType : availTypes) {
                if (!availType.getId().equals(oriInfo.getMetadataType().getId())) continue;
                availTypes.remove(availType);
                continue block0;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getReferencableMetadataTypes :: availTypes=" + availTypes));
        }
        return availTypes;
    }

    public Map<String, String> getReferencableMetadataTypesMap(DocumentModel versionDoc) throws ClientException {
        log.debug((Object)"getReferencableMetadataTypesMap :: BEGIN");
        List<OriOaiMetadataType> metadataTypes = this.getReferencableMetadataTypes(versionDoc);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getReferencableMetadataTypesMap :: metadataTypes=" + metadataTypes));
        }
        HashMap<String, String> metadataTypesMap = new HashMap<String, String>(metadataTypes.size());
        for (OriOaiMetadataType metadataType : metadataTypes) {
            metadataTypesMap.put(metadataType.getLabel(), metadataType.getId());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getReferencableMetadataTypesMap :: metadataTypesMap=" + metadataTypesMap));
        }
        log.debug((Object)"getReferencableMetadataTypesMap :: END");
        return metadataTypesMap;
    }

    public List<OriOaiMetadataType> getMetadataTypes() throws ClientException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMetadataTypes :: 1 metadataTypes=" + this.metadataTypes));
        }
        if (this.metadataTypes == null) {
            this.metadataTypes = new HashMap<String, List<OriOaiMetadataType>>();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMetadataTypes :: 2 metadataTypes=" + this.metadataTypes));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMetadataTypes :: 3 currentUser.getName()=" + this.currentUser.getName()));
        }
        List<OriOaiMetadataType> userMetadataTypes = this.metadataTypes.get(this.currentUser.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMetadataTypes :: 4 userMetadataTypes=" + userMetadataTypes));
        }
        if (userMetadataTypes == null) {
            userMetadataTypes = this.getOriOaiWorkflowService().getMetadataTypes(this.currentUser.getName());
            this.metadataTypes.put(this.currentUser.getName(), userMetadataTypes);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMetadataTypes :: 5 userMetadataTypes=" + userMetadataTypes));
        }
        return userMetadataTypes;
    }

    public boolean getCanReferencePublication(DocumentModel versionDocument) throws ClientException {
        List<OriOaiMetadataType> avails = this.getReferencableMetadataTypes(versionDocument);
        return avails != null && !avails.isEmpty();
    }

    public String processCallEditor(String idp, Long id, DocumentModel versionDoc, EditorInfo mdEditorUrl) {
        ArrayList<EditorInfo> urls = new ArrayList<EditorInfo>();
        urls.add(mdEditorUrl);
        this.processCallEditor(idp, id, versionDoc, urls);
        return null;
    }

    public String processCallEditor(String idp, Long id, DocumentModel versionDoc, List<EditorInfo> urls) {
        this.currentMdEditorIdp = idp;
        this.currentMdEditorId = id;
        this.currentMdEditorVersionDoc = versionDoc;
        this.callEditor = true;
        this.currentMdEditorUrls = urls;
        if (log.isDebugEnabled()) {
            log.debug((Object)("processCallEditor :: this.callEditor=" + this.callEditor + "; this.currentMdEditorId=" + this.currentMdEditorId + "; this.currentMdEditorIdp=" + this.currentMdEditorIdp));
        }
        return null;
    }

    public boolean getCallEditor() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCallEditor :: this.callEditor=" + this.callEditor + "; this.currentMdEditorId=" + this.currentMdEditorId + "; this.currentMdEditorIdp=" + this.currentMdEditorIdp));
        }
        if (this.callEditor) {
            this.callEditor = false;
            return true;
        }
        return false;
    }

    public List<EditorInfo> getCurrentMdEditorUrls() throws ClientException {
        if (this.currentMdEditorUrls != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getCurrentMdEditorUrls :: currentMdEditorUrls is not null :: currentMdEditorUrls=" + this.currentMdEditorUrls));
            }
        } else {
            log.debug((Object)"getCurrentMdEditorUrls :: currentMdEditorUrls is null");
            OriOaiWorkflowService oriOaiWorkflowService = this.getOriOaiWorkflowService();
            if (log.isDebugEnabled()) {
                log.debug((Object)("getCurrentMdEditorUrls :: this.currentMdEditorId=" + this.currentMdEditorId));
                log.debug((Object)("getCurrentMdEditorUrls :: this.currentMdEditorIdp=" + this.currentMdEditorIdp));
            }
            Map<String, String> mdEditorUrlsMap = oriOaiWorkflowService.getMdeditorUrls(this.currentUser.getName(), this.currentMdEditorIdp);
            if (log.isDebugEnabled()) {
                log.debug((Object)("getCurrentMdEditorUrls :: mdEditorUrlsMap=" + mdEditorUrlsMap));
            }
            this.currentMdEditorUrls = this.getMdEditorInfos(mdEditorUrlsMap);
        }
        return this.currentMdEditorUrls;
    }

    public String getCurrentMdEditorIdp() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCurrentMdEditorIdp :: this.currentMdEditorIdp=" + this.currentMdEditorIdp));
        }
        return this.currentMdEditorIdp;
    }

    public Long getCurrentMdEditorId() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCurrentMdEditorId :: this.currentMdEditorId=" + this.currentMdEditorId));
        }
        return this.currentMdEditorId;
    }

    public DocumentModel getCurrentMdEditorVersionDoc() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCurrentMdEditorVersionDoc :: this.currentMdEditorVersionDoc=" + this.currentMdEditorVersionDoc));
        }
        return this.currentMdEditorVersionDoc;
    }

    public String backFromEditor() throws ClientException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("backFromEditor :: currentMdEditorId=" + this.currentMdEditorId));
        }
        ArrayList<String> oriIdProp = new ArrayList<String>();
        oriIdProp.add(this.currentMdEditorId + "");
        if (log.isDebugEnabled()) {
            log.debug((Object)("backFromEditor :: oriIdProp=" + oriIdProp));
            log.debug((Object)("backFromEditor :: currentMdEditorVersionDoc=" + this.currentMdEditorVersionDoc));
        }
        this.updateOriInfoCache(this.currentMdEditorVersionDoc, oriIdProp);
        log.debug((Object)"backFromEditor :: updated cache");
        return null;
    }
}

