/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.esupecm.relations;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.impl.LiteralImpl;
import org.nuxeo.ecm.platform.relations.web.StatementInfo;
import org.orioai.esupecm.relations.CustomRelationActions;
import org.orioai.esupecm.relations.OriOaiRelationActions;

@Name(value="referencingManager")
@Scope(value=ScopeType.CONVERSATION)
public class OriOaiRelationActionsBean
extends CustomRelationActions
implements OriOaiRelationActions {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(OriOaiRelationActionsBean.class);
    public static final String RELATION_DC_REFERENCES = "http://purl.org/dc/terms/References";

    @Override
    public String createOriRelation(String oriId, DocumentModel docToRefer, String metadataTypeLabel) throws ClientException {
        this.setPredicateUri(RELATION_DC_REFERENCES);
        this.setObjectType("literal");
        this.setObjectLiteralValue(oriId);
        String comment = "ORIOAI Referencement : " + metadataTypeLabel;
        this.setComment(comment);
        String result = this.addStatement(docToRefer);
        if ("document_relations".equals(result)) {
            result = "ori_view";
        }
        result = "ori_view";
        return result;
    }

    @Override
    public void deleteOriRelation(Long oriId, DocumentModel document) throws ClientException {
        this.resetStatements();
        log.info((Object)("removeOriRelation :: oriId=" + oriId));
        List<StatementInfo> statementInfos = this.getOutgoingStatementsInfo(document);
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeOriRelation :: statementInfos=" + statementInfos));
        }
        if (statementInfos != null && statementInfos.size() > 0) {
            ArrayList<StatementInfo> statementsToDelete = new ArrayList<StatementInfo>();
            for (int i = 0; i < statementInfos.size(); ++i) {
                StatementInfo info = statementInfos.get(i);
                Node object = info.getObject();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("removeOriRelation :: object=" + object));
                }
                if (object == null || !(object instanceof LiteralImpl)) continue;
                String oriIds = "" + oriId;
                String objectValue = ((LiteralImpl)object).getValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("removeOriRelation :: oriIds=" + oriIds + ", objectValue=" + objectValue));
                }
                if (!oriIds.equals(objectValue)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("removeOriRelation :: EQUALS oriId=" + oriId));
                }
                statementsToDelete.add(info);
            }
            for (StatementInfo info : statementsToDelete) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("removeOriRelation :: delete " + info));
                }
                this.deleteStatement(info, document);
            }
        }
    }

    @Override
    public List<String> getOriIdsForDocument(DocumentModel document) throws ClientException {
        this.resetStatements();
        List<StatementInfo> statementInfos = this.getOutgoingStatementsInfo(document);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getOriIdsForDocument :: statementInfos=" + statementInfos));
        }
        ArrayList<String> result = new ArrayList<String>();
        if (statementInfos != null && statementInfos.size() > 0) {
            for (StatementInfo info : statementInfos) {
                String oriId;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getOriIdsForDocument :: info=" + info));
                }
                Node object = info.getObject();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getOriIdsForDocument :: object=" + object));
                }
                if (object == null || !(object instanceof LiteralImpl) || (oriId = ((LiteralImpl)object).getValue()) == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getOriIdsForDocument :: oriId=" + oriId));
                }
                result.add(oriId);
            }
        }
        return result;
    }
}

