/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.ws.vocabulary;

import com.mycila.xmltool.XMLDoc;
import com.mycila.xmltool.XMLTag;
import fj.F;
import fj.F2;
import fj.P2;
import fj.Unit;
import fj.data.IterableW;
import fj.data.Option;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.jaxrs.client.ClientWebApplicationException;
import org.apache.cxf.jaxrs.client.WebClient;
import org.orioai.commons.vocabulary.service.exceptions.NotFoundVocabularyException;
import org.orioai.commons.vocabulary.service.exceptions.VocabularyException;
import org.orioai.ws.vocabulary.IVocabularyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestCxfVocabularyService
implements IVocabularyService {
    private WebClient client;
    private long waitTimeoutMillis = 1800000L;
    private static Logger log = LoggerFactory.getLogger(RestCxfVocabularyService.class);

    public RestCxfVocabularyService(String url) {
        this.client = WebClient.create((String)url);
        WebClient.getConfig((Object)this.client).getHttpConduit().getClient().setReceiveTimeout(this.waitTimeoutMillis);
    }

    private F<P2<String, String>, String> concatP2(final String sep) {
        return new F<P2<String, String>, String>(){

            public String f(P2<String, String> pair) {
                return (String)pair._1() + sep + (String)pair._2();
            }
        };
    }

    private F2<String, String, String> concat(final String sep) {
        return new F2<String, String, String>(){

            public String f(String a, String b) {
                return a + sep + b;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Option<String> callClient(F<Unit, Response> call) {
        String result = null;
        try {
            Response resp = (Response)call.f((Object)Unit.unit());
            if (resp != null && (result = IOUtils.toString((InputStream)((InputStream)resp.getEntity()), (String)"utf-8")) != null) {
                result = result.trim();
            }
            if (resp == null || resp.getStatus() == 404 || resp.getStatus() == 503) {
                throw new NotFoundVocabularyException();
            }
        }
        catch (ClientWebApplicationException e) {
            log.debug("callClient :: ClientWebApplicationException --> throw new VocabularyException", (Throwable)e);
            throw new VocabularyException();
        }
        catch (IOException e) {
            log.warn("callClient :: IOException", (Throwable)e);
        }
        finally {
            this.client.reset();
        }
        return result == null ? Option.none() : Option.some((Object)result);
    }

    protected String getXml(final String path, final Object[] pathValues, Map<String, String> params) {
        final String concatParams = params != null ? (String)IterableW.wrap((Iterable)IterableW.wrap(params.keySet()).zip(params.values())).map(this.concatP2("=")).foldLeft1(this.concat("&")) : null;
        String result = null;
        boolean firstCall = true;
        NotFoundVocabularyException catchedException = null;
        long startCallTimeMillis = System.currentTimeMillis();
        while ((result == null || "".equals(result)) && System.currentTimeMillis() < startCallTimeMillis + this.waitTimeoutMillis) {
            if (!firstCall) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            try {
                result = (String)this.callClient(new F<Unit, Response>(){

                    public Response f(Unit u) {
                        return RestCxfVocabularyService.this.client.path(path, pathValues).replaceQuery(concatParams).get();
                    }
                }).orSome((Object)"");
                catchedException = null;
            }
            catch (NotFoundVocabularyException e) {
                result = null;
                catchedException = e;
            }
            firstCall = false;
        }
        if (result == null || "".equals(result)) {
            if (catchedException != null) {
                throw catchedException;
            }
            throw new NotFoundVocabularyException();
        }
        return result;
    }

    protected String postXml(final String path, final Object[] pathValues, final String payload) {
        return (String)this.callClient(new F<Unit, Response>(){

            public Response f(Unit u) {
                return RestCxfVocabularyService.this.client.path(path, pathValues).post((Object)payload);
            }
        }).orSome((Object)"");
    }

    @Override
    public String getVocabulary(String vocabularyId) {
        return this.getXml("{folder}/{xqueryReq}", new String[]{vocabularyId, vocabularyId + ".xml"}, null);
    }

    @Override
    public List<String> getVocabulariesId() {
        return IterableW.wrap((Iterable)XMLDoc.from((String)this.getXml("", new String[0], null), (boolean)false).getChilds("exist:collection/exist:collection", new Object[0])).map((F)new F<XMLTag, String>(){

            public String f(XMLTag tag) {
                return tag.findAttribute("name");
            }
        }).toStandardList();
    }

    @Override
    public List<String> getVocabularies(List<String> vocabularyIds) {
        return IterableW.wrap(vocabularyIds).map((F)new F<String, String>(){

            public String f(String vocId) {
                return RestCxfVocabularyService.this.getVocabulary(vocId);
            }
        }).toStandardList();
    }

    @Override
    public String xquery(String vocId) {
        return this.getXml("{folder}/{xqueryReq}", new String[]{vocId, vocId + ".xq"}, null);
    }

    @Override
    public String xquery(String vocId, String queryName) {
        return this.getXml("{folder}/{xqueryReq}", new String[]{vocId, queryName + ".xq"}, null);
    }

    @Override
    public String xquery(String vocId, Map<String, String> params) {
        return this.getXml("{folder}/{xqueryReq}", new String[]{vocId, vocId + ".xq"}, params);
    }

    @Override
    public String xquery(String vocId, String queryName, Map<String, String> params) {
        return this.getXml("{folder}/{xqueryReq}", new String[]{vocId, queryName + ".xq"}, params);
    }

    @Override
    public String pxquery(String vocId, String payload) {
        return this.postXml("{folder}/{xqueryReq}", new String[]{vocId, vocId + ".xq"}, payload);
    }

    @Override
    public String pxquery(String vocId, String queryName, String payload) {
        return this.postXml("{folder}/{xqueryReq}", new String[]{vocId, queryName + ".xq"}, payload);
    }
}

